/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.fx;

import com.mojang.nbt.CompoundTag;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntityFX
extends Entity {
    protected int particleTextureIndex;
    protected float particleTextureJitterX;
    protected float particleTextureJitterY;
    protected int particleAge = 0;
    protected int particleMaxAge = 0;
    protected float particleScale;
    protected float particleGravity;
    protected float particleRed;
    protected float particleGreen;
    protected float particleBlue;
    public static double lerpPosX;
    public static double lerpPosY;
    public static double lerpPosZ;

    public EntityFX(World world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world);
        this.setSize(0.2f, 0.2f);
        this.heightOffset = this.bbHeight / 2.0f;
        this.setPos(x, y, z);
        this.particleBlue = 1.0f;
        this.particleGreen = 1.0f;
        this.particleRed = 1.0f;
        this.xd = motionX + (double)((float)(Math.random() * 2.0 - 1.0) * 0.4f);
        this.yd = motionY + (double)((float)(Math.random() * 2.0 - 1.0) * 0.4f);
        this.zd = motionZ + (double)((float)(Math.random() * 2.0 - 1.0) * 0.4f);
        float f = (float)(Math.random() + Math.random() + 1.0) * 0.15f;
        float f1 = MathHelper.sqrt_double(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd);
        this.xd = this.xd / (double)f1 * (double)f * (double)0.4f;
        this.yd = this.yd / (double)f1 * (double)f * (double)0.4f + (double)0.1f;
        this.zd = this.zd / (double)f1 * (double)f * (double)0.4f;
        this.particleTextureJitterX = this.random.nextFloat() * 3.0f;
        this.particleTextureJitterY = this.random.nextFloat() * 3.0f;
        this.particleScale = (this.random.nextFloat() * 0.5f + 0.5f) * 2.0f;
        this.particleMaxAge = (int)(4.0f / (this.random.nextFloat() * 0.9f + 0.1f));
        this.particleAge = 0;
    }

    @Override
    public boolean isInWaterOrRain() {
        return false;
    }

    public EntityFX func_407_b(float f) {
        this.xd *= (double)f;
        this.yd = (this.yd - (double)0.1f) * (double)f + (double)0.1f;
        this.zd *= (double)f;
        return this;
    }

    public EntityFX func_405_d(float f) {
        this.setSize(0.2f * f, 0.2f * f);
        this.particleScale *= f;
        return this;
    }

    @Override
    protected boolean makeStepSound() {
        return false;
    }

    @Override
    protected void init() {
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.remove();
        }
        this.yd -= 0.04 * (double)this.particleGravity;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.98f;
        this.yd *= (double)0.98f;
        this.zd *= (double)0.98f;
        if (this.onGround) {
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
        }
    }

    public void renderParticle(Tessellator t, float partialTick, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        float texMinU = (float)(this.particleTextureIndex % 16) / 16.0f;
        float texMaxU = texMinU + 0.0624375f;
        float texMinV = (float)(this.particleTextureIndex / 16) / 16.0f;
        float texMaxV = texMinV + 0.0624375f;
        float scale = 0.1f * this.particleScale;
        float posX = (float)(this.xo + (this.x - this.xo) * (double)partialTick - lerpPosX);
        float posY = (float)(this.yo + (this.y - this.yo) * (double)partialTick - lerpPosY);
        float posZ = (float)(this.zo + (this.z - this.zo) * (double)partialTick - lerpPosZ);
        float brightness = this.getBrightness(partialTick);
        t.setColorOpaque_F(this.particleRed * brightness, this.particleGreen * brightness, this.particleBlue * brightness);
        t.addVertexWithUV(posX - rotationX * scale - rotationYZ * scale, posY - rotationXZ * scale, posZ - rotationZ * scale - rotationXY * scale, texMaxU, texMaxV);
        t.addVertexWithUV(posX - rotationX * scale + rotationYZ * scale, posY + rotationXZ * scale, posZ - rotationZ * scale + rotationXY * scale, texMaxU, texMinV);
        t.addVertexWithUV(posX + rotationX * scale + rotationYZ * scale, posY + rotationXZ * scale, posZ + rotationZ * scale + rotationXY * scale, texMinU, texMinV);
        t.addVertexWithUV(posX + rotationX * scale - rotationYZ * scale, posY - rotationXZ * scale, posZ + rotationZ * scale - rotationXY * scale, texMinU, texMaxV);
    }

    public int getFXLayer() {
        return 0;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
    }
}

