/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiClickableLabel;
import net.minecraft.client.gui.GuiContainer;
import net.minecraft.client.gui.GuiSurface;
import net.minecraft.client.gui.GuiTexturedButton;
import net.minecraft.client.gui.drawing.DrawableEditor;
import net.minecraft.client.gui.drawing.IDrawableSurface;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.Packet141UpdateFlag;
import net.minecraft.core.player.inventory.ContainerFlag;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class GuiEditFlag
extends GuiContainer
implements IDrawableSurface<Byte> {
    private final TileEntityFlag tileEntity;
    private final int CANVAS_SCALE = 4;
    private final int CANVAS_WIDTH = 24;
    private final int CANVAS_HEIGHT = 16;
    private int xLast = 0;
    private int yLast = 0;
    private int mouseButton;
    private boolean isDrawing = false;
    private int canvasX = 0;
    private int canvasY = 0;
    private int selectedColor = 0;
    private GuiClickableLabel[] colorLabels;
    private final DrawableEditor<Byte> flagSurfaceEditor;
    private final DrawableEditor<Byte> drawOverlaySurfaceEditor;
    private GuiTexturedButton[] toolBtns;
    private int activeTool = 0;
    GuiSurface flagSurface;
    GuiSurface drawOverlaySurface;

    public GuiEditFlag(EntityPlayer player, TileEntityFlag flagTileEntity) {
        super(new ContainerFlag(player.inventory, flagTileEntity));
        this.tileEntity = flagTileEntity;
        this.xSize = 176;
        this.ySize = 195;
        flagTileEntity.owner = player.username;
        this.flagSurface = new GuiSurface(24, 16, 4, flagTileEntity.flagColors);
        this.flagSurfaceEditor = new DrawableEditor<Byte>(this.flagSurface);
        this.drawOverlaySurface = new GuiSurface(24, 16, 4);
        this.drawOverlaySurfaceEditor = new DrawableEditor<Byte>(this.drawOverlaySurface);
    }

    @Override
    public void init() {
        int i;
        super.init();
        this.controlList.clear();
        this.canvasX = (this.width - this.xSize) / 2 + 27;
        this.canvasY = (this.height - this.ySize) / 2 + 8;
        this.toolBtns = new GuiTexturedButton[7];
        for (i = 0; i < 7; ++i) {
            this.toolBtns[i] = new GuiTexturedButton(i, "/gui/flag_editor.png", (this.width - this.xSize) / 2 + 12 + 22 * i, (this.height - this.ySize) / 2 + 76, 20 * i, 195, 20, 20);
            if (i == this.activeTool) {
                this.toolBtns[i].enabled = false;
            }
            this.controlList.add(this.toolBtns[i]);
        }
        this.colorLabels = new GuiClickableLabel[3];
        for (i = 0; i < 3; ++i) {
            this.colorLabels[i] = new GuiClickableLabel(100 + i, (this.width - this.xSize) / 2 + 150, (this.height - this.ySize) / 2 + 12 + i * 22, String.valueOf(i + 1), -1, 0);
            if (i != this.selectedColor) {
                this.colorLabels[i].textColor = -12632257;
                this.colorLabels[i].shadow = false;
            }
            this.controlList.add(this.colorLabels[i]);
        }
    }

    private void renderCanvas() {
        this.canvasX = (this.width - this.xSize) / 2 + 27;
        this.canvasY = (this.height - this.ySize) / 2 + 8;
        int[] colors = new int[5];
        for (int i = 1; i < 4; ++i) {
            ItemStack stack = this.tileEntity.getStackInSlot(35 + i);
            if (stack == null || stack.getItem() != Item.dye) continue;
            colors[i] = Colors.allFlagColors[TextFormatting.get((int)(15 - stack.getMetadata())).id].getARGB();
        }
        colors[4] = -1;
        this.flagSurface.colors = colors;
        this.drawOverlaySurface.colors = colors;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)769, (int)768);
        this.flagSurface.render(this.canvasX, this.canvasY);
        GL11.glDisable((int)3042);
        this.drawOverlaySurface.render(this.canvasX, this.canvasY);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (this.tileEntity.getStackInSlot(36 + this.selectedColor) == null) {
            return;
        }
        if (this.activeTool >= 0 && this.activeTool < 3) {
            if (!this.isDrawing) {
                int xInCanvas = (mouseX - this.canvasX) / 4;
                int yInCanvas = (mouseY - this.canvasY) / 4;
                if (xInCanvas >= 0 && xInCanvas < 24 && yInCanvas >= 0 && yInCanvas < 16) {
                    this.isDrawing = true;
                    this.xLast = xInCanvas;
                    this.yLast = yInCanvas;
                    this.mouseButton = mouseButton;
                    byte color = 0;
                    if (this.mouseButton == 0) {
                        color = (byte)(this.selectedColor + 1);
                    }
                    this.flagSurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, this.activeTool + 1);
                }
            }
        } else if (this.activeTool == 3) {
            if (!this.isDrawing) {
                int xInCanvas = (mouseX - this.canvasX) / 4;
                int yInCanvas = (mouseY - this.canvasY) / 4;
                if (xInCanvas >= 0 && xInCanvas < 24 && yInCanvas >= 0 && yInCanvas < 16) {
                    this.isDrawing = true;
                    this.mouseButton = mouseButton;
                    byte color = 0;
                    if (this.mouseButton == 0) {
                        color = (byte)(this.selectedColor + 1);
                    }
                    this.flagSurfaceEditor.floodFill(xInCanvas, yInCanvas, color);
                }
            }
        } else if (!(this.activeTool != 4 && this.activeTool != 5 && this.activeTool != 6 || this.isDrawing)) {
            int xInCanvas = (mouseX - this.canvasX) / 4;
            int yInCanvas = (mouseY - this.canvasY) / 4;
            if (xInCanvas >= 0 && xInCanvas < 24 && yInCanvas >= 0 && yInCanvas < 16) {
                this.isDrawing = true;
                this.mouseButton = mouseButton;
                this.xLast = xInCanvas;
                this.yLast = yInCanvas;
            }
        }
    }

    @Override
    protected void buttonPressed(GuiButton button) {
        super.buttonPressed(button);
        if (button.id >= 0 && button.id < 7) {
            this.toolBtns[this.activeTool].enabled = true;
            this.activeTool = button.id;
            button.enabled = false;
        }
        if (button.id >= 100 && button.id < 103) {
            this.colorLabels[this.selectedColor].textColor = -12566464;
            this.colorLabels[this.selectedColor].shadow = false;
            this.selectedColor = button.id - 100;
            this.colorLabels[this.selectedColor].textColor = -1;
            this.colorLabels[this.selectedColor].shadow = true;
        }
    }

    @Override
    public void mouseMovedOrButtonReleased(int mouseX, int mouseY, int mouseButton) {
        super.mouseMovedOrButtonReleased(mouseX, mouseY, mouseButton);
        if (this.activeTool >= 0 && this.activeTool < 3) {
            if (this.isDrawing && mouseButton != -1) {
                this.isDrawing = false;
                this.mouseButton = -1;
            } else if (this.isDrawing) {
                int xInCanvas = (mouseX - this.canvasX) / 4;
                int yInCanvas = (mouseY - this.canvasY) / 4;
                byte color = 0;
                if (this.mouseButton == 0) {
                    color = (byte)(this.selectedColor + 1);
                }
                if (MathHelper.abs(this.xLast - xInCanvas) <= 1.0f && MathHelper.abs(this.yLast - yInCanvas) <= 1.0f) {
                    this.flagSurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, this.activeTool + 1);
                } else {
                    this.flagSurfaceEditor.drawLine(this.xLast, this.yLast, xInCanvas, yInCanvas, color, this.activeTool + 1);
                }
                this.xLast = xInCanvas;
                this.yLast = yInCanvas;
            }
        } else if (this.activeTool == 3) {
            if (this.isDrawing && mouseButton != -1) {
                this.isDrawing = false;
                this.mouseButton = -1;
            }
        } else if (this.activeTool == 4) {
            if (this.isDrawing && mouseButton != -1) {
                this.isDrawing = false;
                int xInCanvas = (mouseX - this.canvasX) / 4;
                int yInCanvas = (mouseY - this.canvasY) / 4;
                byte color = 0;
                if (this.mouseButton == 0) {
                    color = (byte)(this.selectedColor + 1);
                }
                this.flagSurfaceEditor.drawRectangle(this.xLast, this.yLast, xInCanvas, yInCanvas, color);
                this.mouseButton = -1;
            }
        } else if (this.activeTool == 5) {
            if (this.isDrawing && mouseButton != -1) {
                this.isDrawing = false;
                int xInCanvas = (mouseX - this.canvasX) / 4;
                int yInCanvas = (mouseY - this.canvasY) / 4;
                byte color = 0;
                if (this.mouseButton == 0) {
                    color = (byte)(this.selectedColor + 1);
                }
                this.flagSurfaceEditor.drawEllipse(this.xLast, this.yLast, xInCanvas, yInCanvas, color);
                this.mouseButton = -1;
            }
        } else if (this.activeTool == 6 && this.isDrawing && mouseButton != -1) {
            this.isDrawing = false;
            int xInCanvas = (mouseX - this.canvasX) / 4;
            int yInCanvas = (mouseY - this.canvasY) / 4;
            byte color = 0;
            if (this.mouseButton == 0) {
                color = (byte)(this.selectedColor + 1);
            }
            this.flagSurfaceEditor.drawLine(this.xLast, this.yLast, xInCanvas, yInCanvas, color, 1);
            this.mouseButton = -1;
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f) {
        int i = this.mc.renderEngine.getTexture("/gui/flag_editor.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(i);
        int j = (this.width - this.xSize) / 2;
        int k = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(j, k, 0, 0, this.xSize, this.ySize);
        this.drawTexturedModalRect(j + 127, k + 8 + this.selectedColor * 22, 176, 0, 20, 20);
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        super.drawScreen(mouseX, mouseY, partialTick);
        this.drawOverlaySurface.clear();
        int xInCanvas = (mouseX - this.canvasX) / 4;
        int yInCanvas = (mouseY - this.canvasY) / 4;
        byte color = (byte)(this.selectedColor + 1);
        if (this.mouseButton == 1) {
            color = 4;
        }
        if (this.activeTool >= 0 && this.activeTool < 3) {
            this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, this.activeTool + 1);
        } else if (this.activeTool == 3) {
            this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, 1);
        } else if (this.activeTool == 4) {
            if (this.isDrawing) {
                this.drawOverlaySurfaceEditor.drawRectangle(this.xLast, this.yLast, xInCanvas, yInCanvas, color);
            } else {
                this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, 1);
            }
        } else if (this.activeTool == 5) {
            if (this.isDrawing) {
                this.drawOverlaySurfaceEditor.drawEllipse(this.xLast, this.yLast, xInCanvas, yInCanvas, color);
            } else {
                this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, 1);
            }
        } else if (this.activeTool == 6) {
            if (this.isDrawing) {
                this.drawOverlaySurfaceEditor.drawLine(this.xLast, this.yLast, xInCanvas, yInCanvas, color, 1);
            } else {
                this.drawOverlaySurfaceEditor.drawLine(xInCanvas, yInCanvas, xInCanvas, yInCanvas, color, 1);
            }
        }
        this.renderCanvas();
    }

    @Override
    protected void drawGuiContainerForegroundLayer() {
        this.fontRenderer.drawString(I18n.getInstance().translateKey("gui.edit_flag.label.inventory"), 8, this.ySize - 96 + 2, -12566464);
    }

    @Override
    public void keyTyped(char c, int keyCode, int mouseX, int mouseY) {
        super.keyTyped(c, keyCode, mouseX, mouseY);
        if (keyCode == 1 || this.mc.gameSettings.keyInventory.isKeyboardKey(keyCode) || keyCode == 14) {
            this.mc.thePlayer.closeScreen();
        }
        if (keyCode == 2 || keyCode == 3 || keyCode == 4) {
            this.colorLabels[this.selectedColor].textColor = -12566464;
            this.colorLabels[this.selectedColor].shadow = false;
            this.selectedColor = keyCode - 2;
            this.colorLabels[this.selectedColor].textColor = -1;
            this.colorLabels[this.selectedColor].shadow = true;
        }
    }

    @Override
    public int getWidth() {
        return 24;
    }

    @Override
    public int getHeight() {
        return 16;
    }

    @Override
    public Byte getPixelValue(int x, int y) {
        if (x < 0 || x >= 24) {
            return (byte)0;
        }
        if (y < 0 || y >= 16) {
            return (byte)0;
        }
        return this.tileEntity.flagColors[x + 24 * y];
    }

    @Override
    public boolean setPixelValue(int x, int y, Byte value) {
        if (x < 0 || x >= 24) {
            return false;
        }
        if (y < 0 || y >= 16) {
            return false;
        }
        this.tileEntity.flagColors[x + 24 * y] = value;
        return true;
    }

    @Override
    public void onClosed() {
        if (this.mc.theWorld.isClientSide) {
            this.mc.getSendQueue().addToSendQueue(new Packet141UpdateFlag(this.tileEntity.x, this.tileEntity.y, this.tileEntity.z, this.tileEntity.flagColors, this.tileEntity.owner));
        }
    }
}

