/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiClickableLabel;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiIngameDoom;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSelectServer;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.client.gui.GuiTexturedButton;
import net.minecraft.client.gui.options.GuiOptions;
import net.minecraft.client.gui.options.data.OptionsPages;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.tessalator.TessellatorStandard;
import net.minecraft.core.block.Block;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class GuiMainMenu
extends GuiScreen {
    private static final Block[] BLOCKS_TO_DRAW = new Block[]{Block.stone, Block.dirt, Block.planksOak, Block.cobbleStone, Block.cobbleStoneMossy, Block.basalt, Block.limestone, Block.granite, Block.brickClay, Block.ice, Block.wool, Block.blockSnow, Block.obsidian, Block.netherrack};
    private static String[] logoBlockLayers = null;
    private static final int[] KEY_CHAIN = new int[]{23, 32, 31, 25, 23, 31, 25, 24, 25, 32, 28};
    private static final Random rand = new Random();
    private String splashText = "missingno";
    private GuiButton multiplayerButton;
    private LogoBlock[][] logoBlocks;
    private int logoClickCounter = 0;
    private int indexToDraw = 0;
    private int codeProgress = 0;
    private boolean showBuildTime = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GuiMainMenu() {
        GuiIngameMenu.photoModeDisabled = false;
        InputStream stream = null;
        try {
            String line;
            stream = GuiMainMenu.class.getResourceAsStream("/title/splashes.txt");
            ArrayList<String> allSplashes = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                allSplashes.add(line);
            }
            this.splashText = (String)allSplashes.get(rand.nextInt(allSplashes.size()));
        }
        catch (Exception exception) {
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void keyTyped(char c, int i, int mouseX, int mouseY) {
        if (i == KEY_CHAIN[this.codeProgress]) {
            ++this.codeProgress;
            if (this.codeProgress == KEY_CHAIN.length) {
                this.mc.ingameGUI = this.mc.ingameGUI instanceof GuiIngameDoom ? new GuiIngame(this.mc) : new GuiIngameDoom(this.mc);
                this.mc.sndManager.playSound("mob.pig", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
                this.codeProgress = 0;
            }
        } else {
            this.codeProgress = 0;
        }
    }

    @Override
    public void init() {
        I18n i18n = I18n.getInstance();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if (calendar.get(2) + 1 == 1 && calendar.get(5) == 19) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.jonkadelic_birthday");
        } else if (calendar.get(2) + 1 == 4 && calendar.get(5) == 29) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.maggandgeez_birthday");
        } else if (calendar.get(2) + 1 == 5 && calendar.get(5) == 17) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.minecraft_birthday");
        } else if (calendar.get(2) + 1 == 7 && calendar.get(5) == 20) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.bta_birthday");
        } else if (calendar.get(2) + 1 == 12 && calendar.get(5) == 24) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.xmas");
        } else if (calendar.get(2) + 1 == 1 && calendar.get(5) == 1) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.new_year");
        } else if (calendar.get(2) + 1 == 10 && calendar.get(5) == 31) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.halloween");
        }
        int i = this.height / 4 + 48;
        this.controlList.add(new GuiButton(1, this.width / 2 - 100, i, i18n.translateKey("gui.main_menu.button.singleplayer")));
        this.multiplayerButton = new GuiButton(2, this.width / 2 - 100, i + 24, i18n.translateKey("gui.main_menu.button.multiplayer"));
        this.controlList.add(this.multiplayerButton);
        this.controlList.add(new GuiButton(3, this.width / 2 - 100, i + 48, i18n.translateKey("gui.main_menu.button.texture_packs")));
        if (this.mc.hideQuitButton) {
            this.controlList.add(new GuiButton(0, this.width / 2 - 100, i + 72, i18n.translateKey("gui.main_menu.button.options")));
        } else {
            this.controlList.add(new GuiButton(0, this.width / 2 - 100, i + 72 + 12, 98, 20, i18n.translateKey("gui.main_menu.button.options")));
            this.controlList.add(new GuiButton(4, this.width / 2 + 2, i + 72 + 12, 98, 20, i18n.translateKey("gui.main_menu.button.quit_game")));
        }
        int d = 1;
        this.controlList.add(new GuiClickableLabel(5, d, this.height - 36 - d, i18n.translateKey("gui.main_menu.button.discord"), 5793266));
        this.controlList.add(new GuiClickableLabel(6, d, this.height - 24 - d, i18n.translateKey("gui.main_menu.button.minecraft_forum"), 6529313));
        this.controlList.add(new GuiClickableLabel(7, d, this.height - 12 - d, i18n.translateKey("gui.main_menu.button.youtube"), 0xFF0000));
        this.controlList.add(new GuiTexturedButton(8, "/gui/gui.png", this.width / 2 + 104, i + 72 + 12, 0, 86, 20, 20));
        if (this.mc.session == null) {
            this.multiplayerButton.enabled = false;
        }
        this.multiplayerButton.enabled = false;
        this.multiplayerButton.displayString = i18n.translateKey("gui.main_menu.button.multiplayer.disabled");
    }

    @Override
    protected void buttonPressed(GuiButton button) {
        Desktop desktop;
        if (button.id == 0) {
            this.mc.displayGuiScreen(new GuiOptions(this));
        }
        if (button.id == 1) {
            this.mc.displayGuiScreen(new GuiSelectWorld(this));
        }
        if (button.id == 2) {
            this.mc.displayGuiScreen(new GuiSelectServer(this));
        }
        if (button.id == 3) {
            this.mc.displayGuiScreen(new GuiOptions(this, OptionsPages.TEXTURE_PACKS));
        }
        if (button.id == 4) {
            this.mc.shutdown();
        }
        if (button.id == 8) {
            this.mc.displayGuiScreen(new GuiOptions(this, OptionsPages.LANGUAGE));
        }
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            if (button.id == 5) {
                try {
                    desktop.browse(URI.create("https://discord.com/invite/jvwD8BKq5e"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (button.id == 6) {
                try {
                    desktop.browse(URI.create("https://www.minecraftforum.net/forums/mapping-and-modding-java-edition/minecraft-mods/3106066-better-than-adventure-for-beta-1-7-3-timely"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (button.id == 7) {
                try {
                    desktop.browse(URI.create("https://www.youtube.com/channel/UC_GT4t8Io87-UTzaGNnsuMg"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void drawBackground() {
        if (this.mc.mainMenuBackground.isEnabled() && !((Boolean)this.mc.gameSettings.alphaMenu.value).booleanValue()) {
            this.mc.mainMenuBackground.draw();
        } else {
            super.drawBackground();
        }
    }

    @Override
    public void tick() {
        if (this.logoBlocks != null) {
            for (int var1 = 0; var1 < this.logoBlocks.length; ++var1) {
                for (int var2 = 0; var2 < this.logoBlocks[var1].length; ++var2) {
                    this.logoBlocks[var1][var2].updateLogoEffects();
                }
            }
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        int logoWidth = 274;
        int logoX = this.width / 2 - logoWidth / 2;
        int logoHeight = 30;
        int p = 8;
        if (mouseX >= logoX + p && mouseX <= logoX + 270 - p && mouseY >= logoHeight + p && mouseY <= logoHeight + 48 - p) {
            if (this.logoClickCounter >= 0) {
                this.indexToDraw = rand.nextInt(BLOCKS_TO_DRAW.length);
                this.mc.gameSettings.alphaMenu.toggle();
                if (((Boolean)this.mc.gameSettings.alphaMenu.value).booleanValue()) {
                    this.logoBlocks = null;
                }
                this.logoClickCounter = 0;
            } else {
                ++this.logoClickCounter;
            }
        }
        if (mouseY >= 2 && mouseY <= 12 && mouseX >= 2 && mouseX <= 40) {
            this.showBuildTime = !this.showBuildTime;
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        int versionTextColor;
        I18n i18n = I18n.getInstance();
        this.drawDefaultBackground();
        TessellatorStandard tessellator = TessellatorStandard.instance;
        int c = 274;
        int k = this.width / 2 - c / 2;
        int byte0 = 30;
        if (!((Boolean)this.mc.gameSettings.alphaMenu.value).booleanValue()) {
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/title/mclogo.png"));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawTexturedModalRect(k + 0, byte0 + 0, 0, 0, 155, 64);
            this.drawTexturedModalRect(k + 155, byte0 + 0, 0, 64, 155, 64);
        } else {
            this.drawLogo(partialTick);
        }
        tessellator.setColorOpaque_I(0xFFFFFF);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.width / 2 + 140), (float)80.0f, (float)0.0f);
        GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f1 = 1.8f - MathHelper.abs(MathHelper.sin((float)(System.currentTimeMillis() % 1000L) / 1000.0f * 3.141593f * 2.0f) * 0.1f);
        f1 = f1 * 100.0f / (float)(this.fontRenderer.getStringWidth(this.splashText) + 32);
        GL11.glScalef((float)f1, (float)f1, (float)f1);
        this.drawStringCentered(this.fontRenderer, this.splashText, 0, -8, 0xFFFF00);
        GL11.glPopMatrix();
        int n = versionTextColor = (Boolean)this.mc.gameSettings.alphaMenu.value != false || !this.mc.mainMenuBackground.isEnabled() ? 0x505050 : 0xFFFFFF;
        if (this.showBuildTime) {
            this.drawString(this.fontRenderer, "2024-04-01 09:52:00", 2, 2, versionTextColor);
        } else {
            this.drawString(this.fontRenderer, "Better than Adventure! The Wombat Update", 2, 2, versionTextColor);
        }
        String disclaimer1 = i18n.translateKey("gui.main_menu.label.disclaimer.1");
        this.drawString(this.fontRenderer, disclaimer1, this.width - this.fontRenderer.getStringWidth(disclaimer1) - 2, this.height - 20, 0xFFFFFF);
        String disclaimer2 = i18n.translateKey("gui.main_menu.label.disclaimer.2");
        this.drawString(this.fontRenderer, disclaimer2, this.width - this.fontRenderer.getStringWidth(disclaimer2) - 2, this.height - 10, 0xFFFFFF);
        super.drawScreen(mouseX, mouseY, partialTick);
        if (this.mc.downloadResourcesThread.downloading) {
            double b = Math.sin((double)System.currentTimeMillis() / 1000.0 * 4.0);
            b = b * 0.2 + 0.8;
            int ib = (int)Math.round(b * 255.0);
            int color = -16777216 + (ib << 16) + (ib << 8) + ib;
            this.mc.fontRenderer.drawCenteredString(i18n.translateKeyAndFormat("gui.main_menu.label.downloading_resources", this.mc.downloadResourcesThread.downloadProgress, this.mc.downloadResourcesThread.toDownload), this.width / 2, 16, color);
        }
    }

    private void drawLogo(float var1) {
        int var3;
        if (this.logoBlocks == null) {
            this.logoBlocks = new LogoBlock[logoBlockLayers[0].length()][logoBlockLayers.length];
            for (int var2 = 0; var2 < this.logoBlocks.length; ++var2) {
                for (var3 = 0; var3 < this.logoBlocks[var2].length; ++var3) {
                    this.logoBlocks[var2][var3] = new LogoBlock(var2, var3);
                }
            }
        }
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        var3 = 120 * this.mc.resolution.scale;
        GLU.gluPerspective((float)70.0f, (float)((float)this.mc.resolution.width / (float)var3), (float)0.05f, (float)100.0f);
        GL11.glViewport((int)0, (int)(this.mc.resolution.height - var3), (int)this.mc.resolution.width, (int)var3);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glDisable((int)2884);
        GL11.glCullFace((int)1029);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        for (int var4 = 0; var4 < 3; ++var4) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.4f, (float)0.6f, (float)-12.0f);
            if (var4 == 0) {
                GL11.glClear((int)256);
                GL11.glTranslatef((float)0.0f, (float)-0.4f, (float)0.0f);
                GL11.glScalef((float)0.98f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            if (var4 == 1) {
                GL11.glDisable((int)3042);
                GL11.glClear((int)256);
            }
            if (var4 == 2) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)768, (int)1);
            }
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            GL11.glRotatef((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)0.89f, (float)1.0f, (float)0.4f);
            GL11.glTranslatef((float)((float)(-logoBlockLayers[0].length()) * 0.5f), (float)((float)(-logoBlockLayers.length) * 0.5f), (float)0.0f);
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/terrain.png"));
            if (var4 == 0) {
                GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/title/black.png"));
            }
            RenderBlocks var5 = new RenderBlocks();
            for (int var6 = 0; var6 < logoBlockLayers.length; ++var6) {
                for (int var7 = 0; var7 < logoBlockLayers[var6].length(); ++var7) {
                    char var8 = logoBlockLayers[var6].charAt(var7);
                    if (var8 == ' ') continue;
                    GL11.glPushMatrix();
                    LogoBlock var9 = this.logoBlocks[var7][var6];
                    float var10 = (float)(var9.prevHeight + (var9.height - var9.prevHeight) * (double)var1);
                    float var11 = 1.0f;
                    float var12 = 1.0f;
                    if (var4 == 0) {
                        var11 = var10 * 0.04f + 1.0f;
                        var12 = 1.0f / var11;
                        var10 = 0.0f;
                    }
                    GL11.glTranslatef((float)var7, (float)var6, (float)var10);
                    GL11.glScalef((float)var11, (float)var11, (float)var11);
                    var5.renderBlockAsItem(TessellatorStandard.instance, (BlockModel)BlockModelDispatcher.getInstance().getDispatch(BLOCKS_TO_DRAW[this.indexToDraw]), BLOCKS_TO_DRAW[this.indexToDraw], var12);
                    GL11.glPopMatrix();
                }
            }
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)3042);
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glViewport((int)0, (int)0, (int)this.mc.resolution.width, (int)this.mc.resolution.height);
        GL11.glEnable((int)2884);
    }

    static Random getRandom() {
        return rand;
    }

    public static void loadLogo() {
        try {
            InputStream inputStream = GuiMainMenu.class.getResourceAsStream("/title/retrologo.png");
            BufferedImage image = ImageIO.read(inputStream);
            inputStream.close();
            logoBlockLayers = new String[image.getHeight()];
            for (int i = 0; i < image.getHeight(); ++i) {
                StringBuilder builder = new StringBuilder();
                for (int j = 0; j < image.getWidth(); ++j) {
                    int rgb = image.getRGB(j, i);
                    if ((rgb >> 16 & 0xFF) > 128) {
                        builder.append('*');
                        continue;
                    }
                    builder.append(' ');
                }
                GuiMainMenu.logoBlockLayers[i] = builder.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        GuiMainMenu.loadLogo();
    }

    class LogoBlock {
        public double height;
        public double prevHeight;
        public double dropSpeed;

        public LogoBlock(int var2, int var3) {
            this.height = this.prevHeight = (double)(10 + var3) + rand.nextDouble() * 32.0 + (double)var2;
        }

        public void updateLogoEffects() {
            this.prevHeight = this.height;
            if (this.height > 0.0) {
                this.dropSpeed -= 0.6;
            }
            this.height += this.dropSpeed;
            this.dropSpeed *= 0.9;
            if (this.height < 0.0) {
                this.height = 0.0;
                this.dropSpeed = 0.0;
            }
        }
    }
}

