/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.render.Renderer;
import net.minecraft.client.render.shader.PhotoModeRenderer;
import net.minecraft.client.render.shader.Shaders;
import net.minecraft.core.Global;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.ScreenShot;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.Seasons;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiPhotoMode
extends GuiScreen {
    private GuiButton buttonRotateLeft;
    private GuiButton buttonRotateRight;
    private GuiButton buttonCenterScreen;
    private GuiSlider sliderTimeOfDay;
    private GuiButton buttonSeason;
    private GuiButton buttonTakeScreenshot;
    private GuiButton buttonExit;
    private GuiSlider sliderFog;
    private GuiSlider sliderTilt;
    private GuiButton buttonShaders;
    private GuiSlider sliderIntensity;
    private GuiButton buttonShowPlayer;
    private long originalTOD;
    private long desiredTOD = -1L;
    private long desiredDay = -1L;
    private int desiredSeason = -1;
    public boolean showPlayer = true;
    private float iRotation = 0.0f;
    private float lastIRotation = 0.0f;
    private float iRotationGoal = 0.0f;
    private float iZoom = 1.0f;
    private float lastIZoom = 1.0f;
    private float iZoomGoal = 1.0f;
    private float iTilt = 30.0f;
    private float lastITilt = 30.0f;
    private float iTiltGoal = 30.0f;
    private float iFog = 1.0f;
    private float lastIFog = 1.0f;
    private float iFogGoal = 1.0f;
    private float iPanX = 0.0f;
    private float lastIPanX = 0.0f;
    private float iPanXGoal = 0.0f;
    private float iPanY = 0.0f;
    private float lastIPanY = 0.0f;
    private float iPanYGoal = 0.0f;
    private boolean isMouseDown = false;
    private int mouseButton;
    private int mouseDownX;
    private int mouseDownY;
    private float lastEndPanX;
    private float lastEndPanY;
    private float lastEndRotation;
    public float intensityValue = 1.0f;
    boolean shouldScreenshot = false;
    private PhotoModeRenderer photoModeRenderer;
    public Renderer previousRenderer;
    private boolean showHelpText = true;
    private long lastUpdateTime = 0L;

    public GuiPhotoMode() {
        Minecraft mc = Minecraft.getMinecraft(this);
        if (Shaders.enableShaders) {
            this.photoModeRenderer = new PhotoModeRenderer(mc, this);
        }
        this.previousRenderer = mc.render;
        mc.renderGlobal.allChanged();
    }

    public float getRotation(float partialTick) {
        return this.lastIRotation + (this.iRotation - this.lastIRotation) * partialTick;
    }

    public float getZoom(float partialTick) {
        return this.lastIZoom + (this.iZoom - this.lastIZoom) * partialTick;
    }

    public float getTilt(float partialTick) {
        return this.lastITilt + (this.iTilt - this.lastITilt) * partialTick;
    }

    public float getFog(float partialTick) {
        return this.lastIFog + (this.iFog - this.lastIFog) * partialTick;
    }

    public float getPanX(float partialTick) {
        return this.lastIPanX + (this.iPanX - this.lastIPanX) * partialTick;
    }

    public float getPanY(float partialTick) {
        return this.lastIPanY + (this.iPanY - this.lastIPanY) * partialTick;
    }

    @Override
    public void init() {
        super.init();
        I18n i18n = I18n.getInstance();
        this.buttonExit = new GuiButton(5, 0, 0, 20, 20, "X");
        this.buttonRotateLeft = new GuiButton(0, this.width / 2 - 49 - 2 - 20, this.height - 20, 20, 20, "<");
        this.buttonRotateRight = new GuiButton(1, this.width / 2 + 49 + 2, this.height - 20, 20, 20, ">");
        this.buttonTakeScreenshot = new GuiButton(4, this.width / 2 - 49, this.height - 20, 98, 20, i18n.translateKey("gui.photo_mode.button.take_screenshot"));
        this.buttonCenterScreen = new GuiButton(10, this.width - 120, 0, 120, 20, i18n.translateKey("gui.photo_mode.button.center_camera"));
        this.buttonShowPlayer = new GuiButton(11, this.width - 120, 0, 120, 20, "");
        this.sliderTimeOfDay = new GuiSlider(2, this.width - 120, 0, 120, 20, "", 0.0f);
        this.buttonSeason = new GuiButton(3, this.width - 120, 0, 120, 20, "");
        this.sliderFog = new GuiSlider(6, this.width - 120, 0, 120, 20, "", 1.0f);
        this.sliderTilt = new GuiSlider(7, this.width - 120, 0, 120, 20, "", 0.33333334f);
        if (Shaders.enableShaders) {
            this.buttonShaders = new GuiButton(8, this.width - 120, 0, 120, 20, "");
            this.sliderIntensity = new GuiSlider(9, this.width - 120, 0, 120, 20, "", this.intensityValue);
            if (this.photoModeRenderer.getActiveShader() == null) {
                this.sliderIntensity.enabled = false;
            }
        }
        this.controlList.add(this.buttonCenterScreen);
        this.controlList.add(this.buttonShowPlayer);
        this.controlList.add(this.sliderTilt);
        if (Shaders.enableShaders) {
            this.mc.setRenderer(this.photoModeRenderer);
        }
        if (!this.mc.theWorld.isClientSide) {
            this.controlList.add(this.sliderTimeOfDay);
            this.controlList.add(this.sliderFog);
            this.controlList.add(this.buttonSeason);
        }
        if (Shaders.enableShaders) {
            this.controlList.add(this.buttonShaders);
            this.controlList.add(this.sliderIntensity);
        }
        int i = 0;
        for (GuiButton button : this.controlList) {
            button.yPosition = i++ * 21;
        }
        this.controlList.add(this.buttonRotateLeft);
        this.controlList.add(this.buttonRotateRight);
        this.controlList.add(this.buttonTakeScreenshot);
        this.controlList.add(this.buttonExit);
        this.originalTOD = this.mc.theWorld.getWorldTime();
        if (this.desiredTOD == -1L) {
            this.desiredTOD = this.originalTOD % 24000L;
        } else {
            this.sliderTimeOfDay.sliderValue = (float)this.desiredTOD / 24000.0f;
        }
        if (this.desiredDay == -1L) {
            this.desiredDay = this.originalTOD / 24000L;
        }
        this.updateButtonsText();
    }

    @Override
    public void onClosed() {
        this.mc.theWorld.setWorldTimeUpdateTicks(this.originalTOD);
        if (Shaders.enableShaders) {
            this.mc.setRenderer(this.previousRenderer);
        }
        this.mc.renderGlobal.allChanged();
    }

    @Override
    protected void buttonPressed(GuiButton button) {
        if (button == this.buttonRotateLeft) {
            this.iRotationGoal += 1.0f;
            this.iRotationGoal = (int)this.iRotationGoal;
        } else if (button == this.buttonRotateRight) {
            this.iRotationGoal -= 1.0f;
            this.iRotationGoal = (int)this.iRotationGoal;
        } else if (button == this.buttonSeason) {
            ++this.desiredSeason;
            if (this.desiredSeason > 3) {
                this.desiredSeason = -1;
            }
            this.desiredDay = this.desiredSeason == -1 ? this.originalTOD / 24000L : 168000L * (long)this.desiredSeason + 72000L;
            this.mc.theWorld.setWorldTimeUpdateTicks(this.desiredDay + this.desiredTOD);
            this.mc.theWorld.doSeasonUpdate();
        } else if (button == this.buttonTakeScreenshot) {
            this.shouldScreenshot = true;
        } else if (button == this.buttonExit) {
            this.mc.displayGuiScreen(null);
        } else if (button == this.buttonShaders) {
            boolean ctrl;
            boolean bl = ctrl = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
            if (ctrl) {
                this.photoModeRenderer.first();
            } else {
                this.photoModeRenderer.next();
            }
            this.sliderIntensity.enabled = this.photoModeRenderer.getActiveShader() != null;
        } else if (button == this.buttonCenterScreen) {
            this.iPanXGoal = 0.0f;
            this.iPanYGoal = 0.0f;
        } else if (button == this.buttonShowPlayer) {
            this.showPlayer = !this.showPlayer;
        }
        this.updateButtonsText();
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (!this.isMouseDown && this.selectedButton == null) {
            this.showHelpText = false;
            this.isMouseDown = true;
            this.mouseDownX = mouseX;
            this.mouseDownY = mouseY;
            this.lastEndPanX = this.iPanX;
            this.lastEndPanY = this.iPanY;
            this.lastEndRotation = this.iRotation;
            this.mouseButton = mouseButton;
        }
    }

    @Override
    public void mouseMovedOrButtonReleased(int mouseX, int mouseY, int mouseButton) {
        super.mouseMovedOrButtonReleased(mouseX, mouseY, mouseButton);
        if (this.isMouseDown && mouseButton != -1) {
            this.isMouseDown = false;
        } else if (this.isMouseDown) {
            if (this.mouseButton == 0) {
                float div = (float)Math.pow(2.0, this.iZoom) / 3.0f;
                this.iPanXGoal = this.lastEndPanX + (float)(mouseX - this.mouseDownX) / div;
                this.iPanYGoal = this.lastEndPanY + (float)(mouseY - this.mouseDownY) / div;
            } else {
                this.iRotationGoal = this.lastEndRotation + (float)(mouseX - this.mouseDownX) / 128.0f;
            }
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        GL11.glViewport((int)0, (int)0, (int)this.mc.resolution.width, (int)this.mc.resolution.height);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.mc.resolution.scaledWidth, (double)this.mc.resolution.scaledHeight, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        long currentTime = System.currentTimeMillis();
        if (currentTime > this.lastUpdateTime + 5L) {
            this.lastIZoom = this.iZoom;
            if (this.iZoom != this.iZoomGoal) {
                this.iZoom += (this.iZoomGoal - this.iZoom) * 0.08f;
                if (Math.abs(this.iZoom - this.iZoomGoal) < 5.0E-4f) {
                    this.iZoom = this.iZoomGoal;
                }
            }
            this.lastIRotation = this.iRotation;
            if (this.iRotation != this.iRotationGoal) {
                this.iRotation += (this.iRotationGoal - this.iRotation) * 0.08f;
                if (Math.abs(this.iRotation - this.iRotationGoal) < 5.0E-4f) {
                    this.iRotation = this.iRotationGoal;
                }
            }
            this.lastITilt = this.iTilt;
            if (this.iTilt != this.iTiltGoal) {
                this.iTilt += (this.iTiltGoal - this.iTilt) * 0.08f;
                if (Math.abs(this.iTilt - this.iTiltGoal) < 0.01f) {
                    this.iTilt = this.iTiltGoal;
                }
            }
            this.lastIFog = this.iFog;
            if (this.iFog != this.iFogGoal) {
                this.iFog += (this.iFogGoal - this.iFog) * 0.08f;
                if (Math.abs(this.iFog - this.iFogGoal) < 5.0E-5f) {
                    this.iFog = this.iFogGoal;
                }
            }
            this.lastIPanX = this.iPanX;
            if (this.iPanX != this.iPanXGoal) {
                this.iPanX += (this.iPanXGoal - this.iPanX) * 0.4f;
                if (Math.abs(this.iPanX - this.iPanXGoal) < 0.01f) {
                    this.iPanX = this.iPanXGoal;
                }
            }
            this.lastIPanY = this.iPanY;
            if (this.iPanY != this.iPanYGoal) {
                this.iPanY += (this.iPanYGoal - this.iPanY) * 0.4f;
                if (Math.abs(this.iPanY - this.iPanYGoal) < 0.01f) {
                    this.iPanY = this.iPanYGoal;
                }
            }
            this.lastUpdateTime = currentTime;
        }
        boolean bl = this.buttonCenterScreen.enabled = !(this.iPanX == 0.0f && this.iPanY == 0.0f || this.iPanXGoal == 0.0f && this.iPanYGoal == 0.0f);
        if (!this.shouldScreenshot) {
            super.drawScreen(mouseX, mouseY, partialTick);
        } else {
            ScreenShot.saveScreenshot(Global.accessor.getMinecraftDir(), this.mc.resolution.width, this.mc.resolution.height);
            this.shouldScreenshot = false;
        }
        this.scroll(Mouse.getDWheel());
        if (this.sliderTimeOfDay.dragging) {
            long sliderTOD = (long)(this.sliderTimeOfDay.sliderValue * 24000.0f);
            this.desiredTOD = this.sliderTimeOfDay.sliderValue == 0.0f ? this.originalTOD % 24000L : sliderTOD;
            this.mc.theWorld.setWorldTimeUpdateTicks(this.desiredDay + this.desiredTOD);
            this.mc.theWorld.doLightingUpdate();
            this.updateButtonsText();
        }
        if (this.sliderTilt.dragging) {
            this.iTiltGoal = (int)(this.sliderTilt.sliderValue * 90.0f);
            this.updateButtonsText();
        }
        if (this.sliderFog.dragging) {
            this.iFogGoal = (float)Math.pow(2.0, 8.0f * this.sliderFog.sliderValue - 8.0f);
            this.updateButtonsText();
        }
        if (Shaders.enableShaders && this.sliderIntensity.dragging) {
            this.intensityValue = this.sliderIntensity.sliderValue;
            this.updateButtonsText();
        }
        if (this.showHelpText) {
            this.drawStringCentered(this.fontRenderer, I18n.getInstance().translateKey("gui.photo_mode.label.mouse_hint"), this.width / 2, this.height - 36, 0xFFFFFF);
        }
    }

    private void updateButtonsText() {
        I18n i18n = I18n.getInstance();
        if (this.buttonSeason != null) {
            Season[] seasons = new Season[]{Seasons.OVERWORLD_SPRING, Seasons.OVERWORLD_SUMMER, Seasons.OVERWORLD_FALL, Seasons.OVERWORLD_WINTER};
            String seasonName = i18n.translateKey("gui.photo_mode.button.season.default");
            if (this.desiredSeason >= 0) {
                seasonName = seasons[this.desiredSeason].getTranslatedName().toUpperCase(Locale.ROOT);
            }
            this.buttonSeason.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.season", seasonName);
        }
        String timeOfDay = i18n.translateKey("gui.photo_mode.button.time_of_day.default");
        if (this.sliderTimeOfDay.sliderValue != 0.0f) {
            timeOfDay = String.valueOf((long)(this.sliderTimeOfDay.sliderValue * 24000.0f));
        }
        this.sliderTimeOfDay.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.time_of_day", timeOfDay);
        this.sliderFog.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.fog", (int)(this.sliderFog.sliderValue * 100.0f) + "%");
        String tilt = i18n.translateKey("gui.photo_mode.button.tilt.default");
        if ((int)(this.sliderTilt.sliderValue * 90.0f) != 30) {
            tilt = (int)(this.sliderTilt.sliderValue * 90.0f) + " degrees";
        }
        this.sliderTilt.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.tilt", tilt);
        if (Shaders.enableShaders) {
            String activeShader = this.photoModeRenderer.getActiveShader();
            if (activeShader == null) {
                activeShader = i18n.translateKey("gui.photo_mode.button.shader.none");
            }
            activeShader = activeShader.toUpperCase(Locale.ROOT);
            this.buttonShaders.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.shader", activeShader);
            this.sliderIntensity.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.intensity", (int)(this.sliderIntensity.sliderValue * 100.0f) + "%");
        }
        this.buttonShowPlayer.displayString = i18n.translateKeyAndFormat("gui.photo_mode.button.show_player", this.showPlayer ? i18n.translateKey("gui.photo_mode.button.show_player.on") : i18n.translateKey("gui.photo_mode.button.show_player.off"));
    }

    public void scroll(int i) {
        if (i < 0) {
            this.iZoomGoal -= 0.25f;
        } else if (i > 0) {
            this.iZoomGoal += 0.25f;
        }
    }
}

