/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.smelting;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.SearchableGuidebookSection;
import net.minecraft.client.gui.guidebook.smelting.SmeltingPage;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryFurnace;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.collection.Pair;

public class SmeltingSection
extends SearchableGuidebookSection {
    private final List<GuidebookPage> pages = new ArrayList<GuidebookPage>();
    private Pair<String, List<GuidebookPage>> filteredPages = null;

    public SmeltingSection(String translationKey, ItemStack tabIcon, int bgColor, int fgColor) {
        super(translationKey, tabIcon, bgColor, fgColor);
        this.reloadRecipes();
    }

    @Override
    public List<GuidebookPage> searchPages(SearchQuery query) {
        if (this.filteredPages == null || !Objects.equals(this.filteredPages.getLeft(), query.rawQuery)) {
            ArrayList<RecipeEntryFurnace> filteredRecipes = new ArrayList<RecipeEntryFurnace>();
            ArrayList<RecipeEntryFurnace> allRecipes = new ArrayList<RecipeEntryFurnace>(Registries.RECIPES.getAllFurnaceRecipes());
            allRecipes.removeIf(Objects::isNull);
            for (RecipeEntryFurnace recipe : allRecipes) {
                if (!recipe.matchesQueryIgnoreExceptions(query)) continue;
                filteredRecipes.add(recipe);
            }
            ArrayList<GuidebookPage> filteredPages = new ArrayList<GuidebookPage>();
            int filteredRecipeSize = filteredRecipes.size();
            int filteredPageCount = filteredRecipeSize / 6;
            if (filteredPageCount == 0) {
                filteredPageCount = 1;
            }
            for (int i = 0; i < filteredPageCount; ++i) {
                int j = i * 6;
                ArrayList<RecipeEntryFurnace> recipes = new ArrayList<RecipeEntryFurnace>(filteredRecipes.subList(j, Math.min(j + 6, filteredRecipeSize)));
                if (recipes.size() <= 0) continue;
                filteredPages.add(new SmeltingPage(this, recipes));
            }
            this.filteredPages = Pair.of(query.rawQuery, filteredPages);
            return filteredPages;
        }
        return this.filteredPages.getRight();
    }

    public void reloadRecipes() {
        this.pages.clear();
        ArrayList<RecipeEntryFurnace> allRecipes = new ArrayList<RecipeEntryFurnace>(Registries.RECIPES.getAllFurnaceRecipes());
        allRecipes.removeIf(Objects::isNull);
        int totalRecipes = allRecipes.size();
        int totalPages = totalRecipes / 6;
        if (totalPages == 0) {
            totalPages = 1;
        }
        for (int i = 0; i < totalPages; ++i) {
            int j = i * 6;
            ArrayList<RecipeEntryFurnace> recipes = new ArrayList<RecipeEntryFurnace>(allRecipes.subList(j, Math.min(j + 6, totalRecipes)));
            this.pages.add(new SmeltingPage(this, recipes));
        }
    }

    @Override
    public List<GuidebookPage> getPages() {
        return this.pages;
    }

    @Override
    public List<GuidebookSection.Index> getIndices() {
        return null;
    }
}

