/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.options.components.ButtonComponent;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.tessalator.TessellatorStandard;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import org.lwjgl.opengl.GL11;

public class TexturePackListComponent
implements OptionsComponent {
    private static final int BUTTON_HEIGHT = 32;
    private final List<TexturePackButton> buttons = new ArrayList<TexturePackButton>();
    private int updateTickCount = 0;

    @Override
    public void init(Minecraft mc) {
        this.createTexturePackButtons();
    }

    @Override
    public void tick() {
        ++this.updateTickCount;
        if (this.updateTickCount >= 40) {
            this.updateTickCount = 0;
            if (ButtonComponent.mc.texturePackList.updateAvailableTexturePacks()) {
                this.createTexturePackButtons();
            }
        }
    }

    public void createTexturePackButtons() {
        this.buttons.clear();
        List<TexturePack> texturePacks = ButtonComponent.mc.texturePackList.availableTexturePacks();
        for (int i = 0; i < texturePacks.size(); ++i) {
            TexturePack texturePack = texturePacks.get(i);
            this.buttons.add(new TexturePackButton(i, texturePack));
        }
    }

    @Override
    public int getHeight() {
        if (this.buttons.isEmpty()) {
            return 20;
        }
        return 3 + this.buttons.size() * 35;
    }

    @Override
    public void render(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        if (this.buttons.isEmpty()) {
            ButtonComponent.mc.fontRenderer.drawCenteredString(I18n.getInstance().translateKey("gui.options.page.texture_packs.label.no_packs"), x + width / 2, y + 4, 0x5F7F7F7F);
        }
        for (int i = 0; i < this.buttons.size(); ++i) {
            TexturePackButton button = this.buttons.get(i);
            button.render(x, 3 + y + i * 35, width, relativeMouseX, relativeMouseY);
        }
    }

    @Override
    public void onMouseClick(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            TexturePackButton button = this.buttons.get(i);
            if (!button.isClickable() || relativeMouseX < 0 || relativeMouseX > width || relativeMouseY < 3 + i * 35 || relativeMouseY > 3 + i * 35 + 32) continue;
            ButtonComponent.mc.texturePackList.setTexturePack(button.texturePack);
            break;
        }
    }

    @Override
    public void onMouseMove(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
    }

    @Override
    public void onMouseRelease(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
    }

    @Override
    public void onKeyPress(int keyCode, char character) {
    }

    @Override
    public boolean matchesSearchTerm(String term) {
        return false;
    }

    private static class TexturePackButton {
        public final int index;
        public final TexturePack texturePack;
        public final int height = 32;

        public TexturePackButton(int index, TexturePack texturePack) {
            this.index = index;
            this.texturePack = texturePack;
        }

        public boolean isClickable() {
            return true;
        }

        public void render(int x, int y, int width, int mouseX, int mouseY) {
            TessellatorStandard tessellator = TessellatorStandard.instance;
            FontRenderer fontRenderer = ButtonComponent.mc.fontRenderer;
            if (ButtonComponent.mc.texturePackList.selectedTexturePack == this.texturePack) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3553);
                tessellator.startDrawingQuads();
                tessellator.setColorOpaque_I(2139127936);
                tessellator.addVertexWithUV(x - 2, y + 32 + 2, 0.0, 0.0, 1.0);
                tessellator.addVertexWithUV(x + width + 2, y + 32 + 2, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(x + width + 2, y - 2, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(x - 2, y - 2, 0.0, 0.0, 0.0);
                tessellator.setColorOpaque_I(0);
                tessellator.addVertexWithUV(x - 1, y + 32 + 1, 0.0, 0.0, 1.0);
                tessellator.addVertexWithUV(x + width + 1, y + 32 + 1, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(x + width + 1, y - 1, 0.0, 1.0, 1.0);
                tessellator.addVertexWithUV(x - 1, y - 1, 0.0, 0.0, 0.0);
                tessellator.draw();
                GL11.glEnable((int)3553);
            }
            this.texturePack.bindThumbnailTexture(ButtonComponent.mc);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0xFFFFFF);
            tessellator.addVertexWithUV(x, y + 32, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(x + 32, y + 32, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(x + 32, y, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(x, y, 0.0, 0.0, 0.0);
            tessellator.draw();
            int rgbVersion = 0x808080;
            int format = this.texturePack.manifest.getFormat();
            if (format == 1) {
                fontRenderer.drawString(this.texturePack.manifest.getName(), x + 32 + 2, y + 1, 0xFFFFFF);
                fontRenderer.drawString(this.texturePack.manifest.getDescriptionLine1(), x + 32 + 2, y + 12, 0x808080);
                fontRenderer.drawString(this.texturePack.manifest.getDescriptionLine2(), x + 32 + 2, y + 22, 0x808080);
            } else if (format == -1) {
                fontRenderer.drawString(TextFormatting.RED + this.texturePack.manifest.getName(), x + 32 + 2, y + 1, 0xFFFFFF);
                fontRenderer.drawString(this.texturePack.manifest.getDescriptionLine1(), x + 32 + 2, y + 12, 0x808080);
                fontRenderer.drawString(this.texturePack.manifest.getDescriptionLine2(), x + 32 + 2, y + 22, 0x808080);
                rgbVersion = Colors.allChatColors[TextFormatting.RED.id].getARGB();
            } else {
                I18n i18n = I18n.getInstance();
                fontRenderer.drawString(TextFormatting.RED + this.texturePack.manifest.getName(), x + 32 + 2, y + 1, 0xFFFFFF);
                fontRenderer.drawString(i18n.translateKey("gui.options.page.texture_packs.label.outdated_pack.1"), x + 32 + 2, y + 12, 0x808080);
                fontRenderer.drawString(i18n.translateKey("gui.options.page.texture_packs.label.outdated_pack.2"), x + 32 + 2, y + 22, 0x808080);
                rgbVersion = Colors.allChatColors[TextFormatting.RED.id].getARGB();
            }
            String version = this.texturePack.manifest.getPackVersion();
            int versionWidth = fontRenderer.getStringWidth(version);
            fontRenderer.drawString(this.texturePack.manifest.getPackVersion(), x + width - versionWidth - 2, y + 1, rgbVersion);
        }
    }
}

