/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input;

import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.input.controller.ControllerInput;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class InputHandler {
    public static List<ControllerInput> controllers;

    public static void init(Minecraft minecraft) throws Exception {
        System.out.println("Creating Keyboard & Mouse");
        Keyboard.create();
        Mouse.create();
        if (!((Boolean)minecraft.gameSettings.disableJInput.value).booleanValue()) {
            try {
                InputHandler.initJInput(minecraft);
            }
            catch (Throwable e) {
                System.err.println("Could not initialize JInput.");
                e.printStackTrace();
            }
        } else {
            System.err.println("JInput is disabled!");
        }
    }

    public static void initJInput(Minecraft minecraft) throws Throwable {
        Controller[] devices = InputHandler.getControllers();
        if (devices == null) {
            System.err.println("Could not get devices!");
            return;
        }
        System.out.println(devices.length + " Devices found!");
        ArrayList<ControllerInput> controllerList = new ArrayList<ControllerInput>();
        for (Controller controller : devices) {
            if (controller.getType() == Controller.Type.GAMEPAD) {
                controllerList.add(new ControllerInput(minecraft, controller));
            }
            if (controller.getType() != Controller.Type.MOUSE) continue;
            minecraft.mouseInput.addMouse(controller);
        }
        controllers = controllerList;
    }

    public static Controller[] getControllers() throws Throwable {
        return ControllerEnvironment.getDefaultEnvironment().getControllers();
    }

    public static ControllerInput getController(String name) {
        try {
            for (ControllerInput controllerInput : controllers) {
                if (!controllerInput.getController().getName().equalsIgnoreCase(name)) continue;
                return controllerInput;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Component getComponent(Controller controller, String id) {
        try {
            for (Component component : controller.getComponents()) {
                if (!component.getIdentifier().toString().equalsIgnoreCase(id)) continue;
                return component;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

