/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input;

import net.minecraft.client.Minecraft;
import net.minecraft.client.input.InputType;
import net.minecraft.client.option.GameSettings;
import net.minecraft.core.entity.player.EntityPlayer;

public class PlayerInput {
    public final Minecraft mc;
    public final GameSettings gameSettings;
    private boolean isAutoWalkOn = false;
    private boolean pressedForward;
    private boolean pressedBackward;
    private boolean pressedLeft;
    private boolean pressedRight;
    private boolean pressedJump;
    public boolean pressedLookUp;
    public boolean pressedLookDown;
    public boolean pressedLookLeft;
    public boolean pressedLookRight;
    public float moveStrafe;
    public float moveForward;
    public boolean jump;
    public boolean sneak;

    public PlayerInput(Minecraft minecraft) {
        this.mc = minecraft;
        this.gameSettings = this.mc.gameSettings;
    }

    public void keyEvent(int keyCode, boolean pressed) {
        if (this.mc.currentScreen != null) {
            return;
        }
        if (this.gameSettings.keySneak.isKeyboardKey(keyCode)) {
            if (((Boolean)this.gameSettings.sneakToggle.value).booleanValue()) {
                if (pressed) {
                    this.sneak = !this.sneak;
                }
            } else {
                this.sneak = pressed;
            }
        }
        if (this.gameSettings.keyForward.isKeyboardKey(keyCode)) {
            this.pressedForward = pressed;
            this.isAutoWalkOn = false;
        }
        if (this.gameSettings.keyBack.isKeyboardKey(keyCode)) {
            this.pressedBackward = pressed;
            this.isAutoWalkOn = false;
        }
        if (this.gameSettings.keyLeft.isKeyboardKey(keyCode)) {
            this.pressedLeft = pressed;
        }
        if (this.gameSettings.keyRight.isKeyboardKey(keyCode)) {
            this.pressedRight = pressed;
        }
        if (this.gameSettings.keyJump.isKeyboardKey(keyCode)) {
            this.pressedJump = pressed;
        }
        if (this.gameSettings.keyAutoWalk.isKeyboardKey(keyCode) && pressed) {
            this.isAutoWalkOn = true;
        }
    }

    public void onGameUnfocused() {
        this.pressedBackward = false;
        this.pressedForward = false;
        this.pressedLeft = false;
        this.pressedRight = false;
        this.pressedJump = false;
    }

    public void onGameFocused() {
        if (!((Boolean)this.gameSettings.sneakToggle.value).booleanValue()) {
            this.sneak = this.gameSettings.keySneak.isPressed();
        }
    }

    public void tick(EntityPlayer entityplayer) {
        if (this.gameSettings.mc.inputType == InputType.CONTROLLER) {
            if (this.gameSettings.mc.currentScreen == null) {
                this.moveForward = -this.gameSettings.mc.controllerInput.joyLeft.getY();
                this.moveStrafe = -this.gameSettings.mc.controllerInput.joyLeft.getX();
                this.jump = this.gameSettings.mc.controllerInput.buttonA.isPressed();
                if (this.gameSettings.mc.controllerInput.joyRight.getButton().pressedThisFrame()) {
                    this.sneak = !this.sneak;
                }
            } else {
                this.moveForward = 0.0f;
                this.moveStrafe = 0.0f;
                this.jump = false;
            }
            if (this.sneak && !entityplayer.noPhysics) {
                this.moveStrafe = (float)((double)this.moveStrafe * 0.3);
                this.moveForward = (float)((double)this.moveForward * 0.3);
            }
            return;
        }
        this.moveStrafe = 0.0f;
        this.moveForward = 0.0f;
        if (this.pressedForward || this.isAutoWalkOn) {
            this.moveForward += 1.0f;
        }
        if (this.pressedBackward) {
            this.moveForward -= 1.0f;
        }
        if (this.pressedLeft) {
            this.moveStrafe += 1.0f;
        }
        if (this.pressedRight) {
            this.moveStrafe -= 1.0f;
        }
        this.jump = this.pressedJump;
        if (this.sneak && !entityplayer.noPhysics) {
            this.moveStrafe = (float)((double)this.moveStrafe * 0.3);
            this.moveForward = (float)((double)this.moveForward * 0.3);
        }
    }
}

