/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net.handler;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import net.minecraft.client.gui.GuiSelectServer;
import net.minecraft.core.net.NetworkManager;
import net.minecraft.core.net.ServerData;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.Packet255KickDisconnect;

public class NetPingHandler
extends NetHandler {
    private boolean disconnected = false;
    private final GuiSelectServer gui;
    private final NetworkManager netManager;
    private final ServerData server;
    public static long startTime = 0L;

    public NetPingHandler(GuiSelectServer gui, ServerData server) throws IOException {
        this.gui = gui;
        this.server = server;
        Socket socket = new Socket(InetAddress.getByName(server.getHostName()), server.getPort());
        this.netManager = new NetworkManager(socket, "Ping", this, true);
    }

    public void processReadPackets() {
        if (!this.disconnected) {
            this.netManager.processReadPackets();
        }
        this.netManager.wakeThreads();
    }

    public void addToSendQueue(Packet packet) {
        if (!this.disconnected) {
            this.netManager.addToSendQueue(packet);
        }
    }

    @Override
    public boolean isServerHandler() {
        return false;
    }

    @Override
    public void handleKickDisconnect(Packet255KickDisconnect packet) {
        if (packet.reason.startsWith("\u00a71")) {
            String[] serverInfo = packet.reason.split("\u0000");
            this.server.isUp = true;
            this.server.protocolVersion = this.parseIntWithDefault(serverInfo[1], -1);
            this.server.version = serverInfo[2];
            this.server.motd = serverInfo[3];
            this.server.currentPlayers = this.parseIntWithDefault(serverInfo[4], -1);
            this.server.maxPlayers = this.parseIntWithDefault(serverInfo[5], -1);
            this.server.latency = System.currentTimeMillis() - startTime;
            this.gui.handleIncomingServerInfo(this.server);
            this.netManager.networkShutdown("disconnect.kicked", new Object[0]);
            this.disconnected = true;
        }
    }

    private int parseIntWithDefault(String s, int i) {
        try {
            return Integer.parseInt(s.trim());
        }
        catch (Exception exception) {
            return i;
        }
    }

    @Override
    public void handleErrorMessage(String s, Object[] aobj) {
        if (!this.disconnected) {
            this.disconnected = true;
        }
    }
}

