/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net.thread;

import net.minecraft.client.gui.GuiSelectServer;
import net.minecraft.client.net.handler.NetPingHandler;
import net.minecraft.core.net.ServerData;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet254PingHandshake;

public class ThreadPingServer
extends Thread {
    private final GuiSelectServer gui;
    private final ServerData server;
    private boolean done = false;
    private NetPingHandler netHandler = null;

    public ThreadPingServer(GuiSelectServer gui, ServerData server) {
        this.gui = gui;
        this.server = server;
        this.setName("ThreadPingServer - " + server.getHostName() + ":" + server.getPort());
    }

    public ServerData getServer() {
        return this.server;
    }

    public boolean isDone() {
        return this.done;
    }

    public void tickNetClientHandler() {
        if (this.netHandler != null && this.isDone()) {
            this.netHandler.processReadPackets();
        }
    }

    public NetHandler getNetHandler() {
        return this.netHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String hostName = this.server.getHostName();
        int port = this.server.getPort();
        try {
            this.netHandler = new NetPingHandler(this.gui, this.server);
            this.netHandler.addToSendQueue(new Packet254PingHandshake(1, 250, "BTAPingHost", 4919, hostName, port));
        }
        catch (Exception exception) {
        }
        finally {
            this.done = true;
        }
    }
}

