/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.option;

import net.minecraft.client.option.InputDevice;
import net.minecraft.core.lang.I18n;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class KeyBinding {
    private static String UNBOUND = "NONE";
    private static final String[] MOUSE_BUTTON_NAMES = new String[]{"LEFT CLICK", "RIGHT CLICK", "MIDDLE CLICK"};
    private final String id;
    private InputDevice inputDevice;
    private int keyCode;
    private InputDevice defaultInputDevice = null;
    private int defaultKeyCode = -1;

    public KeyBinding(String id) {
        this.id = id;
        this.inputDevice = null;
        this.keyCode = -1;
    }

    public KeyBinding bindKeyboard(int keyCode) {
        this.keyCode = keyCode;
        this.inputDevice = InputDevice.KEYBOARD;
        if (this.defaultInputDevice == null) {
            this.defaultInputDevice = InputDevice.KEYBOARD;
            this.defaultKeyCode = keyCode;
        }
        return this;
    }

    public KeyBinding bindMouse(int keyCode) {
        this.keyCode = keyCode;
        this.inputDevice = InputDevice.MOUSE;
        if (this.defaultInputDevice == null) {
            this.defaultInputDevice = InputDevice.MOUSE;
            this.defaultKeyCode = keyCode;
        }
        return this;
    }

    public KeyBinding unbind() {
        this.keyCode = -1;
        this.inputDevice = null;
        return this;
    }

    public KeyBinding resetToDefault() {
        this.keyCode = this.defaultKeyCode;
        this.inputDevice = this.defaultInputDevice;
        return this;
    }

    public boolean isDefault() {
        return this.keyCode == this.defaultKeyCode && this.inputDevice == this.defaultInputDevice;
    }

    public String getId() {
        return this.id;
    }

    public InputDevice getInputDevice() {
        return this.inputDevice;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public boolean isPressed() {
        if (!this.isBound()) {
            return false;
        }
        if (this.keyCode >= 0) {
            switch (this.inputDevice) {
                case KEYBOARD: {
                    return Keyboard.isKeyDown((int)this.keyCode);
                }
                case MOUSE: {
                    return Mouse.isButtonDown((int)this.keyCode);
                }
            }
        }
        return false;
    }

    public boolean isPressEvent(InputDevice eventInputDevice) {
        if (!this.isBound() || eventInputDevice != this.inputDevice) {
            return false;
        }
        switch (this.inputDevice) {
            case KEYBOARD: {
                return Keyboard.getEventKey() == this.keyCode && Keyboard.getEventKeyState();
            }
            case MOUSE: {
                return Mouse.getEventButton() == this.keyCode && Mouse.getEventButtonState();
            }
        }
        return false;
    }

    public boolean isReleaseEvent(InputDevice eventInputDevice) {
        if (!this.isBound() || eventInputDevice != this.inputDevice) {
            return false;
        }
        switch (this.inputDevice) {
            case KEYBOARD: {
                return Keyboard.getEventKey() == this.keyCode && !Keyboard.getEventKeyState();
            }
            case MOUSE: {
                return Mouse.getEventButton() == this.keyCode && !Mouse.getEventButtonState();
            }
        }
        return false;
    }

    public void fromOptionsString(String value) {
        if (value.equals(UNBOUND)) {
            this.unbind();
            return;
        }
        if (value.startsWith("m")) {
            this.bindMouse(Integer.parseInt(value.substring(1)));
        } else if (value.startsWith("k")) {
            this.bindKeyboard(Integer.parseInt(value.substring(1)));
        } else {
            this.bindKeyboard(Integer.parseInt(value));
        }
    }

    public String toOptionsString() {
        if (!this.isBound()) {
            return UNBOUND;
        }
        switch (this.inputDevice) {
            case KEYBOARD: {
                return "k" + this.keyCode;
            }
            case MOUSE: {
                return "m" + this.keyCode;
            }
        }
        return "";
    }

    public boolean isKeyboardKey(int key) {
        if (this.keyCode <= 0 || this.inputDevice != InputDevice.KEYBOARD) {
            return false;
        }
        return this.keyCode == key;
    }

    public boolean isMouseButton(int button) {
        if (this.keyCode < 0 || this.inputDevice != InputDevice.MOUSE) {
            return false;
        }
        return this.keyCode == button;
    }

    public boolean isBound() {
        return !(this.inputDevice == null || this.inputDevice == InputDevice.KEYBOARD && this.keyCode <= 0 || this.inputDevice == InputDevice.MOUSE && this.keyCode < 0);
    }

    public String getKeyName() {
        if (!this.isBound()) {
            return I18n.getInstance().translateKey("key.disabled");
        }
        switch (this.inputDevice) {
            case KEYBOARD: {
                return Keyboard.getKeyName((int)this.keyCode);
            }
            case MOUSE: {
                if (this.keyCode < MOUSE_BUTTON_NAMES.length) {
                    return MOUSE_BUTTON_NAMES[this.keyCode];
                }
                return "MOUSE " + (this.keyCode + 1);
            }
        }
        return "";
    }
}

