/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.entity.fx.EntityDiggingFX;
import net.minecraft.client.entity.fx.EntityFX;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.tessalator.TessellatorStandard;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class EffectRenderer {
    protected World worldObj;
    private List[] fxLayers = new List[4];
    private RenderEngine renderer;
    private Random rand = new Random();

    public EffectRenderer(World world, RenderEngine renderengine) {
        if (world != null) {
            this.worldObj = world;
        }
        this.renderer = renderengine;
        for (int i = 0; i < 4; ++i) {
            this.fxLayers[i] = new ArrayList();
        }
    }

    public void addEffect(EntityFX entityfx) {
        int i = entityfx.getFXLayer();
        if (this.fxLayers[i].size() >= 4000) {
            this.fxLayers[i].remove(0);
        }
        this.fxLayers[i].add(entityfx);
    }

    public void updateEffects() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < this.fxLayers[i].size(); ++j) {
                EntityFX entityfx = (EntityFX)this.fxLayers[i].get(j);
                entityfx.tick();
                if (!entityfx.removed) continue;
                this.fxLayers[i].remove(j--);
            }
        }
    }

    public void renderParticles(ICamera camera, float partialTick) {
        double pitch = camera.getXRot(partialTick);
        double yaw = camera.getYRot(partialTick);
        float rotationX = MathHelper.cos((float)(yaw * Math.PI) / 180.0f);
        float rotationZ = MathHelper.sin((float)(yaw * Math.PI) / 180.0f);
        float rotationYZ = -rotationZ * MathHelper.sin((float)(pitch * Math.PI / 180.0));
        float rotationXY = rotationX * MathHelper.sin((float)(pitch * Math.PI / 180.0));
        float rotationXZ = MathHelper.cos((float)(pitch * Math.PI / 180.0));
        EntityFX.lerpPosX = camera.getX(partialTick);
        EntityFX.lerpPosY = camera.getY(partialTick);
        EntityFX.lerpPosZ = camera.getZ(partialTick);
        for (int i = 0; i < 3; ++i) {
            if (this.fxLayers[i].size() == 0) continue;
            int texture = 0;
            if (i == 0) {
                texture = this.renderer.getTexture("/particles.png");
            }
            if (i == 1) {
                texture = this.renderer.getTexture("/terrain.png");
            }
            if (i == 2) {
                texture = this.renderer.getTexture("/gui/items.png");
            }
            GL11.glBindTexture((int)3553, (int)texture);
            TessellatorStandard tessellator = TessellatorStandard.instance;
            tessellator.startDrawingQuads();
            for (int k = 0; k < this.fxLayers[i].size(); ++k) {
                EntityFX entityfx = (EntityFX)this.fxLayers[i].get(k);
                entityfx.renderParticle(tessellator, partialTick, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
            }
            tessellator.draw();
        }
    }

    public void renderParticlesAtOrigin(float partialTick) {
        int layerId = 3;
        if (this.fxLayers[layerId].size() == 0) {
            return;
        }
        TessellatorStandard tessellator = TessellatorStandard.instance;
        for (int i = 0; i < this.fxLayers[layerId].size(); ++i) {
            EntityFX entityfx = (EntityFX)this.fxLayers[layerId].get(i);
            entityfx.renderParticle(tessellator, partialTick, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    public void clearEffects(World world) {
        this.worldObj = world;
        for (int i = 0; i < 4; ++i) {
            this.fxLayers[i].clear();
        }
    }

    public void addBlockDestroyEffects(int i, int j, int k, int l, int i1) {
        if (l == 0) {
            return;
        }
        Block block = Block.blocksList[l];
        int j1 = 4;
        if (block == Block.fire) {
            return;
        }
        for (int k1 = 0; k1 < j1; ++k1) {
            for (int l1 = 0; l1 < j1; ++l1) {
                for (int i2 = 0; i2 < j1; ++i2) {
                    double d = (double)i + ((double)k1 + 0.5) / (double)j1;
                    double d1 = (double)j + ((double)l1 + 0.5) / (double)j1;
                    double d2 = (double)k + ((double)i2 + 0.5) / (double)j1;
                    int j2 = this.rand.nextInt(6);
                    this.addEffect(new EntityDiggingFX(this.worldObj, d, d1, d2, d - (double)i - 0.5, d1 - (double)j - 0.5, d2 - (double)k - 0.5, block, i1).func_4041_a(i, j, k));
                }
            }
        }
    }

    public void addBlockHitEffects(int i, int j, int k, Side side) {
        int l = side.getId();
        int i1 = this.worldObj.getBlockId(i, j, k);
        if (i1 == 0) {
            return;
        }
        Block block = Block.blocksList[i1];
        float f = 0.1f;
        double d = (double)i + this.rand.nextDouble() * (block.maxX - block.minX - (double)(f * 2.0f)) + (double)f + block.minX;
        double d1 = (double)j + this.rand.nextDouble() * (block.maxY - block.minY - (double)(f * 2.0f)) + (double)f + block.minY;
        double d2 = (double)k + this.rand.nextDouble() * (block.maxZ - block.minZ - (double)(f * 2.0f)) + (double)f + block.minZ;
        if (l == 0) {
            d1 = (double)j + block.minY - (double)f;
        }
        if (l == 1) {
            d1 = (double)j + block.maxY + (double)f;
        }
        if (l == 2) {
            d2 = (double)k + block.minZ - (double)f;
        }
        if (l == 3) {
            d2 = (double)k + block.maxZ + (double)f;
        }
        if (l == 4) {
            d = (double)i + block.minX - (double)f;
        }
        if (l == 5) {
            d = (double)i + block.maxX + (double)f;
        }
        this.addEffect(new EntityDiggingFX(this.worldObj, d, d1, d2, 0.0, 0.0, 0.0, block, this.worldObj.getBlockMetadata(i, j, k)).func_4041_a(i, j, k).func_407_b(0.2f).func_405_d(0.6f));
    }

    public String getNumParticlesString() {
        return "" + (this.fxLayers[0].size() + this.fxLayers[1].size() + this.fxLayers[2].size());
    }
}

