/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.nio.FloatBuffer;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiPhotoMode;
import net.minecraft.client.option.enums.RenderDistance;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.camera.CameraUtil;
import net.minecraft.client.render.colorizer.ColorizerWater;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class FogManager {
    public static final int FOG_MODE_SKY = -1;
    public static final int FOG_MODE_NORMAL = 0;
    private final Minecraft mc;
    private float fogRed;
    private float fogGreen;
    private float fogBlue;
    private float fogBrightnessOld;
    private float fogBrightness;
    private final FloatBuffer fogColorBuffer = GLAllocation.createDirectFloatBuffer(16);

    public FogManager(Minecraft mc) {
        this.mc = mc;
    }

    public void updateBrightness() {
        this.fogBrightnessOld = this.fogBrightness;
        float fogModifier = this.mc.theWorld.getCurrentWeather() != null ? this.mc.theWorld.getCurrentWeather().fogDistance : 1.0f;
        fogModifier = 1.0f - (1.0f - fogModifier) * this.mc.theWorld.weatherManager.getWeatherIntensity() * this.mc.theWorld.weatherManager.getWeatherPower();
        float brightnessAtCamera = this.mc.theWorld.getLightBrightness(MathHelper.floor_double(this.mc.activeCamera.getX(1.0f)), MathHelper.floor_double(this.mc.activeCamera.getY(1.0f)), MathHelper.floor_double(this.mc.activeCamera.getZ(1.0f)));
        if (this.mc.fullbright) {
            brightnessAtCamera = 1.0f;
        }
        float renderDistanceModifier = (float)(3 - ((RenderDistance)((Object)this.mc.gameSettings.renderDistance.value)).legacyValue) * fogModifier / 3.0f;
        float newBrightness = brightnessAtCamera * (1.0f - renderDistanceModifier) + renderDistanceModifier;
        this.fogBrightness += (newBrightness - this.fogBrightness) * 0.1f;
    }

    public void setupFog(int fogMode, float farPlaneDistance, float partialTick) {
        GL11.glFog((int)2918, (FloatBuffer)this.getFogColor(this.fogRed, this.fogGreen, this.fogBlue, 0.5f));
        GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.theWorld, Material.water, partialTick)) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)0.1f);
        } else if (CameraUtil.isUnderLiquid(this.mc.activeCamera, this.mc.theWorld, Material.lava, partialTick)) {
            GL11.glFogi((int)2917, (int)2048);
            GL11.glFogf((int)2914, (float)2.0f);
        } else {
            float maxFogDistance = RenderDistance.EXTREME.chunks * 16;
            float fogDistance = farPlaneDistance;
            float fogModifier = this.mc.theWorld.getCurrentWeather() != null ? this.mc.theWorld.getCurrentWeather().fogDistance : 1.0f;
            if (fogDistance > maxFogDistance * (fogModifier = 1.0f - (1.0f - fogModifier) * this.mc.theWorld.weatherManager.getWeatherIntensity() * this.mc.theWorld.weatherManager.getWeatherPower())) {
                fogDistance = maxFogDistance * fogModifier;
            }
            if (this.mc.currentScreen instanceof GuiPhotoMode) {
                fogDistance = farPlaneDistance * ((GuiPhotoMode)this.mc.currentScreen).getFog(partialTick);
            }
            GL11.glFogi((int)2917, (int)9729);
            GL11.glFogf((int)2915, (float)(fogDistance * 0.25f));
            GL11.glFogf((int)2916, (float)fogDistance);
            GL11.glFogf((int)2914, (float)1.0f);
            if (fogMode == -1) {
                GL11.glFogf((int)2915, (float)0.0f);
                GL11.glFogf((int)2916, (float)(fogDistance * 0.8f));
            }
            if (OpenGLHelper.enableSphericalFog) {
                GL11.glFogi((int)34138, (int)34139);
            }
            if (this.mc.theWorld.dimension == Dimension.nether) {
                GL11.glFogf((int)2915, (float)0.0f);
            }
        }
        GL11.glEnable((int)2903);
        GL11.glColorMaterial((int)1028, (int)4608);
    }

    public void updateFogColor(float partialTick) {
        World world = this.mc.theWorld;
        float renderDistanceScale = 1.0f / (float)(4 - ((RenderDistance)((Object)this.mc.gameSettings.renderDistance.value)).legacyValue);
        renderDistanceScale = 1.0f - (float)Math.pow(renderDistanceScale, 0.25);
        Vec3d skyColor = world.getSkyColor(this.mc.activeCamera, partialTick);
        float rSky = (float)skyColor.xCoord;
        float gSky = (float)skyColor.yCoord;
        float bSky = (float)skyColor.zCoord;
        Vec3d worldColor = world.getFogColor(partialTick);
        this.fogRed = (float)worldColor.xCoord;
        this.fogGreen = (float)worldColor.yCoord;
        this.fogBlue = (float)worldColor.zCoord;
        this.fogRed += (rSky - this.fogRed) * renderDistanceScale;
        this.fogGreen += (gSky - this.fogGreen) * renderDistanceScale;
        this.fogBlue += (bSky - this.fogBlue) * renderDistanceScale;
        if (world.getCurrentWeather() != null) {
            float[] out = world.getCurrentWeather().modifyFogColor(this.fogRed, this.fogGreen, this.fogBlue, world.weatherManager.getWeatherIntensity() * world.weatherManager.getWeatherPower());
            this.fogRed = out[0];
            this.fogGreen = out[1];
            this.fogBlue = out[2];
        }
        if (CameraUtil.isUnderLiquid(this.mc.activeCamera, world, Material.water, partialTick)) {
            this.fogRed = 0.02f;
            this.fogGreen = 0.02f;
            this.fogBlue = 0.2f;
            if (((Boolean)this.mc.gameSettings.biomeWater.value).booleanValue()) {
                int x = MathHelper.floor_double(this.mc.activeCamera.getX(partialTick));
                int z = MathHelper.floor_double(this.mc.activeCamera.getZ(partialTick));
                double temp = world.getBlockTemperature(x, z);
                double humid = world.getBlockHumidity(x, z);
                int waterColor = ColorizerWater.getWaterColor(temp, humid);
                float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
                float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
                float blue = (float)(waterColor & 0xFF) / 255.0f;
                red = MathHelper.clamp(red, 0.0f, 1.0f);
                green = MathHelper.clamp(green, 0.0f, 1.0f);
                blue = MathHelper.clamp(blue, 0.0f, 1.0f);
                this.fogRed = red * 0.5f;
                this.fogGreen = green * 0.5f;
                this.fogBlue = blue * 0.5f;
            }
        } else if (CameraUtil.isUnderLiquid(this.mc.activeCamera, world, Material.lava, partialTick)) {
            this.fogRed = 0.6f;
            this.fogGreen = 0.1f;
            this.fogBlue = 0.0f;
        }
        float brightness = this.fogBrightnessOld + (this.fogBrightness - this.fogBrightnessOld) * partialTick;
        this.fogRed *= brightness;
        this.fogGreen *= brightness;
        this.fogBlue *= brightness;
        GL11.glClearColor((float)this.fogRed, (float)this.fogGreen, (float)this.fogBlue, (float)0.0f);
    }

    private FloatBuffer getFogColor(float r, float g, float b, float a) {
        this.fogColorBuffer.clear();
        this.fogColorBuffer.put(r).put(g).put(b).put(a);
        this.fogColorBuffer.flip();
        return this.fogColorBuffer;
    }
}

