/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.RenderBlockCache;
import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.opengl.GL11;

public class RenderBlocks {
    public WorldSource blockAccess;
    private Minecraft mc;
    public World world;
    public int overrideBlockTexture = -1;
    public boolean flipTexture = false;
    public boolean renderAllFaces = false;
    public byte renderBitMask;
    public static boolean fancyGrass = true;
    public static final float[] SIDE_LIGHT_MULTIPLIER = new float[]{0.5f, 1.0f, 0.8f, 0.8f, 0.6f, 0.6f};
    public boolean useInventoryTint = true;
    public int uvRotateEast = 0;
    public int uvRotateWest = 0;
    public int uvRotateSouth = 0;
    public int uvRotateNorth = 0;
    public int uvRotateTop = 0;
    public int uvRotateBottom = 0;
    public boolean enableAO;
    public int field_22352_G = 1;
    public float colorRedTopLeft;
    public float colorRedBottomLeft;
    public float colorRedBottomRight;
    public float colorRedTopRight;
    public float colorGreenTopLeft;
    public float colorGreenBottomLeft;
    public float colorGreenBottomRight;
    public float colorGreenTopRight;
    public float colorBlueTopLeft;
    public float colorBlueBottomLeft;
    public float colorBlueBottomRight;
    public float colorBlueTopRight;
    public boolean overbright;
    public RenderBlockCache cache = new RenderBlockCache();

    public RenderBlocks(World world, WorldSource worldSource) {
        this.blockAccess = worldSource;
        this.renderBitMask = 0;
        this.world = world;
        this.mc = Minecraft.getMinecraft(this);
    }

    public RenderBlocks() {
        this.renderBitMask = 0;
        this.mc = Minecraft.getMinecraft(this);
    }

    public float getBlockBrightness(WorldSource blockAccess, int x, int y, int z) {
        if (this.mc.fullbright) {
            return 1.0f;
        }
        int id = blockAccess.getBlockId(x, y, z);
        Block block = blockAccess.getBlock(x, y, z);
        if (block != null) {
            return block.getBlockBrightness(blockAccess, x, y, z);
        }
        return blockAccess.getBrightness(x, y, z, Block.lightEmission[id]);
    }

    public void renderBlockFallingSand(Tessellator tessellator, BlockModel<Block> blockModel, Block block, World world, int i, int j, int k) {
        float f = 0.5f;
        float f1 = 1.0f;
        float f2 = 0.8f;
        float f3 = 0.6f;
        tessellator.startDrawingQuads();
        float f4 = this.getBlockBrightness(world, i, j, k);
        float f5 = this.getBlockBrightness(world, i, j - 1, k);
        int meta = world.getBlockMetadata(i, j, k);
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f * f5, f * f5, f * f5);
        this.renderBottomFace(tessellator, block, -0.5, -0.5, -0.5, blockModel.getBlockTextureFromSideAndMetadata(Side.BOTTOM, meta));
        f5 = this.getBlockBrightness(world, i, j + 1, k);
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f1 * f5, f1 * f5, f1 * f5);
        this.renderTopFace(tessellator, block, -0.5, -0.5, -0.5, blockModel.getBlockTextureFromSideAndMetadata(Side.TOP, meta));
        f5 = this.getBlockBrightness(world, i, j, k - 1);
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f2 * f5, f2 * f5, f2 * f5);
        this.renderNorthFace(tessellator, block, -0.5, -0.5, -0.5, blockModel.getBlockTextureFromSideAndMetadata(Side.NORTH, meta));
        f5 = this.getBlockBrightness(world, i, j, k + 1);
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f2 * f5, f2 * f5, f2 * f5);
        this.renderSouthFace(tessellator, block, -0.5, -0.5, -0.5, blockModel.getBlockTextureFromSideAndMetadata(Side.SOUTH, meta));
        f5 = this.getBlockBrightness(world, i - 1, j, k);
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f3 * f5, f3 * f5, f3 * f5);
        this.renderWestFace(tessellator, block, -0.5, -0.5, -0.5, blockModel.getBlockTextureFromSideAndMetadata(Side.WEST, meta));
        f5 = this.getBlockBrightness(world, i + 1, j, k);
        if (f5 < f4) {
            f5 = f4;
        }
        tessellator.setColorOpaque_F(f3 * f5, f3 * f5, f3 * f5);
        this.renderEastFace(tessellator, block, -0.5, -0.5, -0.5, blockModel.getBlockTextureFromSideAndMetadata(Side.EAST, meta));
        tessellator.draw();
    }

    public boolean renderStandardBlock(Tessellator tessellator, BlockModel<Block> blockModel, Block block, int x, int y, int z) {
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(block)).getWorldColor(this.world, x, y, z);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return this.renderStandardBlock(tessellator, blockModel, block, x, y, z, r, g, b);
    }

    public boolean renderStandardBlock(Tessellator tessellator, BlockModel<Block> blockModel, Block block, int x, int y, int z, float r, float g, float b) {
        this.enableAO = true;
        int meta = this.blockAccess.getBlockMetadata(x, y, z);
        this.cache.setupCache(block, this.blockAccess, x, y, z);
        boolean somethingRendered = false;
        for (Side side : Side.sides) {
            somethingRendered |= this.renderSide(tessellator, blockModel, block, x, y, z, r, g, b, side, meta);
        }
        this.enableAO = false;
        return somethingRendered;
    }

    public final boolean renderSide(Tessellator tessellator, BlockModel<Block> blockModel, Block block, int x, int y, int z, float r, float g, float b, Side side, int meta) {
        switch (side) {
            case BOTTOM: {
                boolean useColor = blockModel.shouldSideBeColored(this.blockAccess, x, y, z, 0, meta);
                return this.renderSide(tessellator, blockModel, block, x, y, z, useColor ? r : 1.0f, useColor ? g : 1.0f, useColor ? b : 1.0f, 0, meta, 0, -1, 0, (float)block.minY, 0, 0, 1, (float)block.maxZ, (float)block.minZ, -1, 0, 0, 1.0f - (float)block.minX, 1.0f - (float)block.maxX);
            }
            case TOP: {
                boolean useColor = blockModel.shouldSideBeColored(this.blockAccess, x, y, z, 1, meta);
                return this.renderSide(tessellator, blockModel, block, x, y, z, useColor ? r : 1.0f, useColor ? g : 1.0f, useColor ? b : 1.0f, 1, meta, 0, 1, 0, 1.0f - (float)block.maxY, 0, 0, 1, (float)block.maxZ, (float)block.minZ, 1, 0, 0, (float)block.maxX, (float)block.minX);
            }
            case NORTH: {
                boolean useColor = blockModel.shouldSideBeColored(this.blockAccess, x, y, z, 2, meta);
                return this.renderSide(tessellator, blockModel, block, x, y, z, useColor ? r : 1.0f, useColor ? g : 1.0f, useColor ? b : 1.0f, 2, meta, 0, 0, -1, (float)block.minZ, -1, 0, 0, 1.0f - (float)block.minX, 1.0f - (float)block.maxX, 0, 1, 0, (float)block.maxY, (float)block.minY);
            }
            case SOUTH: {
                boolean useColor = blockModel.shouldSideBeColored(this.blockAccess, x, y, z, 3, meta);
                return this.renderSide(tessellator, blockModel, block, x, y, z, useColor ? r : 1.0f, useColor ? g : 1.0f, useColor ? b : 1.0f, 3, meta, 0, 0, 1, 1.0f - (float)block.maxZ, 0, 1, 0, (float)block.maxY, (float)block.minY, -1, 0, 0, 1.0f - (float)block.minX, 1.0f - (float)block.maxX);
            }
            case WEST: {
                boolean useColor = blockModel.shouldSideBeColored(this.blockAccess, x, y, z, 4, meta);
                return this.renderSide(tessellator, blockModel, block, x, y, z, useColor ? r : 1.0f, useColor ? g : 1.0f, useColor ? b : 1.0f, 4, meta, -1, 0, 0, (float)block.minX, 0, 0, 1, (float)block.maxZ, (float)block.minZ, 0, 1, 0, (float)block.maxY, (float)block.minY);
            }
            case EAST: {
                boolean useColor = blockModel.shouldSideBeColored(this.blockAccess, x, y, z, 5, meta);
                return this.renderSide(tessellator, blockModel, block, x, y, z, useColor ? r : 1.0f, useColor ? g : 1.0f, useColor ? b : 1.0f, 5, meta, 1, 0, 0, 1.0f - (float)block.maxX, 0, 0, 1, (float)block.maxZ, (float)block.minZ, 0, -1, 0, 1.0f - (float)block.minY, 1.0f - (float)block.maxY);
            }
        }
        throw new IllegalArgumentException("Side " + (Object)((Object)side) + " not expected!");
    }

    public final boolean renderSide(Tessellator tessellator, BlockModel<Block> blockModel, Block block, int x, int y, int z, float r, float g, float b, int side, int meta, int dirX, int dirY, int dirZ, float depth, int topX, int topY, int topZ, float topP, float botP, int lefX, int lefY, int lefZ, float lefP, float rigP) {
        int tex = this.overbright ? blockModel.getBlockOverbrightTexture(this.blockAccess, x, y, z, side) : blockModel.getBlockTexture(this.blockAccess, x, y, z, Side.getSideById(side));
        if (tex < 0 || (this.renderBitMask >> side & 1) != 0) {
            return false;
        }
        boolean rendered = false;
        block.setBlockBoundsBasedOnSide(this.world, x, y, z, Side.getSideById(side));
        if (this.renderAllFaces || blockModel.shouldSideBeRendered(this.blockAccess, x + dirX, y + dirY, z + dirZ, side, meta)) {
            float lightTL;
            float lightBL;
            float lightBR;
            float lightTR;
            if (this.overbright) {
                lightTR = 1.0f;
                lightBR = 1.0f;
                lightBL = 1.0f;
                lightTL = 1.0f;
            } else if (this.field_22352_G <= 0) {
                lightBR = lightTR = this.cache.getBrightness(dirX, dirY, dirZ);
                lightBL = lightTR;
                lightTL = lightTR;
            } else if (this.mc.isAmbientOcclusionEnabled()) {
                float dirB = this.cache.getBrightness(dirX, dirY, dirZ);
                boolean lefT = this.cache.getOpacity(dirX + lefX, dirY + lefY, dirZ + lefZ);
                boolean botT = this.cache.getOpacity(dirX - topX, dirY - topY, dirZ - topZ);
                boolean topT = this.cache.getOpacity(dirX + topX, dirY + topY, dirZ + topZ);
                boolean rigT = this.cache.getOpacity(dirX - lefX, dirY - lefY, dirZ - lefZ);
                float lB = this.cache.getBrightness(dirX + lefX, dirY + lefY, dirZ + lefZ);
                float bB = this.cache.getBrightness(dirX - topX, dirY - topY, dirZ - topZ);
                float tB = this.cache.getBrightness(dirX + topX, dirY + topY, dirZ + topZ);
                float rB = this.cache.getBrightness(dirX - lefX, dirY - lefY, dirZ - lefZ);
                float blB = botT && lefT ? lB : this.cache.getBrightness(dirX + lefX - topX, dirY + lefY - topY, dirZ + lefZ - topZ);
                float tlB = topT && lefT ? lB : this.cache.getBrightness(dirX + lefX + topX, dirY + lefY + topY, dirZ + lefZ + topZ);
                float brB = botT && rigT ? rB : this.cache.getBrightness(dirX - lefX - topX, dirY - lefY - topY, dirZ - lefZ - topZ);
                float trB = topT && rigT ? rB : this.cache.getBrightness(dirX - lefX + topX, dirY - lefY + topY, dirZ - lefZ + topZ);
                lightTL = (tlB + lB + tB + dirB) / 4.0f;
                lightTR = (tB + dirB + trB + rB) / 4.0f;
                lightBR = (dirB + bB + rB + brB) / 4.0f;
                lightBL = (lB + blB + dirB + bB) / 4.0f;
                if ((double)depth > 0.01) {
                    dirB = this.cache.getBrightness(0, 0, 0);
                    lefT = this.cache.getOpacity(lefX, lefY, lefZ);
                    botT = this.cache.getOpacity(-topX, -topY, -topZ);
                    topT = this.cache.getOpacity(topX, topY, topZ);
                    rigT = this.cache.getOpacity(-lefX, -lefY, -lefZ);
                    lB = this.cache.getBrightness(lefX, lefY, lefZ);
                    bB = this.cache.getBrightness(-topX, -topY, -topZ);
                    tB = this.cache.getBrightness(topX, topY, topZ);
                    rB = this.cache.getBrightness(-lefX, -lefY, -lefZ);
                    blB = botT && lefT ? lB : this.cache.getBrightness(lefX - topX, lefY - topY, lefZ - topZ);
                    tlB = topT && lefT ? lB : this.cache.getBrightness(lefX + topX, lefY + topY, lefZ + topZ);
                    brB = botT && rigT ? rB : this.cache.getBrightness(-lefX - topX, -lefY - topY, -lefZ - topZ);
                    trB = topT && rigT ? rB : this.cache.getBrightness(-lefX + topX, -lefY + topY, -lefZ + topZ);
                    lightTL = (tlB + lB + tB + dirB) / 4.0f * depth + lightTL * (1.0f - depth);
                    lightTR = (tB + dirB + trB + rB) / 4.0f * depth + lightTR * (1.0f - depth);
                    lightBR = (dirB + bB + rB + brB) / 4.0f * depth + lightBR * (1.0f - depth);
                    lightBL = (lB + blB + dirB + bB) / 4.0f * depth + lightBL * (1.0f - depth);
                }
            } else {
                float brightness;
                lightBR = lightTR = (brightness = this.cache.getBrightness(dirX, dirY, dirZ));
                lightBL = lightTR;
                lightTL = lightTR;
            }
            if (this.overbright) {
                this.colorRedBottomRight = this.colorRedTopRight = r;
                this.colorRedBottomLeft = this.colorRedTopRight;
                this.colorRedTopLeft = this.colorRedTopRight;
                this.colorGreenBottomRight = this.colorGreenTopRight = g;
                this.colorGreenBottomLeft = this.colorGreenTopRight;
                this.colorGreenTopLeft = this.colorGreenTopRight;
                this.colorBlueBottomRight = this.colorBlueTopRight = b;
                this.colorBlueBottomLeft = this.colorBlueTopRight;
                this.colorBlueTopLeft = this.colorBlueTopRight;
            } else {
                this.colorRedBottomRight = this.colorRedTopRight = r * SIDE_LIGHT_MULTIPLIER[side];
                this.colorRedBottomLeft = this.colorRedTopRight;
                this.colorRedTopLeft = this.colorRedTopRight;
                this.colorGreenBottomRight = this.colorGreenTopRight = g * SIDE_LIGHT_MULTIPLIER[side];
                this.colorGreenBottomLeft = this.colorGreenTopRight;
                this.colorGreenTopLeft = this.colorGreenTopRight;
                this.colorBlueBottomRight = this.colorBlueTopRight = b * SIDE_LIGHT_MULTIPLIER[side];
                this.colorBlueBottomLeft = this.colorBlueTopRight;
                this.colorBlueTopLeft = this.colorBlueTopRight;
            }
            float tl = topP * lightTL + (1.0f - topP) * lightBL;
            float tr = topP * lightTR + (1.0f - topP) * lightBR;
            float bl = botP * lightTL + (1.0f - botP) * lightBL;
            float br = botP * lightTR + (1.0f - botP) * lightBR;
            float ltl = lefP * tl + (1.0f - lefP) * tr;
            float lbl = lefP * bl + (1.0f - lefP) * br;
            float lbr = rigP * bl + (1.0f - rigP) * br;
            float ltr = rigP * tl + (1.0f - rigP) * tr;
            this.colorRedTopLeft *= ltl;
            this.colorGreenTopLeft *= ltl;
            this.colorBlueTopLeft *= ltl;
            this.colorRedBottomLeft *= lbl;
            this.colorGreenBottomLeft *= lbl;
            this.colorBlueBottomLeft *= lbl;
            this.colorRedBottomRight *= lbr;
            this.colorGreenBottomRight *= lbr;
            this.colorBlueBottomRight *= lbr;
            this.colorRedTopRight *= ltr;
            this.colorGreenTopRight *= ltr;
            this.colorBlueTopRight *= ltr;
            if (side == 0) {
                this.renderBottomFace(tessellator, block, x, y, z, tex);
            } else if (side == 1) {
                this.renderTopFace(tessellator, block, x, y, z, tex);
            } else if (side == 2) {
                this.renderNorthFace(tessellator, block, x, y, z, tex);
            } else if (side == 3) {
                this.renderSouthFace(tessellator, block, x, y, z, tex);
            } else if (side == 4) {
                this.renderWestFace(tessellator, block, x, y, z, tex);
            } else if (side == 5) {
                this.renderEastFace(tessellator, block, x, y, z, tex);
            }
            rendered = true;
        }
        return rendered;
    }

    public void renderBottomFace(Tessellator tessellator, Block block, double x, double y, double z, int tex) {
        if (this.overrideBlockTexture >= 0) {
            tex = this.overrideBlockTexture;
        }
        if (tex < 0) {
            return;
        }
        int j = tex % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k = tex / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d3 = ((double)j + block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d4 = ((double)j + block.maxX * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d5 = ((double)k + block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((double)k + block.maxZ * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        if (block.minX < 0.0 || block.maxX > 1.0) {
            d3 = ((float)j + 0.0f) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((float)j + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            d5 = ((float)k + 0.0f) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((float)k + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateBottom == 2) {
            d3 = ((double)j + block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)(k + TextureFX.tileWidthTerrain) - block.maxX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)j + block.maxZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)(k + TextureFX.tileWidthTerrain) - block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateBottom == 1) {
            d3 = ((double)(j + TextureFX.tileWidthTerrain) - block.maxZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)k + block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j + TextureFX.tileWidthTerrain) - block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)k + block.maxX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
            d3 = d7;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateBottom == 3) {
            d3 = ((double)(j + TextureFX.tileWidthTerrain) - block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j + TextureFX.tileWidthTerrain) - block.maxX * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)(k + TextureFX.tileWidthTerrain) - block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)(k + TextureFX.tileWidthTerrain) - block.maxZ * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = x + block.minX;
        double d12 = x + block.maxX;
        double d13 = y + block.minY;
        double d14 = z + block.minZ;
        double d15 = z + block.maxZ;
        if (this.enableAO) {
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
        } else {
            tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
            tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
        }
    }

    public void renderTopFace(Tessellator tessellator, Block block, double x, double y, double z, int tex) {
        if (this.overrideBlockTexture >= 0) {
            tex = this.overrideBlockTexture;
        }
        if (tex < 0) {
            return;
        }
        int j = tex % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k = tex / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d3 = ((double)j + block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d4 = ((double)j + block.maxX * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d5 = ((double)k + block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((double)k + block.maxZ * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        if (block.minX < 0.0 || block.maxX > 1.0) {
            d3 = ((float)j + 0.0f) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((float)j + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            d5 = ((float)k + 0.0f) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((float)k + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        }
        double d7 = d4;
        double d8 = d3;
        double d9 = d5;
        double d10 = d6;
        if (this.uvRotateTop == 1) {
            d3 = ((double)j + block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)(k + TextureFX.tileWidthTerrain) - block.maxX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)j + block.maxZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)(k + TextureFX.tileWidthTerrain) - block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
            d7 = d3;
            d8 = d4;
            d5 = d6;
            d6 = d9;
        } else if (this.uvRotateTop == 2) {
            d3 = ((double)(j + TextureFX.tileWidthTerrain) - block.maxZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)k + block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j + TextureFX.tileWidthTerrain) - block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)k + block.maxX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
            d3 = d7;
            d4 = d8;
            d9 = d6;
            d10 = d5;
        } else if (this.uvRotateTop == 3) {
            d3 = ((double)(j + TextureFX.tileWidthTerrain) - block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j + TextureFX.tileWidthTerrain) - block.maxX * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)(k + TextureFX.tileWidthTerrain) - block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)(k + TextureFX.tileWidthTerrain) - block.maxZ * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d7 = d4;
            d8 = d3;
            d9 = d5;
            d10 = d6;
        }
        double d11 = x + block.minX;
        double d12 = x + block.maxX;
        double d13 = y + block.maxY;
        double d14 = z + block.minZ;
        double d15 = z + block.maxZ;
        if (this.enableAO) {
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
        } else {
            tessellator.addVertexWithUV(d12, d13, d15, d4, d6);
            tessellator.addVertexWithUV(d12, d13, d14, d7, d9);
            tessellator.addVertexWithUV(d11, d13, d14, d3, d5);
            tessellator.addVertexWithUV(d11, d13, d15, d8, d10);
        }
    }

    public void renderNorthFace(Tessellator tessellator, Block block, double x, double y, double z, int tex) {
        if (this.overrideBlockTexture >= 0) {
            tex = this.overrideBlockTexture;
        }
        if (tex < 0) {
            return;
        }
        int j = tex % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k = tex / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d3 = ((double)j + block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d4 = ((double)j + block.maxX * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d5 = ((double)(k + TextureFX.tileWidthTerrain) - block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((double)(k + TextureFX.tileWidthTerrain) - block.minY * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (block.minX < 0.0 || block.maxX > 1.0) {
            d3 = ((float)j + 0.0f) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((float)j + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            d5 = ((float)k + 0.0f) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((float)k + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        }
        double d8 = d4;
        double d9 = d3;
        double d10 = d5;
        double d11 = d6;
        if (this.uvRotateEast == 2) {
            d3 = ((double)j + block.minY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)(k + TextureFX.tileWidthTerrain) - block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)j + block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)(k + TextureFX.tileWidthTerrain) - block.maxX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
            d8 = d3;
            d9 = d4;
            d5 = d6;
            d6 = d10;
        } else if (this.uvRotateEast == 1) {
            d3 = ((double)(j + TextureFX.tileWidthTerrain) - block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)k + block.maxX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j + TextureFX.tileWidthTerrain) - block.minY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)k + block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
            d3 = d8;
            d4 = d9;
            d10 = d6;
            d11 = d5;
        } else if (this.uvRotateEast == 3) {
            d3 = ((double)(j + TextureFX.tileWidthTerrain) - block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j + TextureFX.tileWidthTerrain) - block.maxX * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)k + block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)k + block.minY * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
        }
        double d12 = x + block.minX;
        double d13 = x + block.maxX;
        double d14 = y + block.minY;
        double d15 = y + block.maxY;
        double d16 = z + block.minZ;
        if (this.enableAO) {
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d12, d15, d16, d8, d10);
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d13, d15, d16, d3, d5);
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d13, d14, d16, d9, d11);
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d12, d14, d16, d4, d6);
        } else {
            tessellator.addVertexWithUV(d12, d15, d16, d8, d10);
            tessellator.addVertexWithUV(d13, d15, d16, d3, d5);
            tessellator.addVertexWithUV(d13, d14, d16, d9, d11);
            tessellator.addVertexWithUV(d12, d14, d16, d4, d6);
        }
    }

    public void renderSouthFace(Tessellator tessellator, Block block, double x, double y, double z, int tex) {
        if (this.overrideBlockTexture >= 0) {
            tex = this.overrideBlockTexture;
        }
        if (tex < 0) {
            return;
        }
        int j = tex % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k = tex / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d3 = ((double)j + block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d4 = ((double)j + block.maxX * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d5 = ((double)(k + TextureFX.tileWidthTerrain) - block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((double)(k + TextureFX.tileWidthTerrain) - block.minY * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (block.minX < 0.0 || block.maxX > 1.0) {
            d3 = ((float)j + 0.0f) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((float)j + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            d5 = ((float)k + 0.0f) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((float)k + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        }
        double d8 = d4;
        double d9 = d3;
        double d10 = d5;
        double d11 = d6;
        if (this.uvRotateWest == 1) {
            d3 = ((double)j + block.minY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)(k + TextureFX.tileWidthTerrain) - block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)j + block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)(k + TextureFX.tileWidthTerrain) - block.maxX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
            d8 = d3;
            d9 = d4;
            d5 = d6;
            d6 = d10;
        } else if (this.uvRotateWest == 2) {
            d3 = ((double)(j + TextureFX.tileWidthTerrain) - block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)k + block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j + TextureFX.tileWidthTerrain) - block.minY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)k + block.maxX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
            d3 = d8;
            d4 = d9;
            d10 = d6;
            d11 = d5;
        } else if (this.uvRotateWest == 3) {
            d3 = ((double)(j + TextureFX.tileWidthTerrain) - block.minX * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j + TextureFX.tileWidthTerrain) - block.maxX * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)k + block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)k + block.minY * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
        }
        double d12 = x + block.minX;
        double d13 = x + block.maxX;
        double d14 = y + block.minY;
        double d15 = y + block.maxY;
        double d16 = z + block.maxZ;
        if (this.enableAO) {
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d12, d15, d16, d3, d5);
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d12, d14, d16, d9, d11);
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d13, d14, d16, d4, d6);
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d13, d15, d16, d8, d10);
        } else {
            tessellator.addVertexWithUV(d12, d15, d16, d3, d5);
            tessellator.addVertexWithUV(d12, d14, d16, d9, d11);
            tessellator.addVertexWithUV(d13, d14, d16, d4, d6);
            tessellator.addVertexWithUV(d13, d15, d16, d8, d10);
        }
    }

    public void renderWestFace(Tessellator tessellator, Block block, double x, double y, double z, int tex) {
        if (this.overrideBlockTexture >= 0) {
            tex = this.overrideBlockTexture;
        }
        if (tex < 0) {
            return;
        }
        int j = tex % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k = tex / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d3 = ((double)j + block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d4 = ((double)j + block.maxZ * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d5 = ((double)(k + TextureFX.tileWidthTerrain) - block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((double)(k + TextureFX.tileWidthTerrain) - block.minY * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        if (this.flipTexture) {
            double d7 = d3;
            d3 = d4;
            d4 = d7;
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            d3 = ((float)j + 0.0f) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((float)j + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            d5 = ((float)k + 0.0f) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((float)k + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        }
        double d8 = d4;
        double d9 = d3;
        double d10 = d5;
        double d11 = d6;
        if (this.uvRotateNorth == 1) {
            d3 = ((double)j + block.minY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)(k + TextureFX.tileWidthTerrain) - block.maxZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)j + block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)(k + TextureFX.tileWidthTerrain) - block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
            d8 = d3;
            d9 = d4;
            d5 = d6;
            d6 = d10;
        } else if (this.uvRotateNorth == 2) {
            d3 = ((double)(j + TextureFX.tileWidthTerrain) - block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)k + block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j + TextureFX.tileWidthTerrain) - block.minY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)k + block.maxZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
            d3 = d8;
            d4 = d9;
            d10 = d6;
            d11 = d5;
        } else if (this.uvRotateNorth == 3) {
            d3 = ((double)(j + TextureFX.tileWidthTerrain) - block.minZ * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = ((double)(j + TextureFX.tileWidthTerrain) - block.maxZ * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d5 = ((double)k + block.maxY * (double)TextureFX.tileWidthTerrain) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((double)k + block.minY * (double)TextureFX.tileWidthTerrain - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d8 = d4;
            d9 = d3;
            d10 = d5;
            d11 = d6;
        }
        double d12 = x + block.minX;
        double d13 = y + block.minY;
        double d14 = y + block.maxY;
        double d15 = z + block.minZ;
        double d16 = z + block.maxZ;
        if (this.enableAO) {
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(d12, d14, d16, d8, d10);
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(d12, d14, d15, d3, d5);
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(d12, d13, d15, d9, d11);
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(d12, d13, d16, d4, d6);
        } else {
            tessellator.addVertexWithUV(d12, d14, d16, d8, d10);
            tessellator.addVertexWithUV(d12, d14, d15, d3, d5);
            tessellator.addVertexWithUV(d12, d13, d15, d9, d11);
            tessellator.addVertexWithUV(d12, d13, d16, d4, d6);
        }
    }

    public void renderEastFace(Tessellator tessellator, Block block, double x, double y, double z, int tex) {
        if (this.overrideBlockTexture >= 0) {
            tex = this.overrideBlockTexture;
        }
        if (tex < 0) {
            return;
        }
        double atlasWidth = TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES;
        int texX = tex % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int texY = tex / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double uMin = ((double)texX + block.minZ * (double)TextureFX.tileWidthTerrain) / atlasWidth;
        double uMax = ((double)texX + block.maxZ * (double)TextureFX.tileWidthTerrain - 0.01) / atlasWidth;
        double vMin = ((double)(texY + TextureFX.tileWidthTerrain) - block.maxY * (double)TextureFX.tileWidthTerrain) / atlasWidth;
        double vMax = ((double)(texY + TextureFX.tileWidthTerrain) - block.minY * (double)TextureFX.tileWidthTerrain - 0.01) / atlasWidth;
        if (this.flipTexture) {
            double _uMin = uMin;
            uMin = uMax;
            uMax = _uMin;
        }
        if (block.minZ < 0.0 || block.maxZ > 1.0) {
            uMin = (double)((float)texX + 0.0f) / atlasWidth;
            uMax = (double)((float)texX + ((float)TextureFX.tileWidthTerrain - 0.01f)) / atlasWidth;
        }
        if (block.minY < 0.0 || block.maxY > 1.0) {
            vMin = (double)((float)texY + 0.0f) / atlasWidth;
            vMax = (double)((float)texY + ((float)TextureFX.tileWidthTerrain - 0.01f)) / atlasWidth;
        }
        double uMax2 = uMax;
        double uMin2 = uMin;
        double vMin2 = vMin;
        double vMax2 = vMax;
        if (this.uvRotateSouth == 2) {
            uMin = ((double)texX + block.minY * (double)TextureFX.tileWidthTerrain) / atlasWidth;
            vMin = ((double)(texY + TextureFX.tileWidthTerrain) - block.minZ * (double)TextureFX.tileWidthTerrain) / atlasWidth;
            uMax = ((double)texX + block.maxY * (double)TextureFX.tileWidthTerrain) / atlasWidth;
            vMax = ((double)(texY + TextureFX.tileWidthTerrain) - block.maxZ * (double)TextureFX.tileWidthTerrain) / atlasWidth;
            vMin2 = vMin;
            vMax2 = vMax;
            uMax2 = uMin;
            uMin2 = uMax;
            vMin = vMax;
            vMax = vMin2;
        } else if (this.uvRotateSouth == 1) {
            uMin = ((double)(texX + TextureFX.tileWidthTerrain) - block.maxY * (double)TextureFX.tileWidthTerrain) / atlasWidth;
            vMin = ((double)texY + block.maxZ * (double)TextureFX.tileWidthTerrain) / atlasWidth;
            uMax = ((double)(texX + TextureFX.tileWidthTerrain) - block.minY * (double)TextureFX.tileWidthTerrain) / atlasWidth;
            vMax = ((double)texY + block.minZ * (double)TextureFX.tileWidthTerrain) / atlasWidth;
            uMax2 = uMax;
            uMin2 = uMin;
            uMin = uMax2;
            uMax = uMin2;
            vMin2 = vMax;
            vMax2 = vMin;
        } else if (this.uvRotateSouth == 3) {
            uMin = ((double)(texX + TextureFX.tileWidthTerrain) - block.minZ * (double)TextureFX.tileWidthTerrain) / atlasWidth;
            uMax = ((double)(texX + TextureFX.tileWidthTerrain) - block.maxZ * (double)TextureFX.tileWidthTerrain - 0.01) / atlasWidth;
            vMin = ((double)texY + block.maxY * (double)TextureFX.tileWidthTerrain) / atlasWidth;
            vMax = ((double)texY + block.minY * (double)TextureFX.tileWidthTerrain - 0.01) / atlasWidth;
            uMax2 = uMax;
            uMin2 = uMin;
            vMin2 = vMin;
            vMax2 = vMax;
        }
        double xMax = x + block.maxX;
        double yMin = y + block.minY;
        double yMax = y + block.maxY;
        double zMin = z + block.minZ;
        double zMax = z + block.maxZ;
        if (this.enableAO) {
            tessellator.setColorOpaque_F(this.colorRedTopLeft, this.colorGreenTopLeft, this.colorBlueTopLeft);
            tessellator.addVertexWithUV(xMax, yMin, zMax, uMin2, vMax2);
            tessellator.setColorOpaque_F(this.colorRedBottomLeft, this.colorGreenBottomLeft, this.colorBlueBottomLeft);
            tessellator.addVertexWithUV(xMax, yMin, zMin, uMax, vMax);
            tessellator.setColorOpaque_F(this.colorRedBottomRight, this.colorGreenBottomRight, this.colorBlueBottomRight);
            tessellator.addVertexWithUV(xMax, yMax, zMin, uMax2, vMin2);
            tessellator.setColorOpaque_F(this.colorRedTopRight, this.colorGreenTopRight, this.colorBlueTopRight);
            tessellator.addVertexWithUV(xMax, yMax, zMax, uMin, vMin);
        } else {
            tessellator.addVertexWithUV(xMax, yMin, zMax, uMin2, vMax2);
            tessellator.addVertexWithUV(xMax, yMin, zMin, uMax, vMax);
            tessellator.addVertexWithUV(xMax, yMax, zMin, uMax2, vMin2);
            tessellator.addVertexWithUV(xMax, yMax, zMax, uMin, vMin);
        }
    }

    public void renderBlockAsItem(Tessellator tessellator, BlockModel<Block> blockModel, Block block, float var2) {
        blockModel.setBlockBoundsForItemRender();
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float var5 = 0.5f;
        float var6 = 1.0f;
        float var7 = 0.8f;
        float var8 = 0.6f;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(var6, var6, var6, var2);
        this.renderBottomFace(tessellator, block, 0.0, 0.0, 0.0, blockModel.getBlockTextureFromSideAndMetadata(Side.BOTTOM, 0));
        tessellator.setColorRGBA_F(var5, var5, var5, var2);
        this.renderTopFace(tessellator, block, 0.0, 0.0, 0.0, blockModel.getBlockTextureFromSideAndMetadata(Side.TOP, 0));
        tessellator.setColorRGBA_F(var7, var7, var7, var2);
        this.renderNorthFace(tessellator, block, 0.0, 0.0, 0.0, blockModel.getBlockTextureFromSideAndMetadata(Side.NORTH, 0));
        this.renderSouthFace(tessellator, block, 0.0, 0.0, 0.0, blockModel.getBlockTextureFromSideAndMetadata(Side.SOUTH, 0));
        tessellator.setColorRGBA_F(var8, var8, var8, var2);
        this.renderWestFace(tessellator, block, 0.0, 0.0, 0.0, blockModel.getBlockTextureFromSideAndMetadata(Side.WEST, 0));
        this.renderEastFace(tessellator, block, 0.0, 0.0, 0.0, blockModel.getBlockTextureFromSideAndMetadata(Side.EAST, 0));
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    static float[] rotateAroundPoint(float px, float py, float pz, float pitch, float roll, float yaw) {
        float cosa = MathHelper.cos(yaw);
        float sina = MathHelper.sin(yaw);
        float cosb = MathHelper.cos(pitch);
        float sinb = MathHelper.sin(pitch);
        float cosc = MathHelper.cos(roll);
        float sinc = MathHelper.sin(roll);
        float Axx = cosa * cosb;
        float Axy = cosa * sinb * sinc - sina * cosc;
        float Axz = cosa * sinb * cosc + sina * sinc;
        float Ayx = sina * cosb;
        float Ayy = sina * sinb * sinc + cosa * cosc;
        float Ayz = sina * sinb * cosc - cosa * sinc;
        float Azx = -sinb;
        float Azy = cosb * sinc;
        float Azz = cosb * cosc;
        float[] result = new float[]{Axx * px + Axy * py + Axz * pz, Ayx * px + Ayy * py + Ayz * pz, Azx * px + Azy * py + Azz * pz};
        return result;
    }
}

