/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class BlockModelAlgae<T extends Block>
extends BlockModelStandard<T> {
    public BlockModelAlgae(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelAlgae.renderBlocks.world, x, y, z);
        float brightness = Math.min(this.getBlockBrightness(BlockModelAlgae.renderBlocks.world, x, y - 1, z), this.getBlockBrightness(BlockModelAlgae.renderBlocks.world, x, y, z));
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getWorldColor(BlockModelAlgae.renderBlocks.world, x, y, z);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        tessellator.setColorOpaque_F(red * brightness, green * brightness, blue * brightness);
        int tex = this.getBlockTextureFromSideAndMetadata(Side.TOP, BlockModelAlgae.renderBlocks.world.getBlockMetadata(x, y, z));
        this.renderTopFace(tessellator, this.block, x, (double)y - 0.1125, z, tex);
        this.renderBottomFace(tessellator, this.block, x, (double)y + 0.0125, z, tex);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side) {
        if (side == 1) {
            return true;
        }
        return super.shouldSideBeRendered(blockAccess, x, y, z, side);
    }
}

