/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockRotatable;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;

public class BlockModelAxisAligned<T extends Block>
extends BlockModelStandard<T> {
    public BlockModelAxisAligned(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelAxisAligned.renderBlocks.world, x, y, z);
        int l = BlockModelAxisAligned.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        int i1 = BlockRotatable.getOrientation(l);
        switch (i1) {
            case 0: {
                BlockModelAxisAligned.renderBlocks.uvRotateEast = 0;
                BlockModelAxisAligned.renderBlocks.uvRotateWest = 0;
                BlockModelAxisAligned.renderBlocks.uvRotateSouth = 0;
                BlockModelAxisAligned.renderBlocks.uvRotateNorth = 0;
                break;
            }
            case 1: {
                BlockModelAxisAligned.renderBlocks.uvRotateSouth = 1;
                BlockModelAxisAligned.renderBlocks.uvRotateNorth = 1;
                break;
            }
            case 2: {
                BlockModelAxisAligned.renderBlocks.uvRotateEast = 1;
                BlockModelAxisAligned.renderBlocks.uvRotateWest = 1;
                BlockModelAxisAligned.renderBlocks.uvRotateTop = 1;
                BlockModelAxisAligned.renderBlocks.uvRotateBottom = 1;
            }
        }
        this.renderStandardBlock(tessellator, this.block, x, y, z);
        this.resetRenderBlocks();
        return true;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (6 * (data & 3) + side.getId() >= Sides.orientationLookUpXYZAligned.length) {
            return 0;
        }
        return this.atlasIndices[Sides.orientationLookUpXYZAligned[6 * (data & 3) + side.getId()]];
    }
}

