/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelLeaves;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.block.Block;
import org.lwjgl.opengl.GL11;

public class BlockModelCacaoLeaves<T extends Block>
extends BlockModelLeaves<T> {
    public BlockModelCacaoLeaves(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        super.render(tessellator, x, y, z);
        int growthRate = (BlockModelCacaoLeaves.renderBlocks.blockAccess.getBlockMetadata(x, y, z) & 0xF0) >> 4;
        float brightness = this.getBlockBrightness(BlockModelCacaoLeaves.renderBlocks.world, x, y, z);
        float cNorthSouth = 0.8f;
        float cEastWest = 0.6f;
        if (growthRate > 0) {
            BlockModelCacaoLeaves.renderBlocks.overrideBlockTexture = growthRate >= 4 ? BlockModelCacaoLeaves.texCoordToIndex(4, 17) : BlockModelCacaoLeaves.texCoordToIndex(2 + growthRate - 1, 18);
            tessellator.setColorOpaque_F(0.8f * brightness, 0.8f * brightness, 0.8f * brightness);
            this.renderNorthFace(tessellator, this.block, x, y, z, BlockModelCacaoLeaves.renderBlocks.overrideBlockTexture);
            this.renderSouthFace(tessellator, this.block, x, y, z, BlockModelCacaoLeaves.renderBlocks.overrideBlockTexture);
            tessellator.setColorOpaque_F(0.6f * brightness, 0.6f * brightness, 0.6f * brightness);
            this.renderEastFace(tessellator, this.block, x, y, z, BlockModelCacaoLeaves.renderBlocks.overrideBlockTexture);
            this.renderWestFace(tessellator, this.block, x, y, z, BlockModelCacaoLeaves.renderBlocks.overrideBlockTexture);
            BlockModelCacaoLeaves.renderBlocks.overrideBlockTexture = -1;
        }
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha) {
        super.renderBlockOnInventory(tessellator, metadata, brightness, alpha);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        int cacaoCoord = BlockModelCacaoLeaves.texCoordToIndex(4, 17);
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        this.renderBottomFace(tessellator, this.block, 0.0, 0.0, 0.0, cacaoCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        this.renderTopFace(tessellator, this.block, 0.0, 0.0, 0.0, cacaoCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        this.renderNorthFace(tessellator, this.block, 0.0, 0.0, 0.0, cacaoCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        this.renderSouthFace(tessellator, this.block, 0.0, 0.0, 0.0, cacaoCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        this.renderWestFace(tessellator, this.block, 0.0, 0.0, 0.0, cacaoCoord);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        this.renderEastFace(tessellator, this.block, 0.0, 0.0, 0.0, cacaoCoord);
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }
}

