/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;

public class BlockModelCandle<T extends Block>
extends BlockModelStandard<T> {
    public BlockModelCandle(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelCandle.renderBlocks.world, x, y, z);
        boolean isLit = (BlockModelCandle.renderBlocks.world.getBlockMetadata(x, y, z) & 1) == 0;
        float brightness = isLit ? 1.0f : this.getBlockBrightness(BlockModelCandle.renderBlocks.world, x, y, z);
        float minX = (float)x + 0.5f - 0.09375f;
        float minY = (float)y + 0.0f;
        float minZ = (float)z + 0.5f - 0.09375f;
        float maxX = (float)x + 0.5f + 0.09375f;
        float maxY = (float)y + 0.5f;
        float maxZ = (float)z + 0.5f + 0.09375f;
        float wickMaxY = maxY + 0.375f;
        int texIndex = BlockModelCandle.texCoordToIndex(5, 7);
        if (BlockModelCandle.renderBlocks.overrideBlockTexture >= 0) {
            texIndex = BlockModelCandle.renderBlocks.overrideBlockTexture;
        }
        int texX = texIndex % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int texY = texIndex / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double texU = (float)texX / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double texV = (float)texY / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double onePix = 1.0f / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain);
        double uOffset = isLit ? 0.0 : onePix * 3.0;
        double sideMinU = texU + uOffset;
        double sideMaxU = texU + uOffset + onePix * 3.0;
        double sideMinV = texV + onePix * 3.0;
        double sideMaxV = texV + onePix * 3.0 + onePix * 8.0;
        double topMinU = texU + uOffset;
        double topMaxU = texU + uOffset + onePix * 3.0;
        double topMinV = texV;
        double topMaxV = texV + onePix * 3.0;
        double bottomMinU = texU + onePix * 3.0;
        double bottomMaxU = texU + onePix * 3.0 + onePix * 3.0;
        double bottomMinV = texV;
        double bottomMaxV = texV + onePix * 3.0;
        double wickMinU = texU + onePix * 6.0 + uOffset;
        double wickMaxU = texU + onePix * 6.0 + uOffset + onePix * 3.0;
        double wickMinV = texV;
        double wickMaxV = texV + onePix * 6.0;
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        tessellator.addVertexWithUV(maxX, minY, minZ, sideMinU, sideMaxV);
        tessellator.addVertexWithUV(minX, minY, minZ, sideMaxU, sideMaxV);
        tessellator.addVertexWithUV(minX, maxY, minZ, sideMaxU, sideMinV);
        tessellator.addVertexWithUV(maxX, maxY, minZ, sideMinU, sideMinV);
        tessellator.addVertexWithUV(minX, minY, maxZ, sideMinU, sideMaxV);
        tessellator.addVertexWithUV(maxX, minY, maxZ, sideMaxU, sideMaxV);
        tessellator.addVertexWithUV(maxX, maxY, maxZ, sideMaxU, sideMinV);
        tessellator.addVertexWithUV(minX, maxY, maxZ, sideMinU, sideMinV);
        tessellator.addVertexWithUV(maxX, minY, maxZ, sideMinU, sideMaxV);
        tessellator.addVertexWithUV(maxX, minY, minZ, sideMaxU, sideMaxV);
        tessellator.addVertexWithUV(maxX, maxY, minZ, sideMaxU, sideMinV);
        tessellator.addVertexWithUV(maxX, maxY, maxZ, sideMinU, sideMinV);
        tessellator.addVertexWithUV(minX, minY, minZ, sideMinU, sideMaxV);
        tessellator.addVertexWithUV(minX, minY, maxZ, sideMaxU, sideMaxV);
        tessellator.addVertexWithUV(minX, maxY, maxZ, sideMaxU, sideMinV);
        tessellator.addVertexWithUV(minX, maxY, minZ, sideMinU, sideMinV);
        tessellator.addVertexWithUV(minX, maxY, maxZ, topMinU, topMaxV);
        tessellator.addVertexWithUV(maxX, maxY, maxZ, topMaxU, topMaxV);
        tessellator.addVertexWithUV(maxX, maxY, minZ, topMaxU, topMinV);
        tessellator.addVertexWithUV(minX, maxY, minZ, topMinU, topMinV);
        tessellator.addVertexWithUV(minX, minY, minZ, bottomMinU, bottomMinV);
        tessellator.addVertexWithUV(maxX, minY, minZ, bottomMaxU, bottomMinV);
        tessellator.addVertexWithUV(maxX, minY, maxZ, bottomMaxU, bottomMaxV);
        tessellator.addVertexWithUV(minX, minY, maxZ, bottomMinU, bottomMaxV);
        tessellator.addVertexWithUV(minX, maxY, minZ, wickMinU, wickMaxV);
        tessellator.addVertexWithUV(maxX, maxY, maxZ, wickMaxU, wickMaxV);
        tessellator.addVertexWithUV(maxX, wickMaxY, maxZ, wickMaxU, wickMinV);
        tessellator.addVertexWithUV(minX, wickMaxY, minZ, wickMinU, wickMinV);
        tessellator.addVertexWithUV(minX, wickMaxY, minZ, wickMaxU, wickMinV);
        tessellator.addVertexWithUV(maxX, wickMaxY, maxZ, wickMinU, wickMinV);
        tessellator.addVertexWithUV(maxX, maxY, maxZ, wickMinU, wickMaxV);
        tessellator.addVertexWithUV(minX, maxY, minZ, wickMaxU, wickMaxV);
        tessellator.addVertexWithUV(minX, maxY, maxZ, wickMinU, wickMaxV);
        tessellator.addVertexWithUV(maxX, maxY, minZ, wickMaxU, wickMaxV);
        tessellator.addVertexWithUV(maxX, wickMaxY, minZ, wickMaxU, wickMinV);
        tessellator.addVertexWithUV(minX, wickMaxY, maxZ, wickMinU, wickMinV);
        tessellator.addVertexWithUV(minX, wickMaxY, maxZ, wickMaxU, wickMinV);
        tessellator.addVertexWithUV(maxX, wickMaxY, minZ, wickMinU, wickMinV);
        tessellator.addVertexWithUV(maxX, maxY, minZ, wickMinU, wickMaxV);
        tessellator.addVertexWithUV(minX, maxY, maxZ, wickMaxU, wickMaxV);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }
}

