/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockChest;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;
import net.minecraft.core.world.WorldSource;

public class BlockModelChest<T extends Block>
extends BlockModelStandard<T> {
    public BlockModelChest(Block block) {
        super(block);
    }

    @Override
    public int getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        int meta = blockAccess.getBlockMetadata(x, y, z);
        if (side == Side.TOP || side == Side.BOTTOM) {
            return BlockModelChest.texCoordToIndex(9, 1);
        }
        Side facing = BlockChest.getDirectionFromMeta(meta).getSide();
        BlockChest.Type type = BlockChest.getTypeFromMeta(meta);
        if (type == BlockChest.Type.SINGLE && side == facing) {
            return BlockModelChest.texCoordToIndex(11, 1);
        }
        if (type == BlockChest.Type.LEFT) {
            if (side == facing) {
                return BlockModelChest.texCoordToIndex(9, 2);
            }
            if (side == facing.getOpposite()) {
                return BlockModelChest.texCoordToIndex(10, 3);
            }
        }
        if (type == BlockChest.Type.RIGHT) {
            if (side == facing) {
                return BlockModelChest.texCoordToIndex(10, 2);
            }
            if (side == facing.getOpposite()) {
                return BlockModelChest.texCoordToIndex(9, 3);
            }
        }
        if (side.getAxis() != Axis.Y) {
            return BlockModelChest.texCoordToIndex(10, 1);
        }
        return BlockModelChest.texCoordToIndex(9, 1);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int data) {
        int i = 6 * data + side.getId();
        if (i >= Sides.orientationLookUpHorizontal.length) {
            return this.atlasIndices[0];
        }
        return this.atlasIndices[Sides.orientationLookUpHorizontal[i]];
    }
}

