/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelChest;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class BlockModelChestPainted<T extends Block>
extends BlockModelChest<T> {
    public BlockModelChestPainted(Block block) {
        super(block);
    }

    @Override
    public int getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        int color = blockAccess.getBlockMetadata(x, y, z) >> 4;
        int texOffset = BlockModelChestPainted.texCoordToIndex(20, 28) - (color % 4 * (Global.TEXTURE_ATLAS_WIDTH_TILES * 3) + color / 4 * 3);
        return super.getBlockTexture(blockAccess, x, y, z, side) + texOffset;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int data) {
        int color = data >> 4;
        int texOffset = BlockModelChestPainted.texCoordToIndex(20, 28) - (color % 4 * (Global.TEXTURE_ATLAS_WIDTH_TILES * 3) + color / 4 * 3);
        return super.getBlockTextureFromSideAndMetadata(side, data & 0xF) + texOffset;
    }
}

