/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;

public class BlockModelCropsPumpkin<T extends Block>
extends BlockModelStandard<T> {
    public static final int[] GROWTH_STAGE_TEXTURES_TOP = new int[]{BlockModelCropsPumpkin.texCoordToIndex(16, 15), BlockModelCropsPumpkin.texCoordToIndex(16, 14), BlockModelCropsPumpkin.texCoordToIndex(16, 13), BlockModelCropsPumpkin.texCoordToIndex(16, 12)};
    public static final int[] GROWTH_STAGE_TEXTURES_SIDE = new int[]{BlockModelCropsPumpkin.texCoordToIndex(17, 15), BlockModelCropsPumpkin.texCoordToIndex(17, 14), BlockModelCropsPumpkin.texCoordToIndex(17, 13), BlockModelCropsPumpkin.texCoordToIndex(17, 12)};
    public static final int LEAF_TEXTURE = BlockModelCropsPumpkin.texCoordToIndex(16, 16);

    public BlockModelCropsPumpkin(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelCropsPumpkin.renderBlocks.world, x, y, z);
        float brightness = this.getBlockBrightness(BlockModelCropsPumpkin.renderBlocks.blockAccess, x, y, z);
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        int meta = BlockModelCropsPumpkin.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        int leafTexture = LEAF_TEXTURE;
        if (BlockModelCropsPumpkin.renderBlocks.overrideBlockTexture >= 0) {
            leafTexture = BlockModelCropsPumpkin.renderBlocks.overrideBlockTexture;
        }
        int xTex = leafTexture % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int yTex = leafTexture / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double uMin = (float)xTex / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double uMax = ((float)xTex + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double vMin = (float)yTex / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double vMax = ((float)yTex + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double xMin = (double)x + 0.5 - 0.25;
        double xMax = (double)x + 0.5 + 0.25;
        double yMin = (double)y + 0.0;
        double yMax = (double)y + 0.1875;
        double zMin = (double)z + 0.5 - 0.5;
        double zMax = (double)z + 0.5 + 0.5;
        double extra = 0.625;
        tessellator.addVertexWithUV(xMin - extra, yMax, zMax, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yMin, zMax, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yMin, zMin, uMax, vMax);
        tessellator.addVertexWithUV(xMin - extra, yMax, zMin, uMax, vMin);
        tessellator.addVertexWithUV(xMin - extra, yMax, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yMin, zMin, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yMin, zMax, uMax, vMax);
        tessellator.addVertexWithUV(xMin - extra, yMax, zMax, uMax, vMin);
        tessellator.addVertexWithUV(xMax + extra, yMax, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMin, yMin, zMin, uMin, vMax);
        tessellator.addVertexWithUV(xMin, yMin, zMax, uMax, vMax);
        tessellator.addVertexWithUV(xMax + extra, yMax, zMax, uMax, vMin);
        tessellator.addVertexWithUV(xMax + extra, yMax, zMax, uMin, vMin);
        tessellator.addVertexWithUV(xMin, yMin, zMax, uMin, vMax);
        tessellator.addVertexWithUV(xMin, yMin, zMin, uMax, vMax);
        tessellator.addVertexWithUV(xMax + extra, yMax, zMin, uMax, vMin);
        if (meta >= 1) {
            this.renderStandardBlock(tessellator, this.block, x, y, z);
        }
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (data < 1 || data > 4) {
            data = 1;
        }
        if (side == Side.TOP || side == Side.BOTTOM) {
            return GROWTH_STAGE_TEXTURES_TOP[data - 1];
        }
        return GROWTH_STAGE_TEXTURES_SIDE[data - 1];
    }
}

