/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;

public class BlockModelCropsWheat<T extends Block>
extends BlockModelStandard<T> {
    public final int[] growthStageTextures = new int[]{BlockModelCropsWheat.texCoordToIndex(8, 5), BlockModelCropsWheat.texCoordToIndex(9, 5), BlockModelCropsWheat.texCoordToIndex(10, 5), BlockModelCropsWheat.texCoordToIndex(11, 5), BlockModelCropsWheat.texCoordToIndex(12, 5), BlockModelCropsWheat.texCoordToIndex(13, 5), BlockModelCropsWheat.texCoordToIndex(14, 5), BlockModelCropsWheat.texCoordToIndex(15, 5)};

    public BlockModelCropsWheat(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelCropsWheat.renderBlocks.world, x, y, z);
        float brightness = this.getBlockBrightness(BlockModelCropsWheat.renderBlocks.blockAccess, x, y, z);
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        int texture = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, BlockModelCropsWheat.renderBlocks.blockAccess.getBlockMetadata(x, y, z));
        if (BlockModelCropsWheat.renderBlocks.overrideBlockTexture >= 0) {
            texture = BlockModelCropsWheat.renderBlocks.overrideBlockTexture;
        }
        int uScaled = texture % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int vScaled = texture / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double uMin = (float)uScaled / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double uMax = ((float)uScaled + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double vMin = (float)vScaled / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double vMax = ((float)vScaled + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double xMin = (double)x + 0.5 - 0.25;
        double xMax = (double)x + 0.5 + 0.25;
        double zMin = (double)z + 0.5 - 0.5;
        double zMax = (double)z + 0.5 + 0.5;
        double yd = (float)y - 0.0625f;
        tessellator.addVertexWithUV(xMin, yd + 1.0, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMin, yd + 0.0, zMin, uMin, vMax);
        tessellator.addVertexWithUV(xMin, yd + 0.0, zMax, uMax, vMax);
        tessellator.addVertexWithUV(xMin, yd + 1.0, zMax, uMax, vMin);
        tessellator.addVertexWithUV(xMin, yd + 1.0, zMax, uMin, vMin);
        tessellator.addVertexWithUV(xMin, yd + 0.0, zMax, uMin, vMax);
        tessellator.addVertexWithUV(xMin, yd + 0.0, zMin, uMax, vMax);
        tessellator.addVertexWithUV(xMin, yd + 1.0, zMin, uMax, vMin);
        tessellator.addVertexWithUV(xMax, yd + 1.0, zMax, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yd + 0.0, zMax, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yd + 0.0, zMin, uMax, vMax);
        tessellator.addVertexWithUV(xMax, yd + 1.0, zMin, uMax, vMin);
        tessellator.addVertexWithUV(xMax, yd + 1.0, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yd + 0.0, zMin, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yd + 0.0, zMax, uMax, vMax);
        tessellator.addVertexWithUV(xMax, yd + 1.0, zMax, uMax, vMin);
        xMin = (double)x + 0.5 - 0.5;
        xMax = (double)x + 0.5 + 0.5;
        zMin = (double)z + 0.5 - 0.25;
        zMax = (double)z + 0.5 + 0.25;
        tessellator.addVertexWithUV(xMin, yd + 1.0, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMin, yd + 0.0, zMin, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yd + 0.0, zMin, uMax, vMax);
        tessellator.addVertexWithUV(xMax, yd + 1.0, zMin, uMax, vMin);
        tessellator.addVertexWithUV(xMax, yd + 1.0, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yd + 0.0, zMin, uMin, vMax);
        tessellator.addVertexWithUV(xMin, yd + 0.0, zMin, uMax, vMax);
        tessellator.addVertexWithUV(xMin, yd + 1.0, zMin, uMax, vMin);
        tessellator.addVertexWithUV(xMax, yd + 1.0, zMax, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yd + 0.0, zMax, uMin, vMax);
        tessellator.addVertexWithUV(xMin, yd + 0.0, zMax, uMax, vMax);
        tessellator.addVertexWithUV(xMin, yd + 1.0, zMax, uMax, vMin);
        tessellator.addVertexWithUV(xMin, yd + 1.0, zMax, uMin, vMin);
        tessellator.addVertexWithUV(xMin, yd + 0.0, zMax, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yd + 0.0, zMax, uMax, vMax);
        tessellator.addVertexWithUV(xMax, yd + 1.0, zMax, uMax, vMin);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (data < 0 || data > 7) {
            data = 7;
        }
        return this.growthStageTextures[data];
    }
}

