/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockDoor;
import net.minecraft.core.util.helper.Side;

public class BlockModelDoor<T extends BlockDoor>
extends BlockModelStandard<T> {
    public BlockModelDoor(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        ((BlockDoor)this.block).setBlockBoundsBasedOnState(BlockModelDoor.renderBlocks.world, x, y, z);
        float f = 0.5f;
        float f1 = 1.0f;
        float f2 = 0.8f;
        float f3 = 0.6f;
        float f4 = this.getBlockBrightness(BlockModelDoor.renderBlocks.blockAccess, x, y, z);
        float f5 = this.getBlockBrightness(BlockModelDoor.renderBlocks.blockAccess, x, y - 1, z);
        boolean aboveIsDoor = BlockModelDoor.renderBlocks.world.getBlock(x, y + 1, z) instanceof BlockDoor;
        boolean belowIsDoor = BlockModelDoor.renderBlocks.world.getBlock(x, y - 1, z) instanceof BlockDoor;
        if (((BlockDoor)this.block).minY > 0.0) {
            f5 = f4;
        }
        if (Block.lightEmission[((BlockDoor)this.block).id] > 0) {
            f5 = 1.0f;
        }
        tessellator.setColorOpaque_F(f * f5, f * f5, f * f5);
        if (!belowIsDoor) {
            this.renderBottomFace(tessellator, this.block, x, y, z, this.getBlockTexture(BlockModelDoor.renderBlocks.blockAccess, x, y, z, Side.BOTTOM));
        }
        f5 = this.getBlockBrightness(BlockModelDoor.renderBlocks.blockAccess, x, y + 1, z);
        if (((BlockDoor)this.block).maxY < 1.0) {
            f5 = f4;
        }
        if (Block.lightEmission[((BlockDoor)this.block).id] > 0) {
            f5 = 1.0f;
        }
        tessellator.setColorOpaque_F(f1 * f5, f1 * f5, f1 * f5);
        if (!aboveIsDoor) {
            this.renderTopFace(tessellator, this.block, x, y, z, this.getBlockTexture(BlockModelDoor.renderBlocks.blockAccess, x, y, z, Side.TOP));
        }
        f5 = this.getBlockBrightness(BlockModelDoor.renderBlocks.blockAccess, x, y, z - 1);
        if (((BlockDoor)this.block).minZ > 0.0) {
            f5 = f4;
        }
        if (Block.lightEmission[((BlockDoor)this.block).id] > 0) {
            f5 = 1.0f;
        }
        tessellator.setColorOpaque_F(f2 * f5, f2 * f5, f2 * f5);
        int l = this.getBlockTexture(BlockModelDoor.renderBlocks.blockAccess, x, y, z, Side.NORTH);
        if (l < 0) {
            BlockModelDoor.renderBlocks.flipTexture = true;
            l = -l;
        }
        this.renderNorthFace(tessellator, this.block, x, y, z, l);
        BlockModelDoor.renderBlocks.flipTexture = false;
        f5 = this.getBlockBrightness(BlockModelDoor.renderBlocks.blockAccess, x, y, z + 1);
        if (((BlockDoor)this.block).maxZ < 1.0) {
            f5 = f4;
        }
        if (Block.lightEmission[((BlockDoor)this.block).id] > 0) {
            f5 = 1.0f;
        }
        tessellator.setColorOpaque_F(f2 * f5, f2 * f5, f2 * f5);
        l = this.getBlockTexture(BlockModelDoor.renderBlocks.blockAccess, x, y, z, Side.SOUTH);
        if (l < 0) {
            BlockModelDoor.renderBlocks.flipTexture = true;
            l = -l;
        }
        this.renderSouthFace(tessellator, this.block, x, y, z, l);
        BlockModelDoor.renderBlocks.flipTexture = false;
        f5 = this.getBlockBrightness(BlockModelDoor.renderBlocks.blockAccess, x - 1, y, z);
        if (((BlockDoor)this.block).minX > 0.0) {
            f5 = f4;
        }
        if (Block.lightEmission[((BlockDoor)this.block).id] > 0) {
            f5 = 1.0f;
        }
        tessellator.setColorOpaque_F(f3 * f5, f3 * f5, f3 * f5);
        l = this.getBlockTexture(BlockModelDoor.renderBlocks.blockAccess, x, y, z, Side.WEST);
        if (l < 0) {
            BlockModelDoor.renderBlocks.flipTexture = true;
            l = -l;
        }
        this.renderWestFace(tessellator, this.block, x, y, z, l);
        BlockModelDoor.renderBlocks.flipTexture = false;
        f5 = this.getBlockBrightness(BlockModelDoor.renderBlocks.blockAccess, x + 1, y, z);
        if (((BlockDoor)this.block).maxX < 1.0) {
            f5 = f4;
        }
        if (Block.lightEmission[((BlockDoor)this.block).id] > 0) {
            f5 = 1.0f;
        }
        tessellator.setColorOpaque_F(f3 * f5, f3 * f5, f3 * f5);
        l = this.getBlockTexture(BlockModelDoor.renderBlocks.blockAccess, x, y, z, Side.EAST);
        if (l < 0) {
            BlockModelDoor.renderBlocks.flipTexture = true;
            l = -l;
        }
        this.renderEastFace(tessellator, this.block, x, y, z, l);
        BlockModelDoor.renderBlocks.flipTexture = false;
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int data) {
        int sideId = side.getId();
        if (side == Side.TOP || side == Side.BOTTOM) {
            return this.atlasIndices[sideId];
        }
        int k = ((BlockDoor)this.block).getState(data);
        if ((k == 0 || k == 2) ^ sideId <= 3) {
            return this.atlasIndices[sideId];
        }
        int l = k / 2 + (sideId & 1 ^ k);
        int i1 = this.atlasIndices[sideId];
        if (((l += (data & 4) / 4) & 1) != 0) {
            i1 = -i1;
        }
        return i1;
    }
}

