/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.client.render.tessalator.TessellatorStandard;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockFenceThin;
import net.minecraft.core.util.helper.Direction;
import org.lwjgl.opengl.GL11;

public class BlockModelFenceThin<T extends BlockFenceThin>
extends BlockModelStandard<T> {
    private final int texIndex;
    private final int bottomTexIndex;
    private final int topTexIndex;
    private final int columnTexIndex;

    public BlockModelFenceThin(Block block, int texIndex, int bottomTexIndex, int topTexIndex, int columnTexIndex) {
        super(block);
        this.texIndex = texIndex;
        this.bottomTexIndex = bottomTexIndex;
        this.topTexIndex = topTexIndex;
        this.columnTexIndex = columnTexIndex;
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        float maxZ;
        float maxY;
        float maxX;
        float minZ;
        float minY;
        double sidesMaxU;
        double sidesMaxV;
        double sidesMinV;
        boolean connectDownWest;
        ((BlockFenceThin)this.block).setBlockBoundsBasedOnState(BlockModelFenceThin.renderBlocks.world, x, y, z);
        float brightness = this.getBlockBrightness(BlockModelFenceThin.renderBlocks.world, x, y, z);
        float cBottom = 0.5f;
        float cTop = 1.0f;
        float cNorthSouth = 0.8f;
        float cEastWest = 0.6f;
        boolean connectNorth = ((BlockFenceThin)this.block).canConnectTo(BlockModelFenceThin.renderBlocks.world, x + Direction.NORTH.getOffsetX(), y + Direction.NORTH.getOffsetY(), z + Direction.NORTH.getOffsetZ());
        boolean connectSouth = ((BlockFenceThin)this.block).canConnectTo(BlockModelFenceThin.renderBlocks.world, x + Direction.SOUTH.getOffsetX(), y + Direction.SOUTH.getOffsetY(), z + Direction.SOUTH.getOffsetZ());
        boolean connectEast = ((BlockFenceThin)this.block).canConnectTo(BlockModelFenceThin.renderBlocks.world, x + Direction.EAST.getOffsetX(), y + Direction.EAST.getOffsetY(), z + Direction.EAST.getOffsetZ());
        boolean connectWest = ((BlockFenceThin)this.block).canConnectTo(BlockModelFenceThin.renderBlocks.world, x + Direction.WEST.getOffsetX(), y + Direction.WEST.getOffsetY(), z + Direction.WEST.getOffsetZ());
        boolean lineNorthSouth = connectNorth && connectSouth;
        boolean lineEastWest = connectEast && connectWest;
        double onePix = 1.0f / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * 16);
        TessellatorStandard t = TessellatorStandard.instance;
        int fenceNormalTexX = this.texIndex % Global.TEXTURE_ATLAS_WIDTH_TILES * 16;
        int fenceNormalTexY = this.texIndex / Global.TEXTURE_ATLAS_WIDTH_TILES * 16;
        double fenceNormalMinU = (float)fenceNormalTexX / (float)(16 * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double fenceNormalMinV = (float)fenceNormalTexY / (float)(16 * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double fenceNormalMaxU = fenceNormalMinU + onePix * 16.0;
        double fenceNormalMaxV = fenceNormalMinV + onePix * 16.0;
        int fenceTopmostTexX = this.topTexIndex % Global.TEXTURE_ATLAS_WIDTH_TILES * 16;
        int fenceTopmostTexY = this.topTexIndex / Global.TEXTURE_ATLAS_WIDTH_TILES * 16;
        if (this.topTexIndex == -1) {
            fenceTopmostTexX = fenceNormalTexX;
            fenceTopmostTexY = fenceNormalTexY;
        }
        double fenceTopmostMinU = (float)fenceTopmostTexX / (float)(16 * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double fenceTopmostMinV = (float)fenceTopmostTexY / (float)(16 * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double fenceTopmostMaxU = fenceTopmostMinU + onePix * 16.0;
        double fenceTopmostMaxV = fenceTopmostMinV + onePix * 16.0;
        int fenceBottommostTexX = this.bottomTexIndex % Global.TEXTURE_ATLAS_WIDTH_TILES * 16;
        int fenceBottommostTexY = this.bottomTexIndex / Global.TEXTURE_ATLAS_WIDTH_TILES * 16;
        if (this.bottomTexIndex == -1) {
            fenceBottommostTexX = fenceNormalTexX;
            fenceBottommostTexY = fenceNormalTexY;
        }
        double fenceBottommostMinU = (float)fenceBottommostTexX / (float)(16 * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double fenceBottommostMinV = (float)fenceBottommostTexY / (float)(16 * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double fenceBottommostMaxU = fenceBottommostMinU + onePix * 16.0;
        double fenceBottommostMaxV = fenceBottommostMinV + onePix * 16.0;
        Block blockAbove = BlockModelFenceThin.renderBlocks.world.getBlock(x, y + 1, z);
        boolean connectUpNorth = blockAbove == this.block && ((BlockFenceThin)this.block).canConnectTo(BlockModelFenceThin.renderBlocks.world, x + Direction.NORTH.getOffsetX(), y + Direction.NORTH.getOffsetY() + 1, z + Direction.NORTH.getOffsetZ());
        boolean connectUpSouth = blockAbove == this.block && ((BlockFenceThin)this.block).canConnectTo(BlockModelFenceThin.renderBlocks.world, x + Direction.SOUTH.getOffsetX(), y + Direction.SOUTH.getOffsetY() + 1, z + Direction.SOUTH.getOffsetZ());
        boolean connectUpEast = blockAbove == this.block && ((BlockFenceThin)this.block).canConnectTo(BlockModelFenceThin.renderBlocks.world, x + Direction.EAST.getOffsetX(), y + Direction.EAST.getOffsetY() + 1, z + Direction.EAST.getOffsetZ());
        boolean connectUpWest = blockAbove == this.block && ((BlockFenceThin)this.block).canConnectTo(BlockModelFenceThin.renderBlocks.world, x + Direction.WEST.getOffsetX(), y + Direction.WEST.getOffsetY() + 1, z + Direction.WEST.getOffsetZ());
        Block blockBelow = BlockModelFenceThin.renderBlocks.world.getBlock(x, y - 1, z);
        boolean connectDownNorth = blockBelow == this.block && ((BlockFenceThin)this.block).canConnectTo(BlockModelFenceThin.renderBlocks.world, x + Direction.NORTH.getOffsetX(), y + Direction.NORTH.getOffsetY() - 1, z + Direction.NORTH.getOffsetZ());
        boolean connectDownSouth = blockBelow == this.block && ((BlockFenceThin)this.block).canConnectTo(BlockModelFenceThin.renderBlocks.world, x + Direction.SOUTH.getOffsetX(), y + Direction.SOUTH.getOffsetY() - 1, z + Direction.SOUTH.getOffsetZ());
        boolean connectDownEast = blockBelow == this.block && ((BlockFenceThin)this.block).canConnectTo(BlockModelFenceThin.renderBlocks.world, x + Direction.EAST.getOffsetX(), y + Direction.EAST.getOffsetY() - 1, z + Direction.EAST.getOffsetZ());
        boolean bl = connectDownWest = blockBelow == this.block && ((BlockFenceThin)this.block).canConnectTo(BlockModelFenceThin.renderBlocks.world, x + Direction.WEST.getOffsetX(), y + Direction.WEST.getOffsetY() - 1, z + Direction.WEST.getOffsetZ());
        if (((BlockFenceThin)this.block).shouldDrawColumn(BlockModelFenceThin.renderBlocks.world, x, y, z)) {
            int sidesTexX = this.columnTexIndex % Global.TEXTURE_ATLAS_WIDTH_TILES * 16;
            int sidesTexY = this.columnTexIndex / Global.TEXTURE_ATLAS_WIDTH_TILES * 16;
            double sidesMinU = (float)sidesTexX / (float)(16 * Global.TEXTURE_ATLAS_WIDTH_TILES);
            double sidesMinV2 = (float)sidesTexY / (float)(16 * Global.TEXTURE_ATLAS_WIDTH_TILES);
            double sidesMaxU2 = sidesMinU + onePix * 2.0;
            double sidesMaxV2 = sidesMinV2 + onePix * 16.0;
            float minX = (float)x + 0.4375f;
            float minY2 = y;
            float minZ2 = (float)z + 0.4375f;
            float maxX2 = (float)x + 0.5625f;
            float maxY2 = (float)y + 1.0f;
            float maxZ2 = (float)z + 0.5625f;
            t.setColorOpaque_F(cNorthSouth * brightness, cNorthSouth * brightness, cNorthSouth * brightness);
            t.addVertexWithUV(maxX2, minY2, minZ2, sidesMinU, sidesMaxV2);
            t.addVertexWithUV(minX, minY2, minZ2, sidesMaxU2, sidesMaxV2);
            t.addVertexWithUV(minX, maxY2, minZ2, sidesMaxU2, sidesMinV2);
            t.addVertexWithUV(maxX2, maxY2, minZ2, sidesMinU, sidesMinV2);
            t.addVertexWithUV(minX, minY2, maxZ2, sidesMinU, sidesMaxV2);
            t.addVertexWithUV(maxX2, minY2, maxZ2, sidesMaxU2, sidesMaxV2);
            t.addVertexWithUV(maxX2, maxY2, maxZ2, sidesMaxU2, sidesMinV2);
            t.addVertexWithUV(minX, maxY2, maxZ2, sidesMinU, sidesMinV2);
            t.setColorOpaque_F(cEastWest * brightness, cEastWest * brightness, cEastWest * brightness);
            t.addVertexWithUV(maxX2, minY2, maxZ2, sidesMinU, sidesMaxV2);
            t.addVertexWithUV(maxX2, minY2, minZ2, sidesMaxU2, sidesMaxV2);
            t.addVertexWithUV(maxX2, maxY2, minZ2, sidesMaxU2, sidesMinV2);
            t.addVertexWithUV(maxX2, maxY2, maxZ2, sidesMinU, sidesMinV2);
            t.addVertexWithUV(minX, minY2, minZ2, sidesMinU, sidesMaxV2);
            t.addVertexWithUV(minX, minY2, maxZ2, sidesMaxU2, sidesMaxV2);
            t.addVertexWithUV(minX, maxY2, maxZ2, sidesMaxU2, sidesMinV2);
            t.addVertexWithUV(minX, maxY2, minZ2, sidesMinU, sidesMinV2);
            int topBottomTexX = sidesTexX;
            int topBottomTexY = sidesTexY;
            double topBottomMinU = (float)topBottomTexX / (float)(16 * Global.TEXTURE_ATLAS_WIDTH_TILES);
            double topBottomMinV = (float)topBottomTexY / (float)(16 * Global.TEXTURE_ATLAS_WIDTH_TILES);
            double topBottomMaxU = topBottomMinU + onePix * 2.0;
            double topBottomMaxV = topBottomMinV + onePix * 2.0;
            t.setColorOpaque_F(cTop * brightness, cTop * brightness, cTop * brightness);
            t.addVertexWithUV(minX, maxY2, maxZ2, topBottomMinU, topBottomMaxV);
            t.addVertexWithUV(maxX2, maxY2, maxZ2, topBottomMaxU, topBottomMaxV);
            t.addVertexWithUV(maxX2, maxY2, minZ2, topBottomMaxU, topBottomMinV);
            t.addVertexWithUV(minX, maxY2, minZ2, topBottomMinU, topBottomMinV);
            t.setColorOpaque_F(cBottom * brightness, cBottom * brightness, cBottom * brightness);
            t.addVertexWithUV(minX, minY2, minZ2, topBottomMinU, topBottomMinV);
            t.addVertexWithUV(maxX2, minY2, minZ2, topBottomMaxU, topBottomMinV);
            t.addVertexWithUV(maxX2, minY2, maxZ2, topBottomMaxU, topBottomMaxV);
            t.addVertexWithUV(minX, minY2, maxZ2, topBottomMinU, topBottomMaxV);
        }
        if (connectNorth) {
            double sidesMinU;
            if (this.bottomTexIndex >= 0 && !connectDownNorth) {
                sidesMinU = fenceBottommostMinU;
                sidesMinV = fenceBottommostMinV;
                sidesMaxV = fenceBottommostMaxV;
            } else if (this.topTexIndex >= 0 && !connectUpNorth) {
                sidesMinU = fenceTopmostMinU;
                sidesMinV = fenceTopmostMinV;
                sidesMaxV = fenceTopmostMaxV;
            } else {
                sidesMinU = fenceNormalMinU;
                sidesMinV = fenceNormalMinV;
                sidesMaxV = fenceNormalMaxV;
            }
            sidesMaxU = sidesMinU + onePix * 8.0;
            float minX = (float)x + 0.5f;
            minY = y;
            minZ = z;
            maxX = (float)x + 0.5f;
            maxY = (float)y + 1.0f;
            maxZ = (float)z + 0.5f;
            t.setColorOpaque_F(cEastWest * brightness, cEastWest * brightness, cEastWest * brightness);
            t.addVertexWithUV(maxX, minY, maxZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(maxX, minY, minZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(maxX, maxY, minZ, sidesMaxU, sidesMinV);
            t.addVertexWithUV(maxX, maxY, maxZ, sidesMinU, sidesMinV);
            t.addVertexWithUV(minX, minY, minZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(minX, minY, maxZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(minX, maxY, maxZ, sidesMinU, sidesMinV);
            t.addVertexWithUV(minX, maxY, minZ, sidesMaxU, sidesMinV);
        }
        if (connectSouth) {
            double sidesMinU;
            if (this.bottomTexIndex >= 0 && !connectDownSouth) {
                sidesMinU = fenceBottommostMinU;
                sidesMinV = fenceBottommostMinV;
                sidesMaxV = fenceBottommostMaxV;
            } else if (this.topTexIndex >= 0 && !connectUpSouth) {
                sidesMinU = fenceTopmostMinU;
                sidesMinV = fenceTopmostMinV;
                sidesMaxV = fenceTopmostMaxV;
            } else {
                sidesMinU = fenceNormalMinU;
                sidesMinV = fenceNormalMinV;
                sidesMaxV = fenceNormalMaxV;
            }
            sidesMaxU = (sidesMinU += onePix * 8.0) + onePix * 8.0;
            float minX = (float)x + 0.5f;
            minY = y;
            minZ = (float)z + 0.5f;
            maxX = (float)x + 0.5f;
            maxY = (float)y + 1.0f;
            maxZ = (float)z + 1.0f;
            t.setColorOpaque_F(cEastWest * brightness, cEastWest * brightness, cEastWest * brightness);
            t.addVertexWithUV(maxX, minY, maxZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(maxX, minY, minZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(maxX, maxY, minZ, sidesMaxU, sidesMinV);
            t.addVertexWithUV(maxX, maxY, maxZ, sidesMinU, sidesMinV);
            t.addVertexWithUV(minX, minY, minZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(minX, minY, maxZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(minX, maxY, maxZ, sidesMinU, sidesMinV);
            t.addVertexWithUV(minX, maxY, minZ, sidesMaxU, sidesMinV);
        }
        if (connectWest) {
            double sidesMinU;
            if (this.bottomTexIndex >= 0 && !connectDownWest) {
                sidesMinU = fenceBottommostMinU;
                sidesMinV = fenceBottommostMinV;
                sidesMaxV = fenceBottommostMaxV;
            } else if (this.topTexIndex >= 0 && !connectUpWest) {
                sidesMinU = fenceTopmostMinU;
                sidesMinV = fenceTopmostMinV;
                sidesMaxV = fenceTopmostMaxV;
            } else {
                sidesMinU = fenceNormalMinU;
                sidesMinV = fenceNormalMinV;
                sidesMaxV = fenceNormalMaxV;
            }
            sidesMaxU = sidesMinU + onePix * 8.0;
            float minX = x;
            minY = y;
            minZ = (float)z + 0.5f;
            maxX = (float)x + 0.5f;
            maxY = (float)y + 1.0f;
            maxZ = (float)z + 0.5f;
            t.setColorOpaque_F(cNorthSouth * brightness, cNorthSouth * brightness, cNorthSouth * brightness);
            t.addVertexWithUV(maxX, minY, minZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(minX, minY, minZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(minX, maxY, minZ, sidesMaxU, sidesMinV);
            t.addVertexWithUV(maxX, maxY, minZ, sidesMinU, sidesMinV);
            t.addVertexWithUV(minX, minY, maxZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(maxX, minY, maxZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(maxX, maxY, maxZ, sidesMinU, sidesMinV);
            t.addVertexWithUV(minX, maxY, maxZ, sidesMaxU, sidesMinV);
        }
        if (connectEast) {
            double sidesMinU;
            if (this.bottomTexIndex >= 0 && !connectDownEast) {
                sidesMinU = fenceBottommostMinU;
                sidesMinV = fenceBottommostMinV;
                sidesMaxV = fenceBottommostMaxV;
            } else if (this.topTexIndex >= 0 && !connectUpEast) {
                sidesMinU = fenceTopmostMinU;
                sidesMinV = fenceTopmostMinV;
                sidesMaxV = fenceTopmostMaxV;
            } else {
                sidesMinU = fenceNormalMinU;
                sidesMinV = fenceNormalMinV;
                sidesMaxV = fenceNormalMaxV;
            }
            sidesMaxU = (sidesMinU += onePix * 8.0) + onePix * 8.0;
            float minX = (float)x + 0.5f;
            minY = y;
            minZ = (float)z + 0.5f;
            maxX = (float)x + 1.0f;
            maxY = (float)y + 1.0f;
            maxZ = (float)z + 0.5f;
            t.setColorOpaque_F(cNorthSouth * brightness, cNorthSouth * brightness, cNorthSouth * brightness);
            t.addVertexWithUV(maxX, minY, minZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(minX, minY, minZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(minX, maxY, minZ, sidesMaxU, sidesMinV);
            t.addVertexWithUV(maxX, maxY, minZ, sidesMinU, sidesMinV);
            t.addVertexWithUV(minX, minY, maxZ, sidesMaxU, sidesMaxV);
            t.addVertexWithUV(maxX, minY, maxZ, sidesMinU, sidesMaxV);
            t.addVertexWithUV(maxX, maxY, maxZ, sidesMinU, sidesMinV);
            t.addVertexWithUV(minX, maxY, maxZ, sidesMaxU, sidesMinV);
        }
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha) {
        if (BlockModelFenceThin.renderBlocks.useInventoryTint) {
            int j = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata);
            float f1 = (float)(j >> 16 & 0xFF) / 255.0f;
            float f3 = (float)(j >> 8 & 0xFF) / 255.0f;
            float f5 = (float)(j & 0xFF) / 255.0f;
            GL11.glColor4f((float)(f1 * brightness), (float)(f3 * brightness), (float)(f5 * brightness), (float)alpha);
        }
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        for (int i1 = 0; i1 < 2; ++i1) {
            GL11.glPushMatrix();
            float f4 = 0.0625f;
            ((BlockFenceThin)this.block).setBlockBounds(0.0, 0.0, 0.0, 2.0f * f4, 1.0, f4 * 2.0f);
            GL11.glTranslatef((float)(0.5f - f4), (float)0.0f, (float)0.0f);
            if (i1 == 1) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(1.0f - f4 * 2.0f));
            }
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(tessellator, this.block, 0.0, 0.0, 0.0, this.columnTexIndex);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(tessellator, this.block, 0.0, 0.0, 0.0, this.columnTexIndex);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderNorthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.columnTexIndex);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderSouthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.columnTexIndex);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderWestFace(tessellator, this.block, 0.0, 0.0, 0.0, this.columnTexIndex);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderEastFace(tessellator, this.block, 0.0, 0.0, 0.0, this.columnTexIndex);
            tessellator.draw();
            GL11.glPopMatrix();
        }
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glDisable((int)2884);
        ((BlockFenceThin)this.block).setBlockBounds(0.0, 0.0, 0.0, 0.5, 1.0, 1.0);
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        this.renderEastFace(tessellator, this.block, 0.0, 0.0, 0.0, this.texIndex);
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        ((BlockFenceThin)this.block).setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }
}

