/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockFire;
import net.minecraft.core.util.helper.Side;

public class BlockModelFire<T extends Block>
extends BlockModelStandard<T> {
    public BlockModelFire(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelFire.renderBlocks.world, x, y, z);
        int tex = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, BlockModelFire.renderBlocks.blockAccess.getBlockMetadata(x, y, z));
        if (BlockModelFire.renderBlocks.overrideBlockTexture >= 0) {
            tex = BlockModelFire.renderBlocks.overrideBlockTexture;
        }
        float brightness = renderBlocks.getBlockBrightness(BlockModelFire.renderBlocks.blockAccess, x, y, z);
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        int texX = tex % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int texY = tex / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int atlasWidth = TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES;
        double uMin = (float)texX / (float)atlasWidth;
        double uMax = ((float)texX + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)atlasWidth;
        double vMin = (float)texY / (float)atlasWidth;
        double vMax = ((float)texY + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)atlasWidth;
        float yOffset = 1.4f;
        if (BlockModelFire.renderBlocks.blockAccess.isBlockNormalCube(x, y - 1, z) || ((BlockFire)Block.fire).canBlockCatchFire(BlockModelFire.renderBlocks.blockAccess, x, y - 1, z)) {
            double d8 = (double)x + 0.5 + 0.2;
            double d9 = (double)x + 0.5 - 0.2;
            double d12 = (double)z + 0.5 + 0.2;
            double d14 = (double)z + 0.5 - 0.2;
            double d16 = (double)x + 0.5 - 0.3;
            double d18 = (double)x + 0.5 + 0.3;
            double d20 = (double)z + 0.5 - 0.3;
            double d22 = (double)z + 0.5 + 0.3;
            tessellator.addVertexWithUV(d16, (float)y + 1.4f, z + 1, uMax, vMin);
            tessellator.addVertexWithUV(d8, y, z + 1, uMax, vMax);
            tessellator.addVertexWithUV(d8, y, z, uMin, vMax);
            tessellator.addVertexWithUV(d16, (float)y + 1.4f, z, uMin, vMin);
            tessellator.addVertexWithUV(d18, (float)y + 1.4f, z, uMax, vMin);
            tessellator.addVertexWithUV(d9, y, z, uMax, vMax);
            tessellator.addVertexWithUV(d9, y, z + 1, uMin, vMax);
            tessellator.addVertexWithUV(d18, (float)y + 1.4f, z + 1, uMin, vMin);
            uMin = (float)texX / (float)atlasWidth;
            uMax = ((float)texX + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)atlasWidth;
            vMin = (float)(texY + TextureFX.tileWidthTerrain) / (float)atlasWidth;
            vMax = ((float)texY + ((float)TextureFX.tileWidthTerrain - 0.01f) + (float)TextureFX.tileWidthTerrain) / (float)atlasWidth;
            tessellator.addVertexWithUV(x + 1, (float)y + 1.4f, d22, uMax, vMin);
            tessellator.addVertexWithUV(x + 1, y, d14, uMax, vMax);
            tessellator.addVertexWithUV(x, y, d14, uMin, vMax);
            tessellator.addVertexWithUV(x, (float)y + 1.4f, d22, uMin, vMin);
            tessellator.addVertexWithUV(x, (float)y + 1.4f, d20, uMax, vMin);
            tessellator.addVertexWithUV(x, y, d12, uMax, vMax);
            tessellator.addVertexWithUV(x + 1, y, d12, uMin, vMax);
            tessellator.addVertexWithUV(x + 1, (float)y + 1.4f, d20, uMin, vMin);
            d8 = (double)x + 0.5 - 0.5;
            d9 = (double)x + 0.5 + 0.5;
            d12 = (double)z + 0.5 - 0.5;
            d14 = (double)z + 0.5 + 0.5;
            d16 = (double)x + 0.5 - 0.4;
            d18 = (double)x + 0.5 + 0.4;
            d20 = (double)z + 0.5 - 0.4;
            d22 = (double)z + 0.5 + 0.4;
            tessellator.addVertexWithUV(d16, (float)y + 1.4f, z, uMin, vMin);
            tessellator.addVertexWithUV(d8, y, z, uMin, vMax);
            tessellator.addVertexWithUV(d8, y, z + 1, uMax, vMax);
            tessellator.addVertexWithUV(d16, (float)y + 1.4f, z + 1, uMax, vMin);
            tessellator.addVertexWithUV(d18, (float)y + 1.4f, z + 1, uMin, vMin);
            tessellator.addVertexWithUV(d9, y, z + 1, uMin, vMax);
            tessellator.addVertexWithUV(d9, y, z, uMax, vMax);
            tessellator.addVertexWithUV(d18, (float)y + 1.4f, z, uMax, vMin);
            uMin = (float)texX / (float)atlasWidth;
            uMax = ((float)texX + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)atlasWidth;
            vMin = (float)texY / (float)atlasWidth;
            vMax = ((float)texY + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)atlasWidth;
            tessellator.addVertexWithUV(x, (float)y + 1.4f, d22, uMin, vMin);
            tessellator.addVertexWithUV(x, y, d14, uMin, vMax);
            tessellator.addVertexWithUV(x + 1, y, d14, uMax, vMax);
            tessellator.addVertexWithUV(x + 1, (float)y + 1.4f, d22, uMax, vMin);
            tessellator.addVertexWithUV(x + 1, (float)y + 1.4f, d20, uMin, vMin);
            tessellator.addVertexWithUV(x + 1, y, d12, uMin, vMax);
            tessellator.addVertexWithUV(x, y, d12, uMax, vMax);
            tessellator.addVertexWithUV(x, (float)y + 1.4f, d20, uMax, vMin);
        } else {
            float f3 = 0.2f;
            float f4 = 0.0625f;
            if ((x + y + z & 1) == 1) {
                uMin = (float)texX / (float)atlasWidth;
                uMax = ((float)texX + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)atlasWidth;
                vMin = (float)(texY + TextureFX.tileWidthTerrain) / (float)atlasWidth;
                vMax = ((float)texY + ((float)TextureFX.tileWidthTerrain - 0.01f) + (float)TextureFX.tileWidthTerrain) / (float)atlasWidth;
            }
            if ((x / 2 + y / 2 + z / 2 & 1) == 1) {
                double d10 = uMax;
                uMax = uMin;
                uMin = d10;
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(BlockModelFire.renderBlocks.blockAccess, x - 1, y, z)) {
                tessellator.addVertexWithUV((float)x + f3, (float)y + 1.4f + f4, z + 1, uMax, vMin);
                tessellator.addVertexWithUV(x, (float)y + f4, z + 1, uMax, vMax);
                tessellator.addVertexWithUV(x, (float)y + f4, z, uMin, vMax);
                tessellator.addVertexWithUV((float)x + f3, (float)y + 1.4f + f4, z, uMin, vMin);
                tessellator.addVertexWithUV((float)x + f3, (float)y + 1.4f + f4, z, uMin, vMin);
                tessellator.addVertexWithUV(x, (float)y + f4, z, uMin, vMax);
                tessellator.addVertexWithUV(x, (float)y + f4, z + 1, uMax, vMax);
                tessellator.addVertexWithUV((float)x + f3, (float)y + 1.4f + f4, z + 1, uMax, vMin);
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(BlockModelFire.renderBlocks.blockAccess, x + 1, y, z)) {
                tessellator.addVertexWithUV((float)(x + 1) - f3, (float)y + 1.4f + f4, z, uMin, vMin);
                tessellator.addVertexWithUV(x + 1, (float)y + f4, z, uMin, vMax);
                tessellator.addVertexWithUV(x + 1, (float)y + f4, z + 1, uMax, vMax);
                tessellator.addVertexWithUV((float)(x + 1) - f3, (float)y + 1.4f + f4, z + 1, uMax, vMin);
                tessellator.addVertexWithUV((float)(x + 1) - f3, (float)y + 1.4f + f4, z + 1, uMax, vMin);
                tessellator.addVertexWithUV(x + 1, (float)y + f4, z + 1, uMax, vMax);
                tessellator.addVertexWithUV(x + 1, (float)y + f4, z, uMin, vMax);
                tessellator.addVertexWithUV((float)(x + 1) - f3, (float)y + 1.4f + f4, z, uMin, vMin);
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(BlockModelFire.renderBlocks.blockAccess, x, y, z - 1)) {
                tessellator.addVertexWithUV(x, (float)y + 1.4f + f4, (float)z + f3, uMax, vMin);
                tessellator.addVertexWithUV(x, (float)y + f4, z, uMax, vMax);
                tessellator.addVertexWithUV(x + 1, (float)y + f4, z, uMin, vMax);
                tessellator.addVertexWithUV(x + 1, (float)y + 1.4f + f4, (float)z + f3, uMin, vMin);
                tessellator.addVertexWithUV(x + 1, (float)y + 1.4f + f4, (float)z + f3, uMin, vMin);
                tessellator.addVertexWithUV(x + 1, (float)y + f4, z, uMin, vMax);
                tessellator.addVertexWithUV(x, (float)y + f4, z, uMax, vMax);
                tessellator.addVertexWithUV(x, (float)y + 1.4f + f4, (float)z + f3, uMax, vMin);
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(BlockModelFire.renderBlocks.blockAccess, x, y, z + 1)) {
                tessellator.addVertexWithUV(x + 1, (float)y + 1.4f + f4, (float)(z + 1) - f3, uMin, vMin);
                tessellator.addVertexWithUV(x + 1, (float)y + f4, z + 1, uMin, vMax);
                tessellator.addVertexWithUV(x, (float)y + f4, z + 1, uMax, vMax);
                tessellator.addVertexWithUV(x, (float)y + 1.4f + f4, (float)(z + 1) - f3, uMax, vMin);
                tessellator.addVertexWithUV(x, (float)y + 1.4f + f4, (float)(z + 1) - f3, uMax, vMin);
                tessellator.addVertexWithUV(x, (float)y + f4, z + 1, uMax, vMax);
                tessellator.addVertexWithUV(x + 1, (float)y + f4, z + 1, uMin, vMax);
                tessellator.addVertexWithUV(x + 1, (float)y + 1.4f + f4, (float)(z + 1) - f3, uMin, vMin);
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(BlockModelFire.renderBlocks.blockAccess, x, y + 1, z)) {
                double d11 = (double)x + 0.5 + 0.5;
                double d13 = (double)x + 0.5 - 0.5;
                double d15 = (double)z + 0.5 + 0.5;
                double d17 = (double)z + 0.5 - 0.5;
                double d19 = (double)x + 0.5 - 0.5;
                double d21 = (double)x + 0.5 + 0.5;
                double d23 = (double)z + 0.5 - 0.5;
                double d24 = (double)z + 0.5 + 0.5;
                double d1 = (float)texX / (float)atlasWidth;
                double d3 = ((float)texX + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)atlasWidth;
                double d5 = (float)texY / (float)atlasWidth;
                double d7 = ((float)texY + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)atlasWidth;
                float f2 = -0.2f;
                if ((x + ++y + z & 1) == 0) {
                    tessellator.addVertexWithUV(d19, (float)y + f2, z, d3, d5);
                    tessellator.addVertexWithUV(d11, y, z, d3, d7);
                    tessellator.addVertexWithUV(d11, y, z + 1, d1, d7);
                    tessellator.addVertexWithUV(d19, (float)y + f2, z + 1, d1, d5);
                    d1 = (float)texX / (float)atlasWidth;
                    d3 = ((float)texX + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)atlasWidth;
                    d5 = (float)(texY + TextureFX.tileWidthTerrain) / (float)atlasWidth;
                    d7 = ((float)texY + ((float)TextureFX.tileWidthTerrain - 0.01f) + (float)TextureFX.tileWidthTerrain) / (float)atlasWidth;
                    tessellator.addVertexWithUV(d21, (float)y + f2, z + 1, d3, d5);
                    tessellator.addVertexWithUV(d13, y, z + 1, d3, d7);
                    tessellator.addVertexWithUV(d13, y, z, d1, d7);
                    tessellator.addVertexWithUV(d21, (float)y + f2, z, d1, d5);
                } else {
                    tessellator.addVertexWithUV(x, (float)y + f2, d24, d3, d5);
                    tessellator.addVertexWithUV(x, y, d17, d3, d7);
                    tessellator.addVertexWithUV(x + 1, y, d17, d1, d7);
                    tessellator.addVertexWithUV(x + 1, (float)y + f2, d24, d1, d5);
                    d1 = (float)texX / (float)atlasWidth;
                    d3 = ((float)texX + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)atlasWidth;
                    d5 = (float)(texY + TextureFX.tileWidthTerrain) / (float)atlasWidth;
                    d7 = ((float)texY + ((float)TextureFX.tileWidthTerrain - 0.01f) + (float)TextureFX.tileWidthTerrain) / (float)atlasWidth;
                    tessellator.addVertexWithUV(x + 1, (float)y + f2, d23, d3, d5);
                    tessellator.addVertexWithUV(x + 1, y, d15, d3, d7);
                    tessellator.addVertexWithUV(x, y, d15, d1, d7);
                    tessellator.addVertexWithUV(x, (float)y + f2, d23, d1, d5);
                }
            }
        }
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }
}

