/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockFluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class BlockModelFluid<T extends Block>
extends BlockModelStandard<T> {
    public BlockModelFluid(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelFluid.renderBlocks.world, x, y, z);
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getWorldColor(BlockModelFluid.renderBlocks.world, x, y, z);
        float colorRed = (float)(color >> 16 & 0xFF) / 255.0f;
        float colorGreen = (float)(color >> 8 & 0xFF) / 255.0f;
        float colorBlue = (float)(color & 0xFF) / 255.0f;
        boolean renderTop = this.shouldSideBeRendered(BlockModelFluid.renderBlocks.blockAccess, x, y + 1, z, 1);
        boolean flag1 = this.shouldSideBeRendered(BlockModelFluid.renderBlocks.blockAccess, x, y - 1, z, 0);
        boolean[] aflag = new boolean[]{this.shouldSideBeRendered(BlockModelFluid.renderBlocks.blockAccess, x, y, z - 1, 2), this.shouldSideBeRendered(BlockModelFluid.renderBlocks.blockAccess, x, y, z + 1, 3), this.shouldSideBeRendered(BlockModelFluid.renderBlocks.blockAccess, x - 1, y, z, 4), this.shouldSideBeRendered(BlockModelFluid.renderBlocks.blockAccess, x + 1, y, z, 5)};
        if (!(renderTop || flag1 || aflag[0] || aflag[1] || aflag[2] || aflag[3])) {
            return false;
        }
        boolean flag2 = false;
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        double d = 0.0;
        double d1 = 1.0;
        Material material = this.block.blockMaterial;
        int i1 = BlockModelFluid.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        float f7 = this.func_1224_a(x, y, z, material);
        float f8 = this.func_1224_a(x, y, z + 1, material);
        float f9 = this.func_1224_a(x + 1, y, z + 1, material);
        float f10 = this.func_1224_a(x + 1, y, z, material);
        if (BlockModelFluid.renderBlocks.renderAllFaces || renderTop) {
            flag2 = true;
            int j1 = this.getBlockTextureFromSideAndMetadata(Side.TOP, i1);
            float f12 = (float)BlockFluid.getSlopeAngle(BlockModelFluid.renderBlocks.blockAccess, x, y, z, material);
            if (f12 > -999.0f) {
                j1 = this.getBlockTextureFromSideAndMetadata(Side.NORTH, i1);
            }
            int i2 = j1 % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
            int k2 = j1 / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
            double d2 = ((double)i2 + (double)(TextureFX.tileWidthTerrain / 2)) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            double d3 = ((double)k2 + (double)(TextureFX.tileWidthTerrain / 2)) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            if (f12 < -999.0f) {
                f12 = 0.0f;
            } else {
                d2 = (float)(i2 + TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
                d3 = (float)(k2 + TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            }
            float f14 = MathHelper.sin(f12) * (float)(TextureFX.tileWidthTerrain / 2) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            float f16 = MathHelper.cos(f12) * (float)(TextureFX.tileWidthTerrain / 2) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            float f18 = this.getBlockBrightness(BlockModelFluid.renderBlocks.blockAccess, x, y, z);
            tessellator.setColorOpaque_F(f4 * f18 * colorRed, f4 * f18 * colorGreen, f4 * f18 * colorBlue);
            tessellator.addVertexWithUV(x, (float)y + f7, z, d2 - (double)f16 - (double)f14, d3 - (double)f16 + (double)f14);
            tessellator.addVertexWithUV(x, (float)y + f8, z + 1, d2 - (double)f16 + (double)f14, d3 + (double)f16 + (double)f14);
            tessellator.addVertexWithUV(x + 1, (float)y + f9, z + 1, d2 + (double)f16 + (double)f14, d3 + (double)f16 - (double)f14);
            tessellator.addVertexWithUV(x + 1, (float)y + f10, z, d2 + (double)f16 - (double)f14, d3 - (double)f16 - (double)f14);
        }
        if (BlockModelFluid.renderBlocks.renderAllFaces || flag1) {
            float f11 = this.getBlockBrightness(BlockModelFluid.renderBlocks.blockAccess, x, y - 1, z);
            tessellator.setColorOpaque_F(f3 * f11 * colorRed, f3 * f11 * colorGreen, f3 * f11 * colorBlue);
            this.renderBottomFace(tessellator, this.block, x, (float)y + 1.0E-4f, z, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, i1));
            flag2 = true;
        }
        for (int k1 = 0; k1 < 4; ++k1) {
            float f21;
            float f19;
            float f20;
            float f17;
            float f15;
            float f13;
            int l1 = x;
            int j2 = y;
            int l2 = z;
            if (k1 == 0) {
                --l2;
            }
            if (k1 == 1) {
                ++l2;
            }
            if (k1 == 2) {
                --l1;
            }
            if (k1 == 3) {
                ++l1;
            }
            int i3 = this.getBlockTextureFromSideAndMetadata(Side.getSideById(k1 + 2), i1);
            int j3 = i3 % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
            int k3 = i3 / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
            if (!BlockModelFluid.renderBlocks.renderAllFaces && !aflag[k1]) continue;
            if (k1 == 0) {
                f13 = f7;
                f15 = f10;
                f17 = (float)x + 1.0E-4f;
                f20 = (float)(x + 1) - 1.0E-4f;
                f19 = (float)z + 1.0E-4f;
                f21 = (float)z + 1.0E-4f;
            } else if (k1 == 1) {
                f13 = f9;
                f15 = f8;
                f17 = (float)(x + 1) - 1.0E-4f;
                f20 = (float)x + 1.0E-4f;
                f19 = (float)(z + 1) - 1.0E-4f;
                f21 = (float)(z + 1) - 0.001f;
            } else if (k1 == 2) {
                f13 = f8;
                f15 = f7;
                f17 = (float)x + 1.0E-4f;
                f20 = (float)x + 1.0E-4f;
                f19 = (float)(z + 1) - 1.0E-4f;
                f21 = (float)z + 1.0E-4f;
            } else {
                f13 = f10;
                f15 = f9;
                f17 = (float)(x + 1) - 1.0E-4f;
                f20 = (float)(x + 1) - 1.0E-4f;
                f19 = (float)z + 1.0E-4f;
                f21 = (float)(z + 1) - 1.0E-4f;
            }
            flag2 = true;
            double d4 = (float)j3 / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            double d5 = ((double)(j3 + TextureFX.tileWidthTerrain) - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            double d6 = ((float)k3 + (1.0f - f13) * (float)TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            double d7 = ((float)k3 + (1.0f - f15) * (float)TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            double d8 = ((double)(k3 + TextureFX.tileWidthTerrain) - 0.01) / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            float f22 = this.getBlockBrightness(BlockModelFluid.renderBlocks.blockAccess, l1, j2, l2);
            f22 = k1 < 2 ? (f22 *= f5) : (f22 *= f6);
            tessellator.setColorOpaque_F(f4 * f22 * colorRed, f4 * f22 * colorGreen, f4 * f22 * colorBlue);
            tessellator.addVertexWithUV(f17, (float)y + f13, f19, d4, d6);
            tessellator.addVertexWithUV(f20, (float)y + f15, f21, d5, d7);
            tessellator.addVertexWithUV(f20, y, f21, d5, d8);
            tessellator.addVertexWithUV(f17, y, f19, d4, d8);
        }
        this.block.minY = d;
        this.block.maxY = d1;
        return flag2;
    }

    private float func_1224_a(int i, int j, int k, Material material) {
        int l = 0;
        float f = 0.0f;
        for (int i1 = 0; i1 < 4; ++i1) {
            int j1 = i - (i1 & 1);
            int l1 = k - (i1 >> 1 & 1);
            if (BlockModelFluid.renderBlocks.blockAccess.getBlockMaterial(j1, j + 1, l1) == material) {
                return 1.0f;
            }
            Material material1 = BlockModelFluid.renderBlocks.blockAccess.getBlockMaterial(j1, j, l1);
            if (material1 == material) {
                int i2 = BlockModelFluid.renderBlocks.blockAccess.getBlockMetadata(j1, j, l1);
                if (i2 >= 8 || i2 == 0) {
                    f += BlockFluid.getWaterVolume(i2) * 10.0f;
                    l += 10;
                }
                f += BlockFluid.getWaterVolume(i2);
                ++l;
                continue;
            }
            if (material1.isSolid()) continue;
            f += 1.0f;
            ++l;
        }
        return 1.0f - f / (float)l;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side) {
        Material material = blockAccess.getBlockMaterial(x, y, z);
        if (material == this.block.blockMaterial) {
            return false;
        }
        if (material == Material.ice) {
            return true;
        }
        if (side == Side.TOP.getId()) {
            return true;
        }
        return super.shouldSideBeRendered(blockAccess, x, y, z, side);
    }
}

