/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;

public class BlockModelJar<T extends Block>
extends BlockModelStandard<T> {
    public BlockModelJar(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelJar.renderBlocks.world, x, y, z);
        float brightness = this.getBlockBrightness(BlockModelJar.renderBlocks.world, x, y, z);
        float yOffset = 0.0f;
        int meta = BlockModelJar.renderBlocks.world.getBlockMetadata(x, y, z);
        float extMinX = (float)x + 0.5f - 0.1875f;
        float extMinY = (float)y + yOffset;
        float extMinZ = (float)z + 0.5f - 0.1875f;
        float extMaxX = (float)x + 0.5f + 0.1875f;
        float extMaxY = (float)y + (0.5f + yOffset);
        float extMaxZ = (float)z + 0.5f + 0.1875f;
        float fillMaxY = (float)y + (0.5f + yOffset) - 0.25f;
        float intMinX = (float)x + 0.5f - 0.1875f;
        float intMinY = (float)y + yOffset;
        float intMinZ = (float)z + 0.5f - 0.1875f;
        float intMaxX = (float)x + 0.5f + 0.1875f;
        float intMaxY = (float)y + (0.5f + yOffset);
        float intMaxZ = (float)z + 0.5f + 0.1875f;
        int texIndex = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, meta);
        int texX = texIndex % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int texY = texIndex / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double texU = (float)texX / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double texV = (float)texY / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double onePix = (float)TextureFX.tileWidthTerrain / 16.0f / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain);
        double extSideMinU = texU;
        double extSideMaxU = texU + onePix * 6.0;
        double extSideMinV = texV + onePix * 6.0;
        double extSideMaxV = texV + onePix * 6.0 + onePix * 8.0;
        double extBottomMinU = texU + onePix * 6.0;
        double extBottomMaxU = texU + onePix * 6.0 + onePix * 6.0;
        double extBottomMinV = texV;
        double extBottomMaxV = texV + onePix * 6.0;
        double extTopMinU = texU;
        double extTopMaxU = texU + onePix * 6.0;
        double extTopMinV = texV;
        double extTopMaxV = texV + onePix * 6.0;
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        tessellator.addVertexWithUV(intMaxX, intMinY, intMaxZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(intMinX, intMinY, intMaxZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(intMinX, intMaxY, intMaxZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(intMaxX, intMaxY, intMaxZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(intMinX, intMinY, intMinZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(intMaxX, intMinY, intMinZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(intMaxX, intMaxY, intMinZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(intMinX, intMaxY, intMinZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(intMinX, intMinY, intMaxZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(intMinX, intMinY, intMinZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(intMinX, intMaxY, intMinZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(intMinX, intMaxY, intMaxZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(intMaxX, intMinY, intMinZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(intMaxX, intMinY, intMaxZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(intMaxX, intMaxY, intMaxZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(intMaxX, intMaxY, intMinZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, fillMaxY, extMaxZ, extTopMinU, extTopMaxV);
        tessellator.addVertexWithUV(extMaxX, fillMaxY, extMaxZ, extTopMaxU, extTopMaxV);
        tessellator.addVertexWithUV(extMaxX, fillMaxY, extMinZ, extTopMaxU, extTopMinV);
        tessellator.addVertexWithUV(extMinX, fillMaxY, extMinZ, extTopMinU, extTopMinV);
        tessellator.addVertexWithUV(extMinX, extMinY + 0.01f, extMaxZ, extBottomMinU, extBottomMaxV);
        tessellator.addVertexWithUV(extMaxX, extMinY + 0.01f, extMaxZ, extBottomMaxU, extBottomMaxV);
        tessellator.addVertexWithUV(extMaxX, extMinY + 0.01f, extMinZ, extBottomMaxU, extBottomMinV);
        tessellator.addVertexWithUV(extMinX, extMinY + 0.01f, extMinZ, extBottomMinU, extBottomMinV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMinZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMinZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMinZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMinZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMaxZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMaxZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMaxZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMaxZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMaxZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMinZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMinZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMaxZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMinZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMaxZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMaxZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMinZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(intMinX, intMinY, intMinZ, extBottomMinU, extBottomMinV);
        tessellator.addVertexWithUV(intMaxX, intMinY, intMinZ, extBottomMaxU, extBottomMinV);
        tessellator.addVertexWithUV(intMaxX, intMinY, intMaxZ, extBottomMaxU, extBottomMaxV);
        tessellator.addVertexWithUV(intMinX, intMinY, intMaxZ, extBottomMinU, extBottomMaxV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMinZ, extBottomMinU, extBottomMinV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMinZ, extBottomMaxU, extBottomMinV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMaxZ, extBottomMaxU, extBottomMaxV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMaxZ, extBottomMinU, extBottomMaxV);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int meta) {
        if (meta == 1) {
            return BlockModelJar.texCoordToIndex(18, 10);
        }
        return BlockModelJar.texCoordToIndex(13, 9);
    }
}

