/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;

public class BlockModelLadder<T extends Block>
extends BlockModelStandard<T> {
    public BlockModelLadder(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelLadder.renderBlocks.world, x, y, z);
        int k1 = BlockModelLadder.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        int l = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, k1);
        if (BlockModelLadder.renderBlocks.overrideBlockTexture >= 0) {
            l = BlockModelLadder.renderBlocks.overrideBlockTexture;
        }
        float f = this.getBlockBrightness(BlockModelLadder.renderBlocks.blockAccess, x, y, z);
        tessellator.setColorOpaque_F(f, f, f);
        int i1 = l % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int j1 = l / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d = (float)i1 / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d1 = ((float)i1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d2 = (float)j1 / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d3 = ((float)j1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        float f1 = 0.0f;
        float f2 = 0.05f;
        if (k1 == 5) {
            tessellator.addVertexWithUV((float)x + f2, (float)(y + 1) + f1, (float)(z + 1) + f1, d, d2);
            tessellator.addVertexWithUV((float)x + f2, (float)(y + 0) - f1, (float)(z + 1) + f1, d, d3);
            tessellator.addVertexWithUV((float)x + f2, (float)(y + 0) - f1, (float)(z + 0) - f1, d1, d3);
            tessellator.addVertexWithUV((float)x + f2, (float)(y + 1) + f1, (float)(z + 0) - f1, d1, d2);
        }
        if (k1 == 4) {
            tessellator.addVertexWithUV((float)(x + 1) - f2, (float)(y + 0) - f1, (float)(z + 1) + f1, d1, d3);
            tessellator.addVertexWithUV((float)(x + 1) - f2, (float)(y + 1) + f1, (float)(z + 1) + f1, d1, d2);
            tessellator.addVertexWithUV((float)(x + 1) - f2, (float)(y + 1) + f1, (float)(z + 0) - f1, d, d2);
            tessellator.addVertexWithUV((float)(x + 1) - f2, (float)(y + 0) - f1, (float)(z + 0) - f1, d, d3);
        }
        if (k1 == 3) {
            tessellator.addVertexWithUV((float)(x + 1) + f1, (float)(y + 0) - f1, (float)z + f2, d1, d3);
            tessellator.addVertexWithUV((float)(x + 1) + f1, (float)(y + 1) + f1, (float)z + f2, d1, d2);
            tessellator.addVertexWithUV((float)(x + 0) - f1, (float)(y + 1) + f1, (float)z + f2, d, d2);
            tessellator.addVertexWithUV((float)(x + 0) - f1, (float)(y + 0) - f1, (float)z + f2, d, d3);
        }
        if (k1 == 2) {
            tessellator.addVertexWithUV((float)(x + 1) + f1, (float)(y + 1) + f1, (float)(z + 1) - f2, d, d2);
            tessellator.addVertexWithUV((float)(x + 1) + f1, (float)(y + 0) - f1, (float)(z + 1) - f2, d, d3);
            tessellator.addVertexWithUV((float)(x + 0) - f1, (float)(y + 0) - f1, (float)(z + 1) - f2, d1, d3);
            tessellator.addVertexWithUV((float)(x + 0) - f1, (float)(y + 1) + f1, (float)(z + 1) - f2, d1, d2);
        }
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }
}

