/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLamp;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class BlockModelLamp<T extends BlockLamp>
extends BlockModelStandard<T> {
    private static final int[] texCoordsInactive;
    private static final int[] texCoordsActive;

    public BlockModelLamp(Block block) {
        super(block);
    }

    @Override
    public int getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        int data = blockAccess.getBlockMetadata(x, y, z);
        if (((BlockLamp)this.block).isActive) {
            return texCoordsActive[data & 0xF];
        }
        return texCoordsInactive[data & 0xF];
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int data) {
        return texCoordsActive[data & 0xF];
    }

    static {
        int i;
        texCoordsInactive = new int[16];
        texCoordsActive = new int[16];
        BlockModelLamp.texCoordsInactive[0] = BlockModelLamp.texCoordToIndex(17, 31);
        for (i = 1; i < 16; ++i) {
            BlockModelLamp.texCoordsInactive[i] = texCoordsInactive[0] - i % 8 * Global.TEXTURE_ATLAS_WIDTH_TILES - i / 8;
        }
        BlockModelLamp.texCoordsActive[0] = BlockModelLamp.texCoordToIndex(19, 31);
        for (i = 1; i < 16; ++i) {
            BlockModelLamp.texCoordsActive[i] = texCoordsActive[0] - i % 8 * Global.TEXTURE_ATLAS_WIDTH_TILES - i / 8;
        }
    }
}

