/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;

public class BlockModelLantern<T extends Block>
extends BlockModelStandard<T> {
    public BlockModelLantern(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelLantern.renderBlocks.world, x, y, z);
        int meta = BlockModelLantern.renderBlocks.world.getBlockMetadata(x, y, z);
        boolean isHanging = (meta & 1) == 0;
        boolean isAngled = (meta & 2) != 0;
        float brightness = this.getBlockBrightness(BlockModelLantern.renderBlocks.world, x, y, z);
        float yOffset = isHanging ? 0.0f : 0.375f;
        float intMinX = (float)x + 0.5f - 0.125f;
        float intMinY = (float)y + yOffset + 0.0625f;
        float intMinZ = (float)z + 0.5f - 0.125f;
        float intMaxX = (float)x + 0.5f + 0.125f;
        float intMaxY = (float)y + (0.4375f + yOffset);
        float intMaxZ = (float)z + 0.5f + 0.125f;
        float extMinX = (float)x + 0.5f - 0.1875f;
        float extMinY = (float)y + yOffset;
        float extMinZ = (float)z + 0.5f - 0.1875f;
        float extMaxX = (float)x + 0.5f + 0.1875f;
        float extMaxY = (float)y + (0.5f + yOffset);
        float extMaxZ = (float)z + 0.5f + 0.1875f;
        float hookMinX = (float)x + 0.5f - 0.125f;
        float hookMinZ = (float)z + 0.5f - 0.125f;
        float hookMaxX = (float)x + 0.5f + 0.125f;
        float hookMaxY = intMaxY + 0.25f;
        float hookMaxZ = (float)z + 0.5f + 0.125f;
        int texIndex = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, meta);
        int texX = texIndex % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int texY = texIndex / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double texU = (float)texX / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double texV = (float)texY / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double onePix = (float)TextureFX.tileWidthTerrain / 16.0f / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain);
        double extSideMinU = texU;
        double extSideMaxU = texU + onePix * 6.0;
        double extSideMinV = texV + onePix * 6.0;
        double extSideMaxV = texV + onePix * 6.0 + onePix * 8.0;
        double extTopMinU = texU;
        double extTopMaxU = texU + onePix * 6.0;
        double extTopMinV = texV;
        double extTopMaxV = texV + onePix * 6.0;
        double extBottomMinU = texU + onePix * 6.0;
        double extBottomMaxU = texU + onePix * 6.0 + onePix * 6.0;
        double extBottomMinV = texV;
        double extBottomMaxV = texV + onePix * 6.0;
        double sideMinU = texU + onePix * 6.0;
        double sideMaxU = texU + onePix * 6.0 + onePix * 4.0;
        double sideMinV = texV + onePix * 10.0;
        double sideMaxV = texV + onePix * 10.0 + onePix * 6.0;
        double topMinU = texU + onePix * 6.0;
        double topMaxU = texU + onePix * 6.0 + onePix * 4.0;
        double topMinV = texV + onePix * 6.0;
        double topMaxV = texV + onePix * 6.0 + onePix * 4.0;
        double bottomMinU = texU + onePix * 6.0;
        double bottomMaxU = texU + onePix * 6.0 + onePix * 4.0;
        double bottomMinV = texV + onePix * 6.0;
        double bottomMaxV = texV + onePix * 6.0 + onePix * 4.0;
        double hookMinU = texU + onePix * 10.0;
        double hookMaxU = texU + onePix * 10.0 + onePix * 6.0;
        double hookMinV = texV + onePix * 6.0;
        double hookMaxV = texV + onePix * 6.0 + onePix * 4.0;
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        tessellator.addVertexWithUV(intMaxX, intMinY, intMinZ, sideMinU, sideMaxV);
        tessellator.addVertexWithUV(intMinX, intMinY, intMinZ, sideMaxU, sideMaxV);
        tessellator.addVertexWithUV(intMinX, intMaxY, intMinZ, sideMaxU, sideMinV);
        tessellator.addVertexWithUV(intMaxX, intMaxY, intMinZ, sideMinU, sideMinV);
        tessellator.addVertexWithUV(intMinX, intMinY, intMaxZ, sideMinU, sideMaxV);
        tessellator.addVertexWithUV(intMaxX, intMinY, intMaxZ, sideMaxU, sideMaxV);
        tessellator.addVertexWithUV(intMaxX, intMaxY, intMaxZ, sideMaxU, sideMinV);
        tessellator.addVertexWithUV(intMinX, intMaxY, intMaxZ, sideMinU, sideMinV);
        tessellator.addVertexWithUV(intMaxX, intMinY, intMaxZ, sideMinU, sideMaxV);
        tessellator.addVertexWithUV(intMaxX, intMinY, intMinZ, sideMaxU, sideMaxV);
        tessellator.addVertexWithUV(intMaxX, intMaxY, intMinZ, sideMaxU, sideMinV);
        tessellator.addVertexWithUV(intMaxX, intMaxY, intMaxZ, sideMinU, sideMinV);
        tessellator.addVertexWithUV(intMinX, intMinY, intMinZ, sideMinU, sideMaxV);
        tessellator.addVertexWithUV(intMinX, intMinY, intMaxZ, sideMaxU, sideMaxV);
        tessellator.addVertexWithUV(intMinX, intMaxY, intMaxZ, sideMaxU, sideMinV);
        tessellator.addVertexWithUV(intMinX, intMaxY, intMinZ, sideMinU, sideMinV);
        tessellator.addVertexWithUV(intMinX, intMaxY, intMaxZ, topMinU, topMaxV);
        tessellator.addVertexWithUV(intMaxX, intMaxY, intMaxZ, topMaxU, topMaxV);
        tessellator.addVertexWithUV(intMaxX, intMaxY, intMinZ, topMaxU, topMinV);
        tessellator.addVertexWithUV(intMinX, intMaxY, intMinZ, topMinU, topMinV);
        tessellator.addVertexWithUV(intMinX, intMinY, intMinZ, bottomMinU, bottomMinV);
        tessellator.addVertexWithUV(intMaxX, intMinY, intMinZ, bottomMaxU, bottomMinV);
        tessellator.addVertexWithUV(intMaxX, intMinY, intMaxZ, bottomMaxU, bottomMaxV);
        tessellator.addVertexWithUV(intMinX, intMinY, intMaxZ, bottomMinU, bottomMaxV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMinZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMinZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMinZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMinZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMaxZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMaxZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMaxZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMaxZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMaxZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMinZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMinZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMaxZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMinZ, extSideMinU, extSideMaxV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMaxZ, extSideMaxU, extSideMaxV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMaxZ, extSideMaxU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMinZ, extSideMinU, extSideMinV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMaxZ, extTopMinU, extTopMaxV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMaxZ, extTopMaxU, extTopMaxV);
        tessellator.addVertexWithUV(extMaxX, extMaxY, extMinZ, extTopMaxU, extTopMinV);
        tessellator.addVertexWithUV(extMinX, extMaxY, extMinZ, extTopMinU, extTopMinV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMinZ, extBottomMinU, extBottomMinV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMinZ, extBottomMaxU, extBottomMinV);
        tessellator.addVertexWithUV(extMaxX, extMinY, extMaxZ, extBottomMaxU, extBottomMaxV);
        tessellator.addVertexWithUV(extMinX, extMinY, extMaxZ, extBottomMinU, extBottomMaxV);
        tessellator.addVertexWithUV(hookMinX, intMaxY, hookMinZ, hookMinU, hookMaxV);
        tessellator.addVertexWithUV(hookMaxX, intMaxY, hookMaxZ, hookMaxU, hookMaxV);
        tessellator.addVertexWithUV(hookMaxX, hookMaxY, hookMaxZ, hookMaxU, hookMinV);
        tessellator.addVertexWithUV(hookMinX, hookMaxY, hookMinZ, hookMinU, hookMinV);
        tessellator.addVertexWithUV(hookMinX, hookMaxY, hookMinZ, hookMaxU, hookMinV);
        tessellator.addVertexWithUV(hookMaxX, hookMaxY, hookMaxZ, hookMinU, hookMinV);
        tessellator.addVertexWithUV(hookMaxX, intMaxY, hookMaxZ, hookMinU, hookMaxV);
        tessellator.addVertexWithUV(hookMinX, intMaxY, hookMinZ, hookMaxU, hookMaxV);
        tessellator.addVertexWithUV(hookMinX, intMaxY, intMaxZ, hookMinU, hookMaxV);
        tessellator.addVertexWithUV(hookMaxX, intMaxY, intMinZ, hookMaxU, hookMaxV);
        tessellator.addVertexWithUV(hookMaxX, hookMaxY, intMinZ, hookMaxU, hookMinV);
        tessellator.addVertexWithUV(hookMinX, hookMaxY, intMaxZ, hookMinU, hookMinV);
        tessellator.addVertexWithUV(hookMinX, hookMaxY, hookMaxZ, hookMaxU, hookMinV);
        tessellator.addVertexWithUV(hookMaxX, hookMaxY, hookMinZ, hookMinU, hookMinV);
        tessellator.addVertexWithUV(hookMaxX, intMaxY, hookMinZ, hookMinU, hookMaxV);
        tessellator.addVertexWithUV(hookMinX, intMaxY, hookMaxZ, hookMaxU, hookMaxV);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }
}

