/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockRail;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class BlockModelRail<T extends BlockRail>
extends BlockModelStandard<T> {
    public BlockModelRail(Block block) {
        super(block);
        this.hasOverbright = true;
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        ((BlockRail)this.block).setBlockBoundsBasedOnState(BlockModelRail.renderBlocks.world, x, y, z);
        int l = BlockModelRail.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        int i1 = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, l);
        if (BlockModelRail.renderBlocks.overrideBlockTexture >= 0) {
            i1 = BlockModelRail.renderBlocks.overrideBlockTexture;
        }
        if (((BlockRail)this.block).getIsPowered()) {
            l &= 7;
        }
        float f = this.getBlockBrightness(BlockModelRail.renderBlocks.blockAccess, x, y, z);
        if (BlockModelRail.renderBlocks.overbright) {
            i1 = this.getBlockOverbrightTexture(BlockModelRail.renderBlocks.blockAccess, x, y, z, 0);
            if (i1 == -1) {
                return false;
            }
            f = 1.0f;
        }
        tessellator.setColorOpaque_F(f, f, f);
        int j1 = i1 % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k1 = i1 / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d = (float)j1 / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d1 = ((float)j1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d2 = (float)k1 / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d3 = ((float)k1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        float f1 = 0.0625f;
        float f2 = x + 1;
        float f3 = x + 1;
        float f4 = x;
        float f5 = x;
        float f6 = z;
        float f7 = z + 1;
        float f8 = z + 1;
        float f9 = z;
        float f10 = (float)y + f1;
        float f11 = (float)y + f1;
        float f12 = (float)y + f1;
        float f13 = (float)y + f1;
        if (l == 1 || l == 2 || l == 3 || l == 7) {
            f2 = f5 = (float)(x + 1);
            f3 = f4 = (float)x;
            f6 = f7 = (float)(z + 1);
            f8 = f9 = (float)z;
        } else if (l == 8) {
            f2 = f3 = (float)x;
            f4 = f5 = (float)(x + 1);
            f6 = f9 = (float)(z + 1);
            f7 = f8 = (float)z;
        } else if (l == 9) {
            f2 = f5 = (float)x;
            f3 = f4 = (float)(x + 1);
            f6 = f7 = (float)z;
            f8 = f9 = (float)(z + 1);
        }
        if (l == 2 || l == 4) {
            f10 += 1.0f;
            f13 += 1.0f;
        } else if (l == 3 || l == 5) {
            f11 += 1.0f;
            f12 += 1.0f;
        }
        tessellator.addVertexWithUV(f2, f10, f6, d1, d2);
        tessellator.addVertexWithUV(f3, f11, f7, d1, d3);
        tessellator.addVertexWithUV(f4, f12, f8, d, d3);
        tessellator.addVertexWithUV(f5, f13, f9, d, d2);
        tessellator.addVertexWithUV(f5, f13, f9, d, d2);
        tessellator.addVertexWithUV(f4, f12, f8, d, d3);
        tessellator.addVertexWithUV(f3, f11, f7, d1, d3);
        tessellator.addVertexWithUV(f2, f10, f6, d1, d2);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public int getBlockOverbrightTexture(WorldSource blockAccess, int x, int y, int z, int side) {
        if (((BlockRail)this.block).id != Block.railPowered.id || (blockAccess.getBlockMetadata(x, y, z) & 8) == 0) {
            return -1;
        }
        return BlockModelRail.texCoordToIndex(0, 16);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (((BlockRail)this.block).isPowered) {
            if (((BlockRail)this.block).id == Block.railPowered.id && (data & 8) == 0) {
                return BlockModelRail.texCoordToIndex(3, 10);
            }
            if (((BlockRail)this.block).id == Block.railPowered.id) {
                return BlockModelRail.texCoordToIndex(3, 11);
            }
        } else if (data >= 6) {
            return BlockModelRail.texCoordToIndex(0, 7);
        }
        return BlockModelRail.texCoordToIndex(0, 8);
    }
}

