/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockRedstoneWire;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.Side;

public class BlockModelRedstoneWire<T extends Block>
extends BlockModelStandard<T> {
    public BlockModelRedstoneWire(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        boolean flag3;
        this.block.setBlockBoundsBasedOnState(BlockModelRedstoneWire.renderBlocks.world, x, y, z);
        int meta = BlockModelRedstoneWire.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        int i1 = this.getBlockTextureFromSideAndMetadata(Side.TOP, meta);
        if (BlockModelRedstoneWire.renderBlocks.overrideBlockTexture >= 0) {
            i1 = BlockModelRedstoneWire.renderBlocks.overrideBlockTexture;
        }
        float brightness = this.getBlockBrightness(BlockModelRedstoneWire.renderBlocks.blockAccess, x, y, z);
        Color color = Colors.allRedstoneColors[meta & 0xF];
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        tessellator.setColorOpaque_F(brightness * red, brightness * green, brightness * blue);
        int j1 = i1 % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int k1 = i1 / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d = (float)j1 / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d2 = ((float)j1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d4 = (float)k1 / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((float)k1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        boolean flag = BlockRedstoneWire.isPowerProviderOrWire(BlockModelRedstoneWire.renderBlocks.blockAccess, x - 1, y, z, 1) || !BlockModelRedstoneWire.renderBlocks.blockAccess.isBlockNormalCube(x - 1, y, z) && BlockRedstoneWire.isPowerProviderOrWire(BlockModelRedstoneWire.renderBlocks.blockAccess, x - 1, y - 1, z, -1);
        boolean flag1 = BlockRedstoneWire.isPowerProviderOrWire(BlockModelRedstoneWire.renderBlocks.blockAccess, x + 1, y, z, 3) || !BlockModelRedstoneWire.renderBlocks.blockAccess.isBlockNormalCube(x + 1, y, z) && BlockRedstoneWire.isPowerProviderOrWire(BlockModelRedstoneWire.renderBlocks.blockAccess, x + 1, y - 1, z, -1);
        boolean flag2 = BlockRedstoneWire.isPowerProviderOrWire(BlockModelRedstoneWire.renderBlocks.blockAccess, x, y, z - 1, 2) || !BlockModelRedstoneWire.renderBlocks.blockAccess.isBlockNormalCube(x, y, z - 1) && BlockRedstoneWire.isPowerProviderOrWire(BlockModelRedstoneWire.renderBlocks.blockAccess, x, y - 1, z - 1, -1);
        boolean bl = flag3 = BlockRedstoneWire.isPowerProviderOrWire(BlockModelRedstoneWire.renderBlocks.blockAccess, x, y, z + 1, 0) || !BlockModelRedstoneWire.renderBlocks.blockAccess.isBlockNormalCube(x, y, z + 1) && BlockRedstoneWire.isPowerProviderOrWire(BlockModelRedstoneWire.renderBlocks.blockAccess, x, y - 1, z + 1, -1);
        if (!BlockModelRedstoneWire.renderBlocks.blockAccess.isBlockNormalCube(x, y + 1, z)) {
            if (BlockModelRedstoneWire.renderBlocks.blockAccess.isBlockNormalCube(x - 1, y, z) && BlockRedstoneWire.isPowerProviderOrWire(BlockModelRedstoneWire.renderBlocks.blockAccess, x - 1, y + 1, z, -1)) {
                flag = true;
            }
            if (BlockModelRedstoneWire.renderBlocks.blockAccess.isBlockNormalCube(x + 1, y, z) && BlockRedstoneWire.isPowerProviderOrWire(BlockModelRedstoneWire.renderBlocks.blockAccess, x + 1, y + 1, z, -1)) {
                flag1 = true;
            }
            if (BlockModelRedstoneWire.renderBlocks.blockAccess.isBlockNormalCube(x, y, z - 1) && BlockRedstoneWire.isPowerProviderOrWire(BlockModelRedstoneWire.renderBlocks.blockAccess, x, y + 1, z - 1, -1)) {
                flag2 = true;
            }
            if (BlockModelRedstoneWire.renderBlocks.blockAccess.isBlockNormalCube(x, y, z + 1) && BlockRedstoneWire.isPowerProviderOrWire(BlockModelRedstoneWire.renderBlocks.blockAccess, x, y + 1, z + 1, -1)) {
                flag3 = true;
            }
        }
        float f5 = x + 0;
        float f6 = x + 1;
        float f7 = z + 0;
        float f8 = z + 1;
        int byte0 = 0;
        if ((flag || flag1) && !flag2 && !flag3) {
            byte0 = 1;
        }
        if ((flag2 || flag3) && !flag1 && !flag) {
            byte0 = 2;
        }
        if (byte0 != 0) {
            d = (float)(j1 + TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d2 = ((float)(j1 + TextureFX.tileWidthTerrain) + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d4 = (float)k1 / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            d6 = ((float)k1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        }
        if (byte0 == 0) {
            if (flag1 || flag2 || flag3 || flag) {
                if (!flag) {
                    f5 += 0.3125f;
                }
                if (!flag) {
                    d += 0.3125 / (double)Global.TEXTURE_ATLAS_WIDTH_TILES;
                }
                if (!flag1) {
                    f6 -= 0.3125f;
                }
                if (!flag1) {
                    d2 -= 0.3125 / (double)Global.TEXTURE_ATLAS_WIDTH_TILES;
                }
                if (!flag2) {
                    f7 += 0.3125f;
                }
                if (!flag2) {
                    d4 += 0.3125 / (double)Global.TEXTURE_ATLAS_WIDTH_TILES;
                }
                if (!flag3) {
                    f8 -= 0.3125f;
                }
                if (!flag3) {
                    d6 -= 0.3125 / (double)Global.TEXTURE_ATLAS_WIDTH_TILES;
                }
            }
            tessellator.addVertexWithUV(f6, (float)y + 0.015625f, f8, d2, d6);
            tessellator.addVertexWithUV(f6, (float)y + 0.015625f, f7, d2, d4);
            tessellator.addVertexWithUV(f5, (float)y + 0.015625f, f7, d, d4);
            tessellator.addVertexWithUV(f5, (float)y + 0.015625f, f8, d, d6);
            tessellator.addVertexWithUV(f6, (float)y + 0.015625f, f8, d2, d6 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            tessellator.addVertexWithUV(f6, (float)y + 0.015625f, f7, d2, d4 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            tessellator.addVertexWithUV(f5, (float)y + 0.015625f, f7, d, d4 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            tessellator.addVertexWithUV(f5, (float)y + 0.015625f, f8, d, d6 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
        } else if (byte0 == 1) {
            tessellator.addVertexWithUV(f6, (float)y + 0.015625f, f8, d2, d6);
            tessellator.addVertexWithUV(f6, (float)y + 0.015625f, f7, d2, d4);
            tessellator.addVertexWithUV(f5, (float)y + 0.015625f, f7, d, d4);
            tessellator.addVertexWithUV(f5, (float)y + 0.015625f, f8, d, d6);
            tessellator.addVertexWithUV(f6, (float)y + 0.015625f, f8, d2, d6 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            tessellator.addVertexWithUV(f6, (float)y + 0.015625f, f7, d2, d4 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            tessellator.addVertexWithUV(f5, (float)y + 0.015625f, f7, d, d4 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            tessellator.addVertexWithUV(f5, (float)y + 0.015625f, f8, d, d6 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
        } else if (byte0 == 2) {
            tessellator.addVertexWithUV(f6, (float)y + 0.015625f, f8, d2, d6);
            tessellator.addVertexWithUV(f6, (float)y + 0.015625f, f7, d, d6);
            tessellator.addVertexWithUV(f5, (float)y + 0.015625f, f7, d, d4);
            tessellator.addVertexWithUV(f5, (float)y + 0.015625f, f8, d2, d4);
            tessellator.addVertexWithUV(f6, (float)y + 0.015625f, f8, d2, d6 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            tessellator.addVertexWithUV(f6, (float)y + 0.015625f, f7, d, d6 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            tessellator.addVertexWithUV(f5, (float)y + 0.015625f, f7, d, d4 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            tessellator.addVertexWithUV(f5, (float)y + 0.015625f, f8, d2, d4 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
        }
        if (!BlockModelRedstoneWire.renderBlocks.blockAccess.isBlockNormalCube(x, y + 1, z)) {
            double d1 = (float)(j1 + TextureFX.tileWidthTerrain) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            double d3 = ((float)(j1 + TextureFX.tileWidthTerrain) + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            double d5 = (float)k1 / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            double d7 = ((float)k1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            if (BlockModelRedstoneWire.renderBlocks.blockAccess.isBlockNormalCube(x - 1, y, z) && BlockModelRedstoneWire.renderBlocks.blockAccess.getBlockId(x - 1, y + 1, z) == Block.wireRedstone.id) {
                tessellator.setColorOpaque_F(brightness * red, brightness * green, brightness * blue);
                tessellator.addVertexWithUV((float)x + 0.015625f, (float)(y + 1) + 0.021875f, z + 1, d3, d5);
                tessellator.addVertexWithUV((float)x + 0.015625f, y + 0, z + 1, d1, d5);
                tessellator.addVertexWithUV((float)x + 0.015625f, y + 0, z + 0, d1, d7);
                tessellator.addVertexWithUV((float)x + 0.015625f, (float)(y + 1) + 0.021875f, z + 0, d3, d7);
                tessellator.addVertexWithUV((float)x + 0.015625f, (float)(y + 1) + 0.021875f, z + 1, d3, d5 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV((float)x + 0.015625f, y + 0, z + 1, d1, d5 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV((float)x + 0.015625f, y + 0, z + 0, d1, d7 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV((float)x + 0.015625f, (float)(y + 1) + 0.021875f, z + 0, d3, d7 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            }
            if (BlockModelRedstoneWire.renderBlocks.blockAccess.isBlockNormalCube(x + 1, y, z) && BlockModelRedstoneWire.renderBlocks.blockAccess.getBlockId(x + 1, y + 1, z) == Block.wireRedstone.id) {
                tessellator.setColorOpaque_F(brightness * red, brightness * green, brightness * blue);
                tessellator.addVertexWithUV((float)(x + 1) - 0.015625f, y + 0, z + 1, d1, d7);
                tessellator.addVertexWithUV((float)(x + 1) - 0.015625f, (float)(y + 1) + 0.021875f, z + 1, d3, d7);
                tessellator.addVertexWithUV((float)(x + 1) - 0.015625f, (float)(y + 1) + 0.021875f, z + 0, d3, d5);
                tessellator.addVertexWithUV((float)(x + 1) - 0.015625f, y + 0, z + 0, d1, d5);
                tessellator.addVertexWithUV((float)(x + 1) - 0.015625f, y + 0, z + 1, d1, d7 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV((float)(x + 1) - 0.015625f, (float)(y + 1) + 0.021875f, z + 1, d3, d7 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV((float)(x + 1) - 0.015625f, (float)(y + 1) + 0.021875f, z + 0, d3, d5 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV((float)(x + 1) - 0.015625f, y + 0, z + 0, d1, d5 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            }
            if (BlockModelRedstoneWire.renderBlocks.blockAccess.isBlockNormalCube(x, y, z - 1) && BlockModelRedstoneWire.renderBlocks.blockAccess.getBlockId(x, y + 1, z - 1) == Block.wireRedstone.id) {
                tessellator.setColorOpaque_F(brightness * red, brightness * green, brightness * blue);
                tessellator.addVertexWithUV(x + 1, y + 0, (float)z + 0.015625f, d1, d7);
                tessellator.addVertexWithUV(x + 1, (float)(y + 1) + 0.021875f, (float)z + 0.015625f, d3, d7);
                tessellator.addVertexWithUV(x + 0, (float)(y + 1) + 0.021875f, (float)z + 0.015625f, d3, d5);
                tessellator.addVertexWithUV(x + 0, y + 0, (float)z + 0.015625f, d1, d5);
                tessellator.addVertexWithUV(x + 1, y + 0, (float)z + 0.015625f, d1, d7 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV(x + 1, (float)(y + 1) + 0.021875f, (float)z + 0.015625f, d3, d7 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV(x + 0, (float)(y + 1) + 0.021875f, (float)z + 0.015625f, d3, d5 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV(x + 0, y + 0, (float)z + 0.015625f, d1, d5 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            }
            if (BlockModelRedstoneWire.renderBlocks.blockAccess.isBlockNormalCube(x, y, z + 1) && BlockModelRedstoneWire.renderBlocks.blockAccess.getBlockId(x, y + 1, z + 1) == Block.wireRedstone.id) {
                tessellator.setColorOpaque_F(brightness * red, brightness * green, brightness * blue);
                tessellator.addVertexWithUV(x + 1, (float)(y + 1) + 0.021875f, (float)(z + 1) - 0.015625f, d3, d5);
                tessellator.addVertexWithUV(x + 1, y + 0, (float)(z + 1) - 0.015625f, d1, d5);
                tessellator.addVertexWithUV(x + 0, y + 0, (float)(z + 1) - 0.015625f, d1, d7);
                tessellator.addVertexWithUV(x + 0, (float)(y + 1) + 0.021875f, (float)(z + 1) - 0.015625f, d3, d7);
                tessellator.addVertexWithUV(x + 1, (float)(y + 1) + 0.021875f, (float)(z + 1) - 0.015625f, d3, d5 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV(x + 1, y + 0, (float)(z + 1) - 0.015625f, d1, d5 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV(x + 0, y + 0, (float)(z + 1) - 0.015625f, d1, d7 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
                tessellator.addVertexWithUV(x + 0, (float)(y + 1) + 0.021875f, (float)(z + 1) - 0.015625f, d3, d7 + (double)(TextureFX.tileWidthTerrain / (Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain)));
            }
        }
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }
}

