/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.block.model.BlockModelTorch;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockRedstoneRepeater;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class BlockModelRepeater
extends BlockModelStandard<BlockRedstoneRepeater> {
    private static final BlockModelTorch<Block> modelTorchActive = (BlockModelTorch)BlockModelDispatcher.getInstance().getDispatch(Block.torchRedstoneActive);
    private static final BlockModelTorch<Block> modelTorchIdle = (BlockModelTorch)BlockModelDispatcher.getInstance().getDispatch(Block.torchRedstoneIdle);

    public BlockModelRepeater(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        ((BlockRedstoneRepeater)this.block).setBlockBoundsBasedOnState(BlockModelRepeater.renderBlocks.world, x, y, z);
        int l = BlockModelRepeater.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        int i1 = l & 3;
        int j1 = (l & 0xC) >> 2;
        this.renderStandardBlock(tessellator, this.block, x, y, z);
        float f = this.getBlockBrightness(BlockModelRepeater.renderBlocks.blockAccess, x, y, z);
        if (Block.lightEmission[((BlockRedstoneRepeater)this.block).id] > 0) {
            f = (f + 1.0f) * 0.5f;
        }
        tessellator.setColorOpaque_F(f, f, f);
        double d = -0.1875;
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        switch (i1) {
            case 0: {
                d4 = -0.3125;
                d2 = BlockRedstoneRepeater.field_22024_a[j1];
                break;
            }
            case 2: {
                d4 = 0.3125;
                d2 = -BlockRedstoneRepeater.field_22024_a[j1];
                break;
            }
            case 3: {
                d3 = -0.3125;
                d1 = BlockRedstoneRepeater.field_22024_a[j1];
                break;
            }
            case 1: {
                d3 = 0.3125;
                d1 = -BlockRedstoneRepeater.field_22024_a[j1];
            }
        }
        BlockModelTorch<Block> modelTorch = ((BlockRedstoneRepeater)this.block).isRepeaterPowered ? modelTorchActive : modelTorchIdle;
        modelTorch.renderTorchAtAngle(tessellator, (double)x + d1, (double)y + d, (double)z + d2, 0.0, 0.0);
        modelTorch.renderTorchAtAngle(tessellator, (double)x + d3, (double)y + d, (double)z + d4, 0.0, 0.0);
        int k1 = this.getBlockTextureFromSideAndMetadata(Side.TOP, l);
        int l1 = k1 % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int i2 = k1 / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        double d5 = (float)l1 / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d6 = ((float)l1 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d7 = (float)i2 / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d8 = ((float)i2 + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        float f1 = 0.125f;
        float f2 = x + 1;
        float f3 = x + 1;
        float f4 = x + 0;
        float f5 = x + 0;
        float f6 = z + 0;
        float f7 = z + 1;
        float f8 = z + 1;
        float f9 = z + 0;
        float f10 = (float)y + f1;
        if (i1 == 2) {
            f2 = f3 = (float)(x + 0);
            f4 = f5 = (float)(x + 1);
            f6 = f9 = (float)(z + 1);
            f7 = f8 = (float)(z + 0);
        } else if (i1 == 3) {
            f2 = f5 = (float)(x + 0);
            f3 = f4 = (float)(x + 1);
            f6 = f7 = (float)(z + 0);
            f8 = f9 = (float)(z + 1);
        } else if (i1 == 1) {
            f2 = f5 = (float)(x + 1);
            f3 = f4 = (float)(x + 0);
            f6 = f7 = (float)(z + 1);
            f8 = f9 = (float)(z + 0);
        }
        tessellator.addVertexWithUV(f5, f10, f9, d5, d7);
        tessellator.addVertexWithUV(f4, f10, f8, d5, d8);
        tessellator.addVertexWithUV(f3, f10, f7, d6, d8);
        tessellator.addVertexWithUV(f2, f10, f6, d6, d7);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (side == Side.BOTTOM) {
            return !((BlockRedstoneRepeater)this.block).isRepeaterPowered ? BlockModelRepeater.texCoordToIndex(3, 7) : BlockModelRepeater.texCoordToIndex(3, 6);
        }
        if (side == Side.TOP) {
            return !((BlockRedstoneRepeater)this.block).isRepeaterPowered ? BlockModelRepeater.texCoordToIndex(3, 8) : BlockModelRepeater.texCoordToIndex(3, 9);
        }
        return BlockModelRepeater.texCoordToIndex(5, 0);
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side) {
        return side != 0 && side != 1;
    }
}

