/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockSpikes;
import net.minecraft.core.util.helper.Side;

public class BlockModelSpikes<T extends Block>
extends BlockModelStandard<T> {
    public BlockModelSpikes(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelSpikes.renderBlocks.world, x, y, z);
        int metaData = BlockModelSpikes.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        int j = this.getBlockTextureFromSideAndMetadata(Side.EAST, metaData);
        if (BlockModelSpikes.renderBlocks.overrideBlockTexture >= 0) {
            j = BlockModelSpikes.renderBlocks.overrideBlockTexture;
        }
        this.block.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
        this.renderStandardBlock(tessellator, this.block, x, y, z);
        if (BlockSpikes.isSpikesUp(metaData)) {
            float f = this.getBlockBrightness(BlockModelSpikes.renderBlocks.blockAccess, x, y, z);
            tessellator.setColorOpaque_F(f, f, f);
            int k = j % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
            int l = j / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
            double d3 = (float)k / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            double d4 = ((float)k + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            double d5 = (float)l / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            double d6 = ((float)l + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
            double d7 = (double)x + 0.5 - 0.25;
            double d8 = (double)x + 0.5 + 0.25;
            double d9 = (double)z + 0.5 - 0.5;
            double d10 = (double)z + 0.5 + 0.5;
            double mid = 0.25;
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 1.0, d9, d3, d5);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 0.0, d9, d3, d6);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 0.0, d10, d4, d6);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 1.0, d10, d4, d5);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 1.0, d10, d3, d5);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 0.0, d10, d3, d6);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 0.0, d9, d4, d6);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 1.0, d9, d4, d5);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 1.0, d9, d3, d5);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 0.0, d9, d3, d6);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 0.0, d10, d4, d6);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 1.0, d10, d4, d5);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 1.0, d10, d3, d5);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 0.0, d10, d3, d6);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 0.0, d9, d4, d6);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 1.0, d9, d4, d5);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 1.0, d10, d3, d5);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 0.0, d10, d3, d6);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 0.0, d9, d4, d6);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 1.0, d9, d4, d5);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 1.0, d9, d3, d5);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 0.0, d9, d3, d6);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 0.0, d10, d4, d6);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 1.0, d10, d4, d5);
            d7 = (double)x + 0.5 - 0.5;
            d8 = (double)x + 0.5 + 0.5;
            d9 = (double)z + 0.5 - 0.25;
            d10 = (double)z + 0.5 + 0.25;
            tessellator.addVertexWithUV(d7, (double)y + 1.0, d9 - 0.0625, d3, d5);
            tessellator.addVertexWithUV(d7, (double)y + 0.0, d9 - 0.0625, d3, d6);
            tessellator.addVertexWithUV(d8, (double)y + 0.0, d9 - 0.0625, d4, d6);
            tessellator.addVertexWithUV(d8, (double)y + 1.0, d9 - 0.0625, d4, d5);
            tessellator.addVertexWithUV(d8, (double)y + 1.0, d9 - 0.0625, d3, d5);
            tessellator.addVertexWithUV(d8, (double)y + 0.0, d9 - 0.0625, d3, d6);
            tessellator.addVertexWithUV(d7, (double)y + 0.0, d9 - 0.0625, d4, d6);
            tessellator.addVertexWithUV(d7, (double)y + 1.0, d9 - 0.0625, d4, d5);
            tessellator.addVertexWithUV(d7, (double)y + 1.0, d9 + mid, d3, d5);
            tessellator.addVertexWithUV(d7, (double)y + 0.0, d9 + mid, d3, d6);
            tessellator.addVertexWithUV(d8, (double)y + 0.0, d9 + mid, d4, d6);
            tessellator.addVertexWithUV(d8, (double)y + 1.0, d9 + mid, d4, d5);
            tessellator.addVertexWithUV(d8, (double)y + 1.0, d9 + mid, d3, d5);
            tessellator.addVertexWithUV(d8, (double)y + 0.0, d9 + mid, d3, d6);
            tessellator.addVertexWithUV(d7, (double)y + 0.0, d9 + mid, d4, d6);
            tessellator.addVertexWithUV(d7, (double)y + 1.0, d9 + mid, d4, d5);
            tessellator.addVertexWithUV(d8, (double)y + 1.0, d10 + 0.0625, d3, d5);
            tessellator.addVertexWithUV(d8, (double)y + 0.0, d10 + 0.0625, d3, d6);
            tessellator.addVertexWithUV(d7, (double)y + 0.0, d10 + 0.0625, d4, d6);
            tessellator.addVertexWithUV(d7, (double)y + 1.0, d10 + 0.0625, d4, d5);
            tessellator.addVertexWithUV(d7, (double)y + 1.0, d10 + 0.0625, d3, d5);
            tessellator.addVertexWithUV(d7, (double)y + 0.0, d10 + 0.0625, d3, d6);
            tessellator.addVertexWithUV(d8, (double)y + 0.0, d10 + 0.0625, d4, d6);
            tessellator.addVertexWithUV(d8, (double)y + 1.0, d10 + 0.0625, d4, d5);
        }
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public float getItemRenderScale() {
        return 0.5f;
    }
}

