/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.lwjgl.opengl.GL11;

public class BlockModelStandard<T extends Block>
extends BlockModel<T> {
    public int[] atlasIndices = new int[6];
    public double[] itemRenderBounds = null;
    public int overbrightTexture = -1;

    public BlockModelStandard(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelStandard.renderBlocks.world, x, y, z);
        return this.renderStandardBlock(tessellator, this.block, x, y, z);
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha) {
        if (BlockModelStandard.renderBlocks.useInventoryTint) {
            int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)alpha);
        } else {
            GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        }
        float yOffset = 0.5f;
        this.setBlockBoundsForItemRender();
        GL11.glTranslatef((float)-0.5f, (float)(0.0f - yOffset), (float)-0.5f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        this.renderBottomFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        this.renderTopFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.TOP, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        this.renderNorthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        this.renderSouthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        this.renderWestFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        this.renderEastFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
        tessellator.draw();
        if (this.hasOverbright()) {
            brightness = 1.0f;
            if (BlockModelStandard.renderBlocks.useInventoryTint) {
                int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)alpha);
            } else {
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
            }
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockOverbrightTextureFromSideAndMeta(Side.BOTTOM, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockOverbrightTextureFromSideAndMeta(Side.TOP, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderNorthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockOverbrightTextureFromSideAndMeta(Side.NORTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderSouthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockOverbrightTextureFromSideAndMeta(Side.SOUTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderWestFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockOverbrightTextureFromSideAndMeta(Side.WEST, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderEastFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockOverbrightTextureFromSideAndMeta(Side.EAST, metadata));
            tessellator.draw();
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    @Override
    public boolean shouldItemRender3d() {
        return true;
    }

    @Override
    public float getItemRenderScale() {
        return 0.25f;
    }

    @Override
    public int getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        return this.getBlockTextureFromSideAndMetadata(side, blockAccess.getBlockMetadata(x, y, z));
    }

    @Override
    public int getBlockOverbrightTexture(WorldSource blockAccess, int x, int y, int z, int side) {
        return this.getBlockOverbrightTextureFromSideAndMeta(Side.getSideById(side), blockAccess.getBlockMetadata(x, y, z));
    }

    @Override
    public int getBlockOverbrightTextureFromSideAndMeta(Side side, int data) {
        return this.overbrightTexture;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int data) {
        return this.atlasIndices[side.getId()];
    }

    @Override
    public int getParticleTexture(Side side, int meta) {
        return this.getBlockTextureFromSideAndMetadata(side, meta);
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side, int meta) {
        return this.shouldSideBeRendered(blockAccess, x, y, z, side);
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, int x, int y, int z, int side) {
        Side side1 = Side.getSideById(side);
        if (side1 == Side.BOTTOM && this.block.minY > 0.0) {
            return true;
        }
        if (side1 == Side.TOP && this.block.maxY < 1.0) {
            return true;
        }
        if (side1 == Side.NORTH && this.block.minZ > 0.0) {
            return true;
        }
        if (side1 == Side.SOUTH && this.block.maxZ < 1.0) {
            return true;
        }
        if (side1 == Side.WEST && this.block.minX > 0.0) {
            return true;
        }
        if (side1 == Side.EAST && this.block.maxX < 1.0) {
            return true;
        }
        return !blockAccess.isBlockOpaqueCube(x, y, z);
    }

    @Override
    public boolean shouldSideBeColored(WorldSource blockAccess, int x, int y, int z, int side, int meta) {
        return true;
    }

    @Override
    public void setBlockBoundsForItemRender() {
        if (this.itemRenderBounds != null) {
            this.block.setBlockBounds(this.itemRenderBounds[0], this.itemRenderBounds[1], this.itemRenderBounds[2], this.itemRenderBounds[3], this.itemRenderBounds[4], this.itemRenderBounds[5]);
        }
    }

    public BlockModelStandard<T> withCustomItemBounds(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.itemRenderBounds = new double[]{minX, minY, minZ, maxX, maxY, maxZ};
        return this;
    }

    public BlockModelStandard<T> withOverbrightCoords(int x, int y) {
        this.hasOverbright = true;
        this.overbrightTexture = BlockModelStandard.texCoordToIndex(x, y);
        return this;
    }

    public BlockModelStandard<T> withTexCoords(int x, int y) {
        return this.withTexCoords(x, y, x, y, x, y, x, y, x, y, x, y);
    }

    public BlockModelStandard<T> withTexCoords(int topBottomX, int topBottomY, int sidesX, int sidesY) {
        return this.withTexCoords(topBottomX, topBottomY, topBottomX, topBottomY, sidesX, sidesY, sidesX, sidesY, sidesX, sidesY, sidesX, sidesY);
    }

    public BlockModelStandard<T> withTexCoords(int topX, int topY, int bottomX, int bottomY, int sidesX, int sidesY) {
        return this.withTexCoords(topX, topY, bottomX, bottomY, sidesX, sidesY, sidesX, sidesY, sidesX, sidesY, sidesX, sidesY);
    }

    public BlockModelStandard<T> withTexCoords(int topX, int topY, int bottomX, int bottomY, int northX, int northY, int eastX, int eastY, int southX, int southY, int westX, int westY) {
        this.atlasIndices[Side.TOP.getId()] = BlockModelStandard.texCoordToIndex(topX, topY);
        this.atlasIndices[Side.BOTTOM.getId()] = BlockModelStandard.texCoordToIndex(bottomX, bottomY);
        this.atlasIndices[Side.NORTH.getId()] = BlockModelStandard.texCoordToIndex(northX, northY);
        this.atlasIndices[Side.EAST.getId()] = BlockModelStandard.texCoordToIndex(eastX, eastY);
        this.atlasIndices[Side.SOUTH.getId()] = BlockModelStandard.texCoordToIndex(southX, southY);
        this.atlasIndices[Side.WEST.getId()] = BlockModelStandard.texCoordToIndex(westX, westY);
        return this;
    }

    public static int texCoordToIndex(int x, int y) {
        return x + y * Global.TEXTURE_ATLAS_WIDTH_TILES;
    }
}

