/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;

public class BlockModelTorch<T extends Block>
extends BlockModelStandard<T> {
    public BlockModelTorch(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelTorch.renderBlocks.world, x, y, z);
        int l = BlockModelTorch.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        float f = this.getBlockBrightness(BlockModelTorch.renderBlocks.blockAccess, x, y, z);
        if (Block.lightEmission[this.block.id] > 0) {
            f = 1.0f;
        }
        tessellator.setColorOpaque_F(f, f, f);
        double d = 0.4f;
        double d1 = 0.5 - d;
        double d2 = 0.2f;
        if (l == 1) {
            this.renderTorchAtAngle(tessellator, (double)x - d1, (double)y + d2, z, -d, 0.0);
        } else if (l == 2) {
            this.renderTorchAtAngle(tessellator, (double)x + d1, (double)y + d2, z, d, 0.0);
        } else if (l == 3) {
            this.renderTorchAtAngle(tessellator, x, (double)y + d2, (double)z - d1, 0.0, -d);
        } else if (l == 4) {
            this.renderTorchAtAngle(tessellator, x, (double)y + d2, (double)z + d1, 0.0, d);
        } else {
            this.renderTorchAtAngle(tessellator, x, y, z, 0.0, 0.0);
        }
        return true;
    }

    public void renderTorchAtAngle(Tessellator tessellator, double x, double y, double z, double topOffsetX, double topOffsetZ) {
        int textureIndex = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, 0);
        if (BlockModelTorch.renderBlocks.overrideBlockTexture >= 0) {
            textureIndex = BlockModelTorch.renderBlocks.overrideBlockTexture;
        }
        int texCoordX = textureIndex % Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        int texCoordY = textureIndex / Global.TEXTURE_ATLAS_WIDTH_TILES * TextureFX.tileWidthTerrain;
        float minU = (float)texCoordX / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        float maxU = ((float)texCoordX + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        float minV = (float)texCoordY / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        float maxV = ((float)texCoordY + ((float)TextureFX.tileWidthTerrain - 0.01f)) / (float)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double topMinU = (double)minU + (double)TextureFX.tileWidthTerrain * 0.4375 / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double topMinV = (double)minV + (double)TextureFX.tileWidthTerrain * 0.375 / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double topMaxU = (double)minU + (double)TextureFX.tileWidthTerrain * 0.5625 / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double topMaxV = (double)minV + (double)TextureFX.tileWidthTerrain * 0.5 / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double bottomMinU = (double)minU + (double)TextureFX.tileWidthTerrain * 0.4375 / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double bottomMinV = (double)minV + (double)TextureFX.tileWidthTerrain * 0.875 / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double bottomMaxU = (double)minU + (double)TextureFX.tileWidthTerrain * 0.5625 / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double bottomMaxV = (double)minV + (double)TextureFX.tileWidthTerrain * 1.0 / (double)(TextureFX.tileWidthTerrain * Global.TEXTURE_ATLAS_WIDTH_TILES);
        double d9 = (x += 0.5) - 0.5;
        double d10 = x + 0.5;
        double d11 = (z += 0.5) - 0.5;
        double d12 = z + 0.5;
        double d13 = 0.0625;
        double d14 = 0.625;
        tessellator.addVertexWithUV(x - d13 + topOffsetX, y + 0.0, z + d13 + topOffsetZ, bottomMinU, bottomMaxV);
        tessellator.addVertexWithUV(x - d13 + topOffsetX, y + 0.0, z - d13 + topOffsetZ, bottomMinU, bottomMinV);
        tessellator.addVertexWithUV(x + topOffsetX + d13, y + 0.0, z - d13 + topOffsetZ, bottomMaxU, bottomMinV);
        tessellator.addVertexWithUV(x + topOffsetX + d13, y + 0.0, z + d13 + topOffsetZ, bottomMaxU, bottomMaxV);
        tessellator.addVertexWithUV(x + topOffsetX * (1.0 - d14) - d13, y + d14, z + topOffsetZ * (1.0 - d14) - d13, topMinU, topMinV);
        tessellator.addVertexWithUV(x + topOffsetX * (1.0 - d14) - d13, y + d14, z + topOffsetZ * (1.0 - d14) + d13, topMinU, topMaxV);
        tessellator.addVertexWithUV(x + topOffsetX * (1.0 - d14) + d13, y + d14, z + topOffsetZ * (1.0 - d14) + d13, topMaxU, topMaxV);
        tessellator.addVertexWithUV(x + topOffsetX * (1.0 - d14) + d13, y + d14, z + topOffsetZ * (1.0 - d14) - d13, topMaxU, topMinV);
        tessellator.addVertexWithUV(x - d13, y + 1.0, d11, minU, minV);
        tessellator.addVertexWithUV(x - d13 + topOffsetX, y + 0.0, d11 + topOffsetZ, minU, maxV);
        tessellator.addVertexWithUV(x - d13 + topOffsetX, y + 0.0, d12 + topOffsetZ, maxU, maxV);
        tessellator.addVertexWithUV(x - d13, y + 1.0, d12, maxU, minV);
        tessellator.addVertexWithUV(x + d13, y + 1.0, d12, minU, minV);
        tessellator.addVertexWithUV(x + topOffsetX + d13, y + 0.0, d12 + topOffsetZ, minU, maxV);
        tessellator.addVertexWithUV(x + topOffsetX + d13, y + 0.0, d11 + topOffsetZ, maxU, maxV);
        tessellator.addVertexWithUV(x + d13, y + 1.0, d11, maxU, minV);
        tessellator.addVertexWithUV(d9, y + 1.0, z + d13, minU, minV);
        tessellator.addVertexWithUV(d9 + topOffsetX, y + 0.0, z + d13 + topOffsetZ, minU, maxV);
        tessellator.addVertexWithUV(d10 + topOffsetX, y + 0.0, z + d13 + topOffsetZ, maxU, maxV);
        tessellator.addVertexWithUV(d10, y + 1.0, z + d13, maxU, minV);
        tessellator.addVertexWithUV(d10, y + 1.0, z - d13, minU, minV);
        tessellator.addVertexWithUV(d10 + topOffsetX, y + 0.0, z - d13 + topOffsetZ, minU, maxV);
        tessellator.addVertexWithUV(d9 + topOffsetX, y + 0.0, z - d13 + topOffsetZ, maxU, maxV);
        tessellator.addVertexWithUV(d9, y + 1.0, z - d13, maxU, minV);
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public float getItemRenderScale() {
        return 0.5f;
    }
}

