/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockTrapDoor;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;
import org.lwjgl.opengl.GL11;

public class BlockModelTrapDoor<T extends Block>
extends BlockModelStandard<T> {
    public BlockModelTrapDoor(Block block) {
        super(block);
        float offset = 0.1875f;
        this.withCustomItemBounds(0.0, 0.0, 0.0, 1.0, offset, 1.0);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        this.block.setBlockBoundsBasedOnState(BlockModelTrapDoor.renderBlocks.world, x, y, z);
        int metadata = BlockModelTrapDoor.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        boolean isUp = BlockTrapDoor.isTrapdoorOpen(metadata);
        if (isUp) {
            switch (metadata & 3) {
                case 0: {
                    BlockModelTrapDoor.renderBlocks.uvRotateNorth = 2;
                    BlockModelTrapDoor.renderBlocks.uvRotateSouth = 1;
                    break;
                }
                case 1: {
                    BlockModelTrapDoor.renderBlocks.uvRotateTop = 3;
                    BlockModelTrapDoor.renderBlocks.uvRotateBottom = 3;
                    BlockModelTrapDoor.renderBlocks.uvRotateNorth = 1;
                    BlockModelTrapDoor.renderBlocks.uvRotateSouth = 2;
                    break;
                }
                case 2: {
                    BlockModelTrapDoor.renderBlocks.uvRotateTop = 2;
                    BlockModelTrapDoor.renderBlocks.uvRotateBottom = 1;
                    BlockModelTrapDoor.renderBlocks.uvRotateEast = 1;
                    BlockModelTrapDoor.renderBlocks.uvRotateWest = 2;
                    break;
                }
                case 3: {
                    BlockModelTrapDoor.renderBlocks.uvRotateTop = 1;
                    BlockModelTrapDoor.renderBlocks.uvRotateBottom = 2;
                    BlockModelTrapDoor.renderBlocks.uvRotateEast = 2;
                    BlockModelTrapDoor.renderBlocks.uvRotateWest = 1;
                }
            }
        } else if (BlockTrapDoor.isUpperHalf(metadata)) {
            BlockModelTrapDoor.renderBlocks.uvRotateSouth = 3;
            BlockModelTrapDoor.renderBlocks.uvRotateNorth = 3;
            BlockModelTrapDoor.renderBlocks.uvRotateEast = 3;
            BlockModelTrapDoor.renderBlocks.uvRotateWest = 3;
        }
        this.renderStandardBlock(tessellator, this.block, x, y, z);
        this.resetRenderBlocks();
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha) {
        GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
        super.renderBlockOnInventory(tessellator, metadata, brightness, alpha);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int data) {
        int orientation = data & 3;
        if (BlockTrapDoor.isTrapdoorOpen(data)) {
            int index = Sides.orientationLookUpTrapdoorOpen[6 * orientation + side.getId()];
            return this.atlasIndices[index];
        }
        if (side.getAxis() == Axis.Y) {
            return this.atlasIndices[1];
        }
        return this.atlasIndices[3];
    }
}

