/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.dynamictexture.DynamicTexture;

public class DynamicTextureFire
extends DynamicTexture {
    protected float[] arr1;
    protected float[] arr2;
    private int height;
    private float scaleFactor;

    public DynamicTextureFire(int resolution) {
        super(BlockModelStandard.texCoordToIndex(15, 1), resolution, 1, 2);
        this.scaleFactor = (float)resolution / 16.0f;
        this.height = (int)(20.0f * this.scaleFactor);
        this.arr1 = new float[resolution * this.height];
        this.arr2 = new float[resolution * this.height];
    }

    @Override
    public void update() {
        for (int i = 0; i < this.resolution; ++i) {
            for (int j = 0; j < this.height; ++j) {
                int var3 = (int)(18.0f * this.scaleFactor);
                float bright = this.arr1[i + (j + 1) % this.height * this.resolution] * (float)var3;
                for (int k = i - 1; k <= i + 1; ++k) {
                    for (int l = j; l <= j + 1; ++l) {
                        if (k >= 0 && l >= 0 && k < this.resolution && l < this.height) {
                            bright += this.arr1[k + l * this.resolution];
                        }
                        ++var3;
                    }
                }
                this.arr2[i + j * this.resolution] = bright / ((float)var3 * (1.0f + 0.06f / this.scaleFactor));
                if (!((float)j >= 19.0f * this.scaleFactor)) continue;
                this.arr2[i + j * this.resolution] = (float)(Math.random() * Math.random() * Math.random() * 4.0 + Math.random() * 0.1 + 0.2);
            }
        }
        float[] var12 = this.arr2;
        this.arr2 = this.arr1;
        this.arr1 = var12;
        for (int i = 0; i < this.resolution * this.resolution; ++i) {
            float var13 = this.arr1[i] * 1.8f;
            if (var13 > 1.0f) {
                var13 = 1.0f;
            }
            if (var13 < 0.0f) {
                var13 = 0.0f;
            }
            int r = (int)(var13 * 155.0f + 100.0f);
            int g = (int)(var13 * var13 * 255.0f);
            int b = (int)(var13 * var13 * var13 * var13 * var13 * var13 * var13 * var13 * var13 * var13 * 255.0f);
            int a = 255;
            if (var13 < 0.5f) {
                a = 0;
            }
            if (this.anaglyphEnabled) {
                int var9 = (r * 30 + g * 59 + b * 11) / 100;
                int var10 = (r * 30 + g * 70) / 100;
                int var11 = (r * 30 + b * 70) / 100;
                r = var9;
                g = var10;
                b = var11;
            }
            this.imageData[i * 4 + 0] = (byte)r;
            this.imageData[i * 4 + 1] = (byte)g;
            this.imageData[i * 4 + 2] = (byte)b;
            this.imageData[i * 4 + 3] = (byte)a;
        }
    }

    @Override
    public String getTextureName() {
        return "/terrain.png";
    }
}

