/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.core.util.helper.MathHelper;

public class DynamicTextureLavaFlowing
extends DynamicTexture {
    private float[] arr1;
    private float[] arr2;
    private float[] arr3;
    private float[] arr4;
    private int ticks = 0;

    public DynamicTextureLavaFlowing(int resolution) {
        super(BlockModelStandard.texCoordToIndex(14, 14), resolution, 2);
        this.arr1 = new float[resolution * resolution];
        this.arr2 = new float[resolution * resolution];
        this.arr3 = new float[resolution * resolution];
        this.arr4 = new float[resolution * resolution];
    }

    @Override
    public void update() {
        int var9;
        int var8;
        int var7;
        int var6;
        int var5;
        float var3;
        int var2;
        ++this.ticks;
        for (int var1 = 0; var1 < this.resolution; ++var1) {
            for (var2 = 0; var2 < this.resolution; ++var2) {
                var3 = 0.0f;
                int var4 = (int)(MathHelper.sin((float)var2 * (float)Math.PI * 2.0f / (float)this.resolution) * 1.2f);
                var5 = (int)(MathHelper.sin((float)var1 * (float)Math.PI * 2.0f / (float)this.resolution) * 1.2f);
                for (var6 = var1 - 1; var6 <= var1 + 1; ++var6) {
                    for (var7 = var2 - 1; var7 <= var2 + 1; ++var7) {
                        var8 = DynamicTextureLavaFlowing.pmod(var6 + var4, this.resolution);
                        var9 = DynamicTextureLavaFlowing.pmod(var7 + var5, this.resolution);
                        var3 += this.arr1[var8 + var9 * this.resolution];
                    }
                }
                this.arr2[var1 + var2 * this.resolution] = var3 / 10.0f + (this.arr3[DynamicTextureLavaFlowing.pmod(var1 + 0, this.resolution) + DynamicTextureLavaFlowing.pmod(var2 + 0, this.resolution) * this.resolution] + this.arr3[DynamicTextureLavaFlowing.pmod(var1 + 1, this.resolution) + DynamicTextureLavaFlowing.pmod(var2 + 0, this.resolution) * this.resolution] + this.arr3[DynamicTextureLavaFlowing.pmod(var1 + 1, this.resolution) + DynamicTextureLavaFlowing.pmod(var2 + 1, this.resolution) * this.resolution] + this.arr3[DynamicTextureLavaFlowing.pmod(var1 + 0, this.resolution) + DynamicTextureLavaFlowing.pmod(var2 + 1, this.resolution) * this.resolution]) / 4.0f * 0.8f;
                int n = var1 + var2 * this.resolution;
                this.arr3[n] = this.arr3[n] + this.arr4[var1 + var2 * this.resolution] * 0.01f;
                if (this.arr3[var1 + var2 * this.resolution] < 0.0f) {
                    this.arr3[var1 + var2 * this.resolution] = 0.0f;
                }
                int n2 = var1 + var2 * this.resolution;
                this.arr4[n2] = this.arr4[n2] - 0.06f;
                if (!(Math.random() < 0.005)) continue;
                this.arr4[var1 + var2 * this.resolution] = 1.5f;
            }
        }
        float[] var11 = this.arr2;
        this.arr2 = this.arr1;
        this.arr1 = var11;
        for (var2 = 0; var2 < this.resolution * this.resolution; ++var2) {
            var3 = this.arr1[DynamicTextureLavaFlowing.pmod(var2 - this.ticks / 3 * this.resolution, this.resolution * this.resolution)] * 2.0f;
            if (var3 > 1.0f) {
                var3 = 1.0f;
            }
            if (var3 < 0.0f) {
                var3 = 0.0f;
            }
            var5 = (int)(var3 * 100.0f + 155.0f);
            var6 = (int)(var3 * var3 * 255.0f);
            var7 = (int)(var3 * var3 * var3 * var3 * 128.0f);
            if (this.anaglyphEnabled) {
                var8 = (var5 * 30 + var6 * 59 + var7 * 11) / 100;
                var9 = (var5 * 30 + var6 * 70) / 100;
                int var10 = (var5 * 30 + var7 * 70) / 100;
                var5 = var8;
                var6 = var9;
                var7 = var10;
            }
            this.imageData[var2 * 4 + 0] = (byte)var5;
            this.imageData[var2 * 4 + 1] = (byte)var6;
            this.imageData[var2 * 4 + 2] = (byte)var7;
            this.imageData[var2 * 4 + 3] = -1;
        }
    }

    @Override
    public String getTextureName() {
        return "/terrain.png";
    }
}

