/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.core.util.helper.MathHelper;

public class DynamicTextureLavaStill
extends DynamicTexture {
    private float[] arr1;
    private float[] arr2;
    private float[] arr3;
    private float[] arr4;

    public DynamicTextureLavaStill(int resolution) {
        super(BlockModelStandard.texCoordToIndex(13, 14), resolution, 1);
        this.arr1 = new float[resolution * resolution];
        this.arr2 = new float[resolution * resolution];
        this.arr3 = new float[resolution * resolution];
        this.arr4 = new float[resolution * resolution];
    }

    @Override
    public void update() {
        int var9;
        int var8;
        int b;
        int g;
        float var3;
        int i;
        for (i = 0; i < this.resolution; ++i) {
            for (int j = 0; j < this.resolution; ++j) {
                var3 = 0.0f;
                int x2 = (int)(MathHelper.sin((float)j * (float)Math.PI * 2.0f / (float)this.resolution) * 1.2f);
                int y2 = (int)(MathHelper.sin((float)i * (float)Math.PI * 2.0f / (float)this.resolution) * 1.2f);
                for (g = i - 1; g <= i + 1; ++g) {
                    for (b = j - 1; b <= j + 1; ++b) {
                        var8 = DynamicTextureLavaStill.pmod(g + x2, this.resolution);
                        var9 = DynamicTextureLavaStill.pmod(b + y2, this.resolution);
                        var3 += this.arr1[var8 + var9 * this.resolution];
                    }
                }
                this.arr2[i + j * this.resolution] = var3 / 10.0f + (this.arr3[DynamicTextureLavaStill.pmod(i + 0, this.resolution) + DynamicTextureLavaStill.pmod(j + 0, this.resolution) * this.resolution] + this.arr3[DynamicTextureLavaStill.pmod(i + 1, this.resolution) + DynamicTextureLavaStill.pmod(j + 0, this.resolution) * this.resolution] + this.arr3[DynamicTextureLavaStill.pmod(i + 1, this.resolution) + DynamicTextureLavaStill.pmod(j + 1, this.resolution) * this.resolution] + this.arr3[DynamicTextureLavaStill.pmod(i + 0, this.resolution) + DynamicTextureLavaStill.pmod(j + 1, this.resolution) * this.resolution]) / 4.0f * 0.8f;
                int n = i + j * this.resolution;
                this.arr3[n] = this.arr3[n] + this.arr4[i + j * this.resolution] * 0.01f;
                if (this.arr3[i + j * this.resolution] < 0.0f) {
                    this.arr3[i + j * this.resolution] = 0.0f;
                }
                int n2 = i + j * this.resolution;
                this.arr4[n2] = this.arr4[n2] - 0.06f;
                if (!(Math.random() < 0.005)) continue;
                this.arr4[i + j * this.resolution] = 1.5f;
            }
        }
        float[] var11 = this.arr2;
        this.arr2 = this.arr1;
        this.arr1 = var11;
        for (i = 0; i < this.resolution * this.resolution; ++i) {
            var3 = this.arr1[i] * 2.0f;
            if (var3 > 1.0f) {
                var3 = 1.0f;
            }
            if (var3 < 0.0f) {
                var3 = 0.0f;
            }
            int r = (int)(var3 * 100.0f + 155.0f);
            g = (int)(var3 * var3 * 255.0f);
            b = (int)(var3 * var3 * var3 * var3 * 128.0f);
            if (this.anaglyphEnabled) {
                var8 = (r * 30 + g * 59 + b * 11) / 100;
                var9 = (r * 30 + g * 70) / 100;
                int var10 = (r * 30 + b * 70) / 100;
                r = var8;
                g = var9;
                b = var10;
            }
            this.imageData[i * 4 + 0] = (byte)r;
            this.imageData[i * 4 + 1] = (byte)g;
            this.imageData[i * 4 + 2] = (byte)b;
            this.imageData[i * 4 + 3] = -1;
        }
    }

    @Override
    public String getTextureName() {
        return "/terrain.png";
    }
}

