/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.dynamictexture.DynamicTextureRotating;
import net.minecraft.client.util.helper.Textures;

public class DynamicTextureTrommel
extends DynamicTextureRotating {
    private boolean counterClockwise;
    private double rotation = 0.0;
    private double speed = 0.12;

    public DynamicTextureTrommel(Minecraft minecraft, int textureIndex, int resolution, boolean counterClockwise) {
        super(minecraft, "/terrain.png", textureIndex, resolution);
        int y;
        int x;
        this.counterClockwise = counterClockwise;
        BufferedImage bufferedimage = Textures.readImage(minecraft.texturePackList.selectedTexturePack.getResourceAsStream("/terrain.png"));
        this.dialImageData = new byte[resolution * resolution * 4];
        for (x = 0; x < resolution; ++x) {
            for (y = 0; y < resolution; ++y) {
                DynamicTextureTrommel.putPixel(this.dialImageData, y * resolution + x, bufferedimage.getRGB(resolution * 2 + x, resolution * 9 + y));
            }
        }
        this.clockImageData = new byte[resolution * resolution * 4];
        for (x = 0; x < resolution; ++x) {
            for (y = 0; y < resolution; ++y) {
                DynamicTextureTrommel.putPixel(this.clockImageData, y * resolution + x, bufferedimage.getRGB(resolution * 1 + x, resolution * 9 + y));
            }
        }
        this.dialTexRes = resolution;
    }

    @Override
    public double getAngle() {
        return 0.0;
    }

    @Override
    public void updateAngle() {
        if (this.counterClockwise) {
            this.rotation -= this.speed;
            if (this.rotation < 0.0) {
                this.rotation += Math.PI * 2;
            }
        } else {
            this.rotation += this.speed;
            if (this.rotation > Math.PI * 2) {
                this.rotation -= Math.PI * 2;
            }
        }
        this.angleFinal = this.rotation;
    }

    @Override
    public String getTextureName() {
        return "/terrain.png";
    }
}

