/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.fx.EntityFireflyFX;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.client.render.tessalator.TessellatorStandard;
import net.minecraft.core.entity.animal.EntityFireflyCluster;
import org.lwjgl.opengl.GL11;

public class FireflyRenderer
extends EntityRenderer<EntityFireflyCluster> {
    private final List<EntityFireflyFX> fireflies = new ArrayList<EntityFireflyFX>();
    private final Minecraft mc;
    private final Random rand = new Random(0L);
    private long lastTick;

    public FireflyRenderer() {
        for (int i = 0; i < 20; ++i) {
            EntityFireflyFX fx = new EntityFireflyFX(null, this.rand.nextFloat() - 0.5f, this.rand.nextFloat() - 0.5f, 0.0, 0.0, 0.0, 0.0, 0);
            fx.noPhysics = true;
            fx.setParticleAge(this.rand.nextInt(20));
            this.fireflies.add(fx);
        }
        this.mc = Minecraft.getMinecraft(this);
        this.lastTick = System.currentTimeMillis();
    }

    @Override
    public void doRender(Tessellator tessellator, EntityFireflyCluster parent, double x, double y, double z, float yaw, float partialTick) {
    }

    @Override
    public void doRenderPreview(Tessellator tessellator, EntityFireflyCluster entity, double x, double y, double z, float yaw, float partialTick) {
        int i;
        super.doRenderPreview(tessellator, entity, x, y, z, yaw, partialTick);
        long currentTick = System.currentTimeMillis();
        int storedTicks = (int)((float)(currentTick - this.lastTick) / 50.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.75f, (float)0.0f);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3553);
        Lighting.disable();
        GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/particles.png"));
        for (i = 0; i < this.fireflies.size(); ++i) {
            EntityFireflyFX firefly = this.fireflies.get(i);
            TessellatorStandard t = TessellatorStandard.instance;
            t.startDrawingQuads();
            firefly.renderParticleInGUI(t, partialTick);
            t.draw();
            for (int j = 0; j < storedTicks; ++j) {
                firefly.tickGUI();
                this.lastTick = currentTick;
            }
            if (!firefly.removed) continue;
            this.fireflies.remove(i);
            --i;
        }
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        if (this.fireflies.size() < 20) {
            for (i = this.fireflies.size(); i < 20; ++i) {
                if (this.rand.nextInt(4) == 0) continue;
                EntityFireflyFX fx = new EntityFireflyFX(null, this.rand.nextFloat() - 0.5f, this.rand.nextFloat() - 0.5f, 0.0, 0.0, 0.0, 0.0, 0);
                fx.noPhysics = true;
                fx.setParticleAge(this.rand.nextInt(20));
                this.fireflies.add(fx);
            }
        }
    }
}

