/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import java.util.Random;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.client.render.tessalator.TessellatorStandard;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class ItemEntityRenderer
extends EntityRenderer<EntityItem> {
    private final RenderBlocks renderBlocks = new RenderBlocks();
    private final Random random = new Random();
    public boolean useColor = true;

    public ItemEntityRenderer() {
        this.shadowSize = 0.15f;
        this.shadowOpacity = 0.75f;
    }

    @Override
    public void doRender(Tessellator tessellator, EntityItem entity, double x, double y, double z, float yaw, float partialTick) {
        this.random.setSeed(187L);
        ItemStack itemstack = entity.item;
        if (itemstack == null) {
            return;
        }
        Item item = itemstack.getItem();
        if (item == null) {
            return;
        }
        GL11.glPushMatrix();
        float bobbingOffset = MathHelper.sin(((float)entity.age + partialTick) / 10.0f + entity.field_804_d) * 0.1f + 0.1f;
        float f3 = (float)Math.toDegrees(((float)entity.age + partialTick) / 20.0f + entity.field_804_d);
        int renderCount = 1;
        if (entity.item.stackSize > 1) {
            renderCount = 2;
        }
        if (entity.item.stackSize > 5) {
            renderCount = 3;
        }
        if (entity.item.stackSize > 20) {
            renderCount = 4;
        }
        GL11.glTranslatef((float)((float)x), (float)((float)y + bobbingOffset), (float)((float)z));
        GL11.glEnable((int)32826);
        ((ItemModel)ItemModelDispatcher.getInstance().getDispatch(item)).renderAsItemEntity(TessellatorStandard.instance, entity, this.renderBlocks, this.random, itemstack, renderCount, f3, partialTick);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }
}

