/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.client.render.model.ModelMinecart;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.client.render.tessalator.TessellatorStandard;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3d;
import org.lwjgl.opengl.GL11;

public class MinecartRenderer
extends EntityRenderer<EntityMinecart> {
    protected ModelBase modelMinecart;

    public MinecartRenderer() {
        this.shadowSize = 0.5f;
        this.modelMinecart = new ModelMinecart();
    }

    public void renderMinecart(EntityMinecart minecart, double d, double d1, double d2, float f, float f1) {
        GL11.glPushMatrix();
        TessellatorStandard tessellator = TessellatorStandard.instance;
        double d3 = minecart.xOld + (minecart.x - minecart.xOld) * (double)f1;
        double d4 = minecart.yOld + (minecart.y - minecart.yOld) * (double)f1;
        double d5 = minecart.zOld + (minecart.z - minecart.zOld) * (double)f1;
        double d6 = 0.3f;
        Vec3d vec3d = minecart.func_514_g(d3, d4, d5);
        float f2 = minecart.xRotO + (minecart.xRot - minecart.xRotO) * f1;
        if (vec3d != null) {
            Vec3d vec3d1 = minecart.func_515_a(d3, d4, d5, d6);
            Vec3d vec3d2 = minecart.func_515_a(d3, d4, d5, -d6);
            if (vec3d1 == null) {
                vec3d1 = vec3d;
            }
            if (vec3d2 == null) {
                vec3d2 = vec3d;
            }
            d += vec3d.xCoord - d3;
            d1 += (vec3d1.yCoord + vec3d2.yCoord) / 2.0 - d4;
            d2 += vec3d.zCoord - d5;
            Vec3d vec3d3 = vec3d2.addVector(-vec3d1.xCoord, -vec3d1.yCoord, -vec3d1.zCoord);
            if (vec3d3.lengthVector() != 0.0) {
                vec3d3 = vec3d3.normalize();
                f = (float)(Math.atan2(vec3d3.zCoord, vec3d3.xCoord) * 180.0 / Math.PI);
                f2 = (float)(Math.atan(vec3d3.yCoord) * 73.0);
            }
        }
        GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)((float)d2));
        GL11.glRotatef((float)(180.0f - f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-f2), (float)0.0f, (float)0.0f, (float)1.0f);
        float f3 = (float)minecart.minecartTimeSinceHit - f1;
        float f4 = (float)minecart.minecartCurrentDamage - f1;
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        if (f3 > 0.0f) {
            GL11.glRotatef((float)(MathHelper.sin(f3) * f3 * f4 / 10.0f * (float)minecart.minecartRockDirection), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (minecart.minecartType != 0) {
            this.loadTexture("/terrain.png");
            float f5 = 0.75f;
            GL11.glScalef((float)f5, (float)f5, (float)f5);
            GL11.glTranslatef((float)0.0f, (float)0.3125f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            float brightness = minecart.getBrightness(f1);
            if (Minecraft.getMinecraft((Object)this).fullbright) {
                brightness = 1.0f;
            }
            if (minecart.minecartType == 1) {
                ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.chestPlanksOak)).renderBlockOnInventory(tessellator, 0, brightness);
            } else if (minecart.minecartType == 2) {
                if (minecart.fuel > 0) {
                    ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.furnaceStoneActive)).renderBlockOnInventory(tessellator, 0, brightness);
                } else {
                    ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.furnaceStoneIdle)).renderBlockOnInventory(tessellator, 0, brightness);
                }
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.3125f, (float)0.0f);
            GL11.glScalef((float)(1.0f / f5), (float)(1.0f / f5), (float)(1.0f / f5));
        }
        this.loadTexture("/item/cart.png");
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.modelMinecart.render(0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
    }

    @Override
    public void doRender(Tessellator tessellator, EntityMinecart entity, double x, double y, double z, float yaw, float partialTick) {
        this.renderMinecart(entity, x, y, z, yaw, partialTick);
    }
}

