/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.EntityPlayerSP;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.PlayerSkinParser;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.camera.EntityCamera;
import net.minecraft.client.render.entity.LivingRenderer;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.client.render.model.ModelPlayer;
import net.minecraft.client.render.model.ModelPlayerSlim;
import net.minecraft.client.render.model.ModelSign;
import net.minecraft.client.render.tessalator.TessellatorStandard;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemArmor;
import net.minecraft.core.item.ItemQuiver;
import net.minecraft.core.item.ItemQuiverEndless;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class PlayerRenderer
extends LivingRenderer<EntityPlayer> {
    private ModelBiped modelBipedMain;
    private final ModelPlayer modelThick;
    private final ModelPlayer modelSlim;
    private final ModelBiped modelArmorChestplate;
    private final ModelBiped modelArmor;
    private final ModelSign modelSign;

    public PlayerRenderer() {
        super(new ModelPlayer(0.0f), 0.5f);
        this.modelBipedMain = (ModelBiped)this.mainModel;
        this.modelArmorChestplate = new ModelBiped(1.0f);
        this.modelArmor = new ModelBiped(0.5f);
        this.modelSign = new ModelSign();
        this.modelThick = new ModelPlayer(0.0f);
        this.modelSlim = new ModelPlayerSlim(0.0f);
    }

    protected boolean setArmorModel(EntityPlayer entity, int renderPass, float partialTick) {
        ItemStack itemstack = entity.inventory.armorItemInSlot(3 - renderPass);
        if (itemstack != null) {
            Item item = itemstack.getItem();
            if (item instanceof ItemQuiver) {
                this.loadTexture("/armor/quiver.png");
                ModelBiped modelbiped = this.modelArmorChestplate;
                modelbiped.bipedBody.showModel = renderPass == 1 || renderPass == 2;
                this.setRenderPassModel(modelbiped);
                return true;
            }
            if (item instanceof ItemQuiverEndless) {
                this.loadTexture("/armor/quiver_golden.png");
                ModelBiped modelbiped = this.modelArmorChestplate;
                modelbiped.bipedBody.showModel = renderPass == 1 || renderPass == 2;
                this.setRenderPassModel(modelbiped);
                return true;
            }
            if (item == Item.armorBootsIceskates) {
                this.loadTexture("/armor/skates.png");
                ModelBiped modelbiped = this.modelArmorChestplate;
                modelbiped.bipedRightLeg.showModel = renderPass == 2 || renderPass == 3;
                modelbiped.bipedLeftLeg.showModel = renderPass == 2 || renderPass == 3;
                this.setRenderPassModel(modelbiped);
                return true;
            }
            if (item instanceof ItemArmor) {
                ItemArmor itemarmor = (ItemArmor)item;
                this.loadTexture("/armor/" + itemarmor.material.name + "_" + (renderPass != 2 ? 1 : 2) + ".png");
                ModelBiped modelbiped = renderPass != 2 ? this.modelArmorChestplate : this.modelArmor;
                modelbiped.bipedHead.showModel = renderPass == 0;
                modelbiped.bipedHeadOverlay.showModel = renderPass == 0;
                modelbiped.bipedBody.showModel = renderPass == 1 || renderPass == 2;
                modelbiped.bipedRightArm.showModel = renderPass == 1;
                modelbiped.bipedLeftArm.showModel = renderPass == 1;
                modelbiped.bipedRightLeg.showModel = renderPass == 2 || renderPass == 3;
                modelbiped.bipedLeftLeg.showModel = renderPass == 2 || renderPass == 3;
                this.setRenderPassModel(modelbiped);
                return true;
            }
        }
        return false;
    }

    public void renderPlayer(EntityPlayer entity, double d, double d1, double d2, float yaw, float partialTick) {
    }

    protected void renderName(EntityPlayer entity, double d, double d1, double d2) {
        if (Minecraft.getMinecraft((Object)this).gameSettings.immersiveMode.drawNames() && this.renderDispatcher.camera != null) {
            float f3;
            if (this.renderDispatcher.camera instanceof EntityCamera && ((EntityCamera)this.renderDispatcher.camera).entity == entity) {
                return;
            }
            float f = 1.6f;
            float f1 = 0.01666667f * f;
            float f2 = (float)this.renderDispatcher.camera.distanceTo(entity);
            float f4 = f3 = entity.isSneaking() ? 32.0f : 64.0f;
            if (f2 < f3) {
                String s = entity.getDisplayName();
                if (!entity.isSneaking()) {
                    if (entity.isPlayerSleeping()) {
                        this.renderLivingLabel(entity, s, d, d1 - 1.5, d2, 64, false);
                    } else {
                        this.renderLivingLabel(entity, s, d, d1, d2, 64, false);
                    }
                } else {
                    FontRenderer fontrenderer = this.getFontRenderer();
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)((float)d + 0.0f), (float)((float)d1 + 2.3f), (float)((float)d2));
                    GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(-this.renderDispatcher.viewLerpYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)this.renderDispatcher.viewLerpPitch, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
                    GL11.glDisable((int)2896);
                    GL11.glTranslatef((float)0.0f, (float)(0.25f / f1), (float)0.0f);
                    GL11.glDepthMask((boolean)false);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    TessellatorStandard tessellator = TessellatorStandard.instance;
                    GL11.glDisable((int)3553);
                    tessellator.startDrawingQuads();
                    int i = fontrenderer.getStringWidth(s) / 2;
                    tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
                    tessellator.addVertex(-i - 1, -1.0, 0.0);
                    tessellator.addVertex(-i - 1, 8.0, 0.0);
                    tessellator.addVertex(i + 1, 8.0, 0.0);
                    tessellator.addVertex(i + 1, -1.0, 0.0);
                    tessellator.draw();
                    GL11.glEnable((int)3553);
                    GL11.glDepthMask((boolean)true);
                    fontrenderer.drawString(s, -fontrenderer.getStringWidth(s) / 2, 0, 0x20FFFFFF);
                    GL11.glEnable((int)2896);
                    GL11.glDisable((int)3042);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPopMatrix();
                }
            }
        }
    }

    protected void renderSpecials(EntityPlayer entity, float f) {
        ItemStack itemstack1;
        boolean renderCape;
        ItemStack itemstack = entity.inventory.armorItemInSlot(3);
        if (itemstack != null && itemstack.getItem().id < Block.blocksList.length) {
            GL11.glPushMatrix();
            this.modelBipedMain.bipedHead.postRender(0.0625f);
            if (((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemstack.itemID])).shouldItemRender3d()) {
                float f1 = 0.625f;
                GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)f1, (float)(-f1), (float)f1);
            }
            ItemModelDispatcher.getInstance().getDispatch(itemstack).renderItem(TessellatorStandard.instance, this.renderDispatcher.itemRenderer, entity, itemstack);
            GL11.glPopMatrix();
        }
        if (!(renderCape = this.loadDownloadableTexture("https://api.betterthanadventure.net/capes?username=" + entity.username, null, null))) {
            renderCape = this.loadDownloadableTexture(entity.capeURL, null, null);
        }
        if (renderCape) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
            double d = entity.field_20066_r + (entity.field_20063_u - entity.field_20066_r) * (double)f - (entity.xo + (entity.x - entity.xo) * (double)f);
            double d1 = entity.field_20065_s + (entity.field_20062_v - entity.field_20065_s) * (double)f - (entity.yo + (entity.y - entity.yo) * (double)f);
            double d2 = entity.field_20064_t + (entity.field_20061_w - entity.field_20064_t) * (double)f - (entity.zo + (entity.z - entity.zo) * (double)f);
            float f8 = entity.prevRenderYawOffset + (entity.renderYawOffset - entity.prevRenderYawOffset) * f;
            double d3 = MathHelper.sin(f8 * 3.141593f / 180.0f);
            double d4 = -MathHelper.cos(f8 * 3.141593f / 180.0f);
            float f9 = (float)d1 * 10.0f;
            if (f9 < -6.0f) {
                f9 = -6.0f;
            }
            if (f9 > 32.0f) {
                f9 = 32.0f;
            }
            float f10 = (float)(d * d3 + d2 * d4) * 100.0f;
            float f11 = (float)(d * d4 - d2 * d3) * 100.0f;
            if (f10 < 0.0f) {
                f10 = 0.0f;
            }
            float f12 = entity.field_775_e + (entity.field_774_f - entity.field_775_e) * f;
            f9 += MathHelper.sin((entity.walkDistO + (entity.walkDist - entity.walkDistO) * f) * 6.0f) * 32.0f * f12;
            if (entity.isSneaking()) {
                f9 += 25.0f;
            }
            GL11.glRotatef((float)(6.0f + f10 / 2.0f + f9), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(f11 / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-f11 / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.modelBipedMain.renderCloak(0.0625f);
            GL11.glPopMatrix();
        }
        if ((itemstack1 = entity.inventory.getCurrentItem()) != null) {
            GL11.glPushMatrix();
            this.modelBipedMain.bipedRightArm.postRender(0.0625f);
            BlockModel.setRenderBlocks(this.renderDispatcher.itemRenderer.renderBlocksInstance);
            ItemModelDispatcher.getInstance().getDispatch(itemstack1).renderItemThirdPerson(TessellatorStandard.instance, this.renderDispatcher.itemRenderer, entity, itemstack1, true);
            GL11.glPopMatrix();
        }
    }

    protected void func_186_b(EntityPlayer entity, float f) {
        float f1 = 0.9375f;
        GL11.glScalef((float)f1, (float)f1, (float)f1);
    }

    public void drawFirstPersonHand(EntityPlayer player) {
        this.mainModel = player.slimModel ? this.modelSlim : this.modelThick;
        this.modelBipedMain = player.slimModel ? this.modelSlim : this.modelThick;
        this.modelBipedMain.onGround = 0.0f;
        this.modelBipedMain.isRiding = false;
        this.modelBipedMain.setRotationAngles(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        this.modelBipedMain.bipedRightArm.render(0.0625f);
        if (this.modelBipedMain instanceof ModelPlayer) {
            ((ModelPlayer)this.modelBipedMain).bipedRightArmOverlay.render(0.0625f);
        }
    }

    protected void func_22016_b(EntityPlayer entity, double d, double d1, double d2) {
        if (entity.isAlive() && entity.isPlayerSleeping()) {
            super.translateModel(entity, d + (double)entity.field_22063_x, d1 + (double)entity.field_22062_y, d2 + (double)entity.field_22061_z);
        } else {
            super.translateModel(entity, d, d1, d2);
        }
    }

    protected void func_22017_a(EntityPlayer entity, float f, float f1, float f2) {
        if (entity.isAlive() && entity.isPlayerSleeping()) {
            GL11.glRotatef((float)entity.getBedOrientationInDegrees(), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.getDeathMaxRotation(entity), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            super.rotateModel(entity, f, f1, f2);
        }
    }

    @Override
    protected void passSpecialRender(EntityPlayer entity, double d, double d1, double d2) {
        this.renderName(entity, d, d1, d2);
    }

    @Override
    protected void preRenderCallback(EntityPlayer entity, float f) {
        this.func_186_b(entity, f);
        if (entity.isDwarf()) {
            GL11.glScalef((float)0.6f, (float)0.5f, (float)0.6f);
        }
    }

    @Override
    protected boolean shouldRenderPass(EntityPlayer entity, int renderPass, float partialTick) {
        return this.setArmorModel(entity, renderPass, partialTick);
    }

    @Override
    protected void renderEquippedItems(EntityPlayer entity, float f) {
        this.renderSpecials(entity, f);
    }

    @Override
    protected void rotateModel(EntityPlayer entity, float ticksExisted, float headYawOffset, float partialTick) {
        this.func_22017_a(entity, ticksExisted, headYawOffset, partialTick);
    }

    @Override
    protected void translateModel(EntityPlayer entity, double x, double y, double z) {
        this.func_22016_b(entity, x, y, z);
    }

    @Override
    public void render(EntityPlayer entity, double x, double y, double z, float yaw, float partialTick) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.mainModel = entity.slimModel ? this.modelSlim : this.modelThick;
        this.modelBipedMain = entity.slimModel ? this.modelSlim : this.modelThick;
        ItemStack itemstack = entity.inventory.getCurrentItem();
        this.modelBipedMain.field_1278_i = itemstack != null;
        this.modelArmor.field_1278_i = this.modelBipedMain.field_1278_i;
        this.modelArmorChestplate.field_1278_i = this.modelBipedMain.field_1278_i;
        this.modelArmor.isSneak = this.modelBipedMain.isSneak = entity.isSneaking();
        this.modelArmorChestplate.isSneak = this.modelBipedMain.isSneak;
        this.modelArmor.isRiding = this.modelBipedMain.isRiding = entity.isPassenger();
        this.modelArmorChestplate.isRiding = this.modelBipedMain.isRiding;
        double d3 = y - (double)entity.heightOffset;
        if (entity.isSneaking() && !(entity instanceof EntityPlayerSP)) {
            d3 -= 0.125;
        }
        super.render(entity, x, d3, z, yaw, partialTick);
        this.modelBipedMain.isSneak = false;
        this.modelArmor.isSneak = false;
        this.modelArmorChestplate.isSneak = false;
        this.modelBipedMain.field_1278_i = false;
        this.modelArmor.field_1278_i = false;
        this.modelArmorChestplate.field_1278_i = false;
        GL11.glDisable((int)3042);
    }

    @Override
    public void loadEntityTexture(EntityPlayer entity) {
        this.loadDownloadableTexture(entity.skinURL, entity.getEntityTexture(), PlayerSkinParser.instance);
    }
}

