/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.item.Item;
import org.lwjgl.opengl.GL11;

public class SnowballRenderer
extends EntityRenderer<Entity> {
    private int itemIconIndex;

    public SnowballRenderer(Item item) {
        this(((ItemModel)ItemModelDispatcher.getInstance().getDispatch(item)).getIconIndex(null, item.getDefaultStack()));
    }

    public SnowballRenderer(int i) {
        this.itemIconIndex = i;
    }

    @Override
    public void doRender(Tessellator tessellator, Entity entity, double x, double y, double z, float yaw, float partialTick) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glEnable((int)32826);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        this.loadTexture("/gui/items.png");
        float f2 = (float)(this.itemIconIndex % Global.TEXTURE_ATLAS_WIDTH_TILES) / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f3 = f2 + 1.0f / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f4 = (float)(this.itemIconIndex / Global.TEXTURE_ATLAS_WIDTH_TILES) / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f5 = f4 + 1.0f / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f6 = 1.0f;
        float f7 = 0.5f;
        float f8 = 0.25f;
        GL11.glRotatef((float)(180.0f - this.renderDispatcher.viewLerpYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.renderDispatcher.viewLerpPitch), (float)1.0f, (float)0.0f, (float)0.0f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        tessellator.addVertexWithUV(0.0f - f7, 0.0f - f8, 0.0, f2, f5);
        tessellator.addVertexWithUV(f6 - f7, 0.0f - f8, 0.0, f3, f5);
        tessellator.addVertexWithUV(f6 - f7, 1.0f - f8, 0.0, f3, f4);
        tessellator.addVertexWithUV(0.0f - f7, 1.0f - f8, 0.0, f2, f4);
        tessellator.draw();
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }
}

