/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.item.model.ItemModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import org.lwjgl.opengl.GL11;

public class ItemModelBlock
extends ItemModelStandard {
    private Block block;
    private BlockModel<Block> blockModel;

    public ItemModelBlock(ItemBlock itemBlock) {
        super(itemBlock);
        this.block = itemBlock.getBlock();
        this.blockModel = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(this.block);
        this.iconIndex = this.blockModel.getBlockTextureFromSideAndMetadata(Side.NORTH, 0);
    }

    @Override
    public void renderItemFirstPerson(Tessellator tessellator, ItemRenderer renderer, EntityPlayer player, ItemStack stack, float partialTick) {
        float distanceScale = 0.8f;
        float swingProgress = player.getSwingProgress(partialTick);
        float animationProgress2 = MathHelper.sin(swingProgress * (float)Math.PI);
        float animationProgress = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI);
        GL11.glTranslatef((float)(-animationProgress * 0.4f), (float)(MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI * 2.0f) * 0.2f), (float)(-animationProgress2 * 0.2f));
        GL11.glTranslatef((float)0.56f, (float)(-0.52f - (1.0f - renderer.getEquippedProgress(partialTick)) * 0.6f), (float)-0.71999997f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)32826);
        float animationProgress3 = MathHelper.sin(swingProgress * swingProgress * (float)Math.PI);
        GL11.glRotatef((float)(-animationProgress3 * 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-animationProgress * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(-animationProgress * 80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float scale = 0.4f;
        GL11.glScalef((float)0.4f, (float)0.4f, (float)0.4f);
        if (this.blockModel.shouldItemRender3d()) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.renderItem(tessellator, renderer, player, stack, true);
    }

    @Override
    public void renderItem(Tessellator tessellator, ItemRenderer renderer, Entity entity, ItemStack itemstack, boolean handheldTransform) {
        if (((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemstack.itemID])).shouldItemRender3d()) {
            Minecraft mc = Minecraft.getMinecraft(this);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/terrain.png"));
            float brightness = entity.getBrightness(1.0f);
            if (mc.fullbright || this.itemfullBright) {
                brightness = 1.0f;
            }
            ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemstack.itemID])).renderBlockOnInventory(tessellator, itemstack.getMetadata(), brightness);
            GL11.glDisable((int)3042);
        } else {
            super.renderItem(tessellator, renderer, entity, itemstack, handheldTransform);
        }
    }

    @Override
    public void heldTransformThirdPerson(ItemRenderer renderer, Entity entity, ItemStack itemStack) {
        if (itemStack.itemID < Block.blocksList.length && ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemStack.itemID])).shouldItemRender3d()) {
            float scale = 0.375f;
            GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
            GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)0.375f, (float)-0.375f, (float)0.375f);
        } else {
            super.heldTransformThirdPerson(renderer, entity, itemStack);
        }
    }

    @Override
    public void renderItemIntoGui(Tessellator tessellator, FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemStack, int x, int y, float brightness, float alpha) {
        if (itemStack == null) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2884);
        if (((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemStack.itemID])).shouldItemRender3d()) {
            GL11.glBlendFunc((int)770, (int)771);
            renderengine.bindTexture(renderengine.getTexture("/terrain.png"));
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x - 2), (float)(y + 3), (float)-3.0f);
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (this.useColor) {
                int color = this.getColor(itemStack);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)alpha);
            } else {
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            BlockModel.renderBlocks.useInventoryTint = this.useColor;
            ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemStack.itemID])).renderBlockOnInventory(tessellator, itemStack.getMetadata(), brightness, alpha);
            BlockModel.renderBlocks.useInventoryTint = true;
            GL11.glPopMatrix();
        } else {
            super.renderItemIntoGui(tessellator, fontrenderer, renderengine, itemStack, x, y, brightness, alpha);
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    @Override
    public void renderAsItemEntity(Tessellator tessellator, EntityItem entity, RenderBlocks renderBlocks, Random random, ItemStack itemstack, int renderCount, float yaw, float partialTick) {
        EntityRenderDispatcher renderDispatcher = EntityRenderDispatcher.instance;
        if (Block.blocksList[itemstack.itemID] != null && ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(Block.blocksList[itemstack.itemID])).shouldItemRender3d()) {
            GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            renderDispatcher.renderEngine.bindTexture(renderDispatcher.renderEngine.getTexture("/terrain.png"));
            BlockModel.setRenderBlocks(renderBlocks);
            float itemSize = this.blockModel.getItemRenderScale();
            GL11.glScalef((float)itemSize, (float)itemSize, (float)itemSize);
            for (int i = 0; i < renderCount; ++i) {
                GL11.glPushMatrix();
                if (i > 0) {
                    float rOffX = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / itemSize;
                    float rOffY = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / itemSize;
                    float rOffZ = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / itemSize;
                    GL11.glTranslatef((float)rOffX, (float)rOffY, (float)rOffZ);
                }
                float brightness = entity.getBrightness(partialTick);
                if (Minecraft.getMinecraft((Object)this).fullbright || this.itemfullBright) {
                    brightness = 1.0f;
                }
                this.blockModel.renderBlockOnInventory(tessellator, itemstack.getMetadata(), brightness);
                GL11.glPopMatrix();
            }
        } else {
            super.renderAsItemEntity(tessellator, entity, renderBlocks, random, itemstack, renderCount, yaw, partialTick);
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(stack.getMetadata());
    }
}

