/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.item.model.ItemModelStandard;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ItemModelDidgeridoo
extends ItemModelStandard {
    public ItemModelDidgeridoo(Item item) {
        super(item);
        this.bFull3D = true;
    }

    @Override
    public void renderItemIntoGui(Tessellator tessellator, FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemStack, int x, int y, float brightness, float alpha) {
        if (itemStack == null) {
            return;
        }
        Minecraft mc = Minecraft.getMinecraft(this);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2884);
        int textureIndex = this.getIconIndex(mc.thePlayer, itemStack);
        if (textureIndex >= 0) {
            int tileLength;
            GL11.glDisable((int)2896);
            if (itemStack.itemID < Block.blocksList.length) {
                renderengine.bindTexture(renderengine.getTexture("/terrain.png"));
                tileLength = TextureFX.tileWidthTerrain;
            } else {
                renderengine.bindTexture(renderengine.getTexture("/gui/items.png"));
                tileLength = TextureFX.tileWidthItems;
            }
            if (this.useColor) {
                int color = this.getColor(itemStack);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)alpha);
            } else {
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
            }
            this.renderTexturedDidgeridoo(tessellator, x - 4, y - 4, textureIndex % Global.TEXTURE_ATLAS_WIDTH_TILES * tileLength, textureIndex / Global.TEXTURE_ATLAS_WIDTH_TILES * tileLength, 16, 16);
            GL11.glEnable((int)2896);
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    private void renderTexturedDidgeridoo(Tessellator tessellator, int x, int y, int tileX, int tileY, int tileWidth, int tileHeight) {
        float z = 0.0f;
        float u = 1.0f / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
        float v = 1.0f / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * tileHeight);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x, y + 24, 0.0, (float)tileX * u, (float)(tileY + 24) * v);
        tessellator.addVertexWithUV(x + 24, y + 24, 0.0, (float)(tileX + 24) * u, (float)(tileY + 24) * v);
        tessellator.addVertexWithUV(x + 24, y, 0.0, (float)(tileX + 24) * u, (float)tileY * v);
        tessellator.addVertexWithUV(x, y, 0.0, (float)tileX * u, (float)tileY * v);
        tessellator.draw();
    }

    @Override
    public void renderItem(Tessellator tessellator, ItemRenderer renderer, Entity entity, ItemStack itemstack, boolean handheldTransform) {
        float y;
        float v;
        float x;
        float u;
        float texProgress;
        int i;
        int tileWidth;
        Minecraft mc = Minecraft.getMinecraft(Minecraft.class);
        if (this.item.id < Block.blocksList.length) {
            GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/terrain.png"));
            tileWidth = TextureFX.tileWidthTerrain;
        } else {
            GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/gui/items.png"));
            tileWidth = TextureFX.tileWidthItems;
        }
        float brightness = entity.getBrightness(1.0f);
        if (mc.fullbright || this.itemfullBright) {
            brightness = 1.0f;
        }
        if (this.useColor) {
            int color = this.getColor(itemstack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)1.0f);
        } else {
            GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        }
        int atlasSizePx = Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth;
        int tex = this.getIconIndex(entity, itemstack);
        float uMin = ((float)(tex % Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth) + 0.0f) / (float)atlasSizePx;
        float uMax = ((float)(tex % Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth) + ((float)tileWidth - 0.01f) + (float)(tileWidth / 2)) / (float)atlasSizePx;
        float vMin = ((float)(tex / Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth) + 0.0f) / (float)atlasSizePx;
        float vMax = ((float)(tex / Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth) + ((float)tileWidth - 0.01f) + (float)(tileWidth / 2)) / (float)atlasSizePx;
        float uDiff = uMin - uMax;
        float vDiff = vMin - vMax;
        float width = 1.0f;
        float foon = 0.5f / (float)atlasSizePx;
        float goon = 0.0625f * (16.0f / (float)tileWidth) - 0.020833334f;
        GL11.glEnable((int)32826);
        if (handheldTransform) {
            GL11.glTranslatef((float)-0.0f, (float)-0.3f, (float)0.0f);
            float handheldScale = 2.0f;
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.9375f, (float)-0.0625f, (float)0.0f);
        }
        float thickness = 1.0f / ((float)tileWidth * 1.5f);
        float pixelWidth = 1.0f / ((float)tileWidth * 1.5f);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, uMax, vMax);
        tessellator.addVertexWithUV(1.0, 0.0, 0.0, uMin, vMax);
        tessellator.addVertexWithUV(1.0, 1.0, 0.0, uMin, vMin);
        tessellator.addVertexWithUV(0.0, 1.0, 0.0, uMax, vMin);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        tessellator.addVertexWithUV(0.0, 1.0, -thickness, uMax, vMin);
        tessellator.addVertexWithUV(1.0, 1.0, -thickness, uMin, vMin);
        tessellator.addVertexWithUV(1.0, 0.0, -thickness, uMin, vMax);
        tessellator.addVertexWithUV(0.0, 0.0, -thickness, uMax, vMax);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        for (i = 0; i < tileWidth; ++i) {
            texProgress = (float)i * pixelWidth;
            u = uMax + uDiff * texProgress - foon;
            x = 1.0f * texProgress;
            tessellator.addVertexWithUV(x, 0.0, -thickness, u, vMax);
            tessellator.addVertexWithUV(x, 0.0, 0.0, u, vMax);
            tessellator.addVertexWithUV(x, 1.0, 0.0, u, vMin);
            tessellator.addVertexWithUV(x, 1.0, -thickness, u, vMin);
        }
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        for (i = 0; i < tileWidth; ++i) {
            texProgress = (float)i * pixelWidth;
            u = uMax + uDiff * texProgress - foon;
            x = 1.0f * texProgress + goon;
            tessellator.addVertexWithUV(x, 1.0, -thickness, u, vMin);
            tessellator.addVertexWithUV(x, 1.0, 0.0, u, vMin);
            tessellator.addVertexWithUV(x, 0.0, 0.0, u, vMax);
            tessellator.addVertexWithUV(x, 0.0, -thickness, u, vMax);
        }
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        for (i = 0; i < tileWidth; ++i) {
            texProgress = (float)i * pixelWidth;
            v = vMax + vDiff * texProgress - foon;
            y = 1.0f * texProgress + goon;
            tessellator.addVertexWithUV(0.0, y, 0.0, uMax, v);
            tessellator.addVertexWithUV(1.0, y, 0.0, uMin, v);
            tessellator.addVertexWithUV(1.0, y, -thickness, uMin, v);
            tessellator.addVertexWithUV(0.0, y, -thickness, uMax, v);
        }
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        for (i = 0; i < tileWidth; ++i) {
            texProgress = (float)i * pixelWidth;
            v = vMax + vDiff * texProgress - foon;
            y = 1.0f * texProgress;
            tessellator.addVertexWithUV(1.0, y, 0.0, uMin, v);
            tessellator.addVertexWithUV(0.0, y, 0.0, uMax, v);
            tessellator.addVertexWithUV(0.0, y, -thickness, uMax, v);
            tessellator.addVertexWithUV(1.0, y, -thickness, uMin, v);
        }
        tessellator.draw();
        GL11.glDisable((int)32826);
    }

    @Override
    public void heldTransformThirdPerson(ItemRenderer renderer, Entity entity, ItemStack itemStack) {
        float scale = 0.625f;
        GL11.glTranslatef((float)0.0f, (float)0.5f, (float)-1.0f);
        GL11.glScalef((float)0.625f, (float)-0.625f, (float)0.625f);
        GL11.glRotatef((float)15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
    }
}

