/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.item.model;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.client.render.TextureFX;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.tessalator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class ItemModelStandard
extends ItemModel {
    protected boolean useColor = true;
    public int iconIndex;
    protected boolean bFull3D = false;
    protected boolean rotateWhenRendering = false;
    protected boolean pointInfrontOfPlayer = false;
    protected boolean itemfullBright = false;

    public ItemModelStandard(Item item) {
        super(item);
    }

    @Override
    public void renderItemFirstPerson(Tessellator tessellator, ItemRenderer renderer, EntityPlayer player, ItemStack stack, float partialTick) {
        float distanceScale = 0.8f;
        float swingProgress = player.getSwingProgress(partialTick);
        float animationProgress2 = MathHelper.sin(swingProgress * (float)Math.PI);
        float animationProgress = MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI);
        GL11.glTranslatef((float)(-animationProgress * 0.4f), (float)(MathHelper.sin(MathHelper.sqrt_float(swingProgress) * (float)Math.PI * 2.0f) * 0.2f), (float)(-animationProgress2 * 0.2f));
        GL11.glTranslatef((float)0.56f, (float)(-0.52f - (1.0f - renderer.getEquippedProgress(partialTick)) * 0.6f), (float)-0.71999997f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)32826);
        float animationProgress3 = MathHelper.sin(swingProgress * swingProgress * (float)Math.PI);
        GL11.glRotatef((float)(-animationProgress3 * 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-animationProgress * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(-animationProgress * 80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float scale = 0.4f;
        GL11.glScalef((float)0.4f, (float)0.4f, (float)0.4f);
        this.heldTransformFirstPerson(renderer, player, stack);
        this.renderItem(tessellator, renderer, player, stack, true);
    }

    @Override
    public void renderItem(Tessellator tessellator, ItemRenderer renderer, Entity entity, ItemStack itemstack, boolean handheldTransform) {
        float y;
        float v;
        float x;
        float u;
        float texProgress;
        int i;
        int tileWidth;
        Minecraft mc = Minecraft.getMinecraft(Minecraft.class);
        if (this.item.id < Block.blocksList.length) {
            GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/terrain.png"));
            tileWidth = TextureFX.tileWidthTerrain;
        } else {
            GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/gui/items.png"));
            tileWidth = TextureFX.tileWidthItems;
        }
        float brightness = entity.getBrightness(1.0f);
        if (mc.fullbright || this.itemfullBright) {
            brightness = 1.0f;
        }
        if (this.useColor) {
            int color = this.getColor(itemstack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)1.0f);
        } else {
            GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        }
        int atlasSizePx = Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth;
        int tex = this.getIconIndex(entity, itemstack);
        float uMin = ((float)(tex % Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth) + 0.0f) / (float)atlasSizePx;
        float uMax = ((float)(tex % Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth) + ((float)tileWidth - 0.01f)) / (float)atlasSizePx;
        float vMin = ((float)(tex / Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth) + 0.0f) / (float)atlasSizePx;
        float vMax = ((float)(tex / Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth) + ((float)tileWidth - 0.01f)) / (float)atlasSizePx;
        float uDiff = uMin - uMax;
        float vDiff = vMin - vMax;
        float width = 1.0f;
        float foon = 0.5f / (float)atlasSizePx;
        float goon = 0.0625f * (16.0f / (float)tileWidth);
        GL11.glEnable((int)32826);
        if (handheldTransform) {
            GL11.glTranslatef((float)-0.0f, (float)-0.3f, (float)0.0f);
            float handheldScale = 1.5f;
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.9375f, (float)-0.0625f, (float)0.0f);
        }
        float thickness = 0.0625f;
        float pixelWidth = 1.0f / (float)tileWidth;
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, uMax, vMax);
        tessellator.addVertexWithUV(1.0, 0.0, 0.0, uMin, vMax);
        tessellator.addVertexWithUV(1.0, 1.0, 0.0, uMin, vMin);
        tessellator.addVertexWithUV(0.0, 1.0, 0.0, uMax, vMin);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        tessellator.addVertexWithUV(0.0, 1.0, -0.0625, uMax, vMin);
        tessellator.addVertexWithUV(1.0, 1.0, -0.0625, uMin, vMin);
        tessellator.addVertexWithUV(1.0, 0.0, -0.0625, uMin, vMax);
        tessellator.addVertexWithUV(0.0, 0.0, -0.0625, uMax, vMax);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        for (i = 0; i < tileWidth; ++i) {
            texProgress = (float)i * pixelWidth;
            u = uMax + uDiff * texProgress - foon;
            x = 1.0f * texProgress;
            tessellator.addVertexWithUV(x, 0.0, -0.0625, u, vMax);
            tessellator.addVertexWithUV(x, 0.0, 0.0, u, vMax);
            tessellator.addVertexWithUV(x, 1.0, 0.0, u, vMin);
            tessellator.addVertexWithUV(x, 1.0, -0.0625, u, vMin);
        }
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        for (i = 0; i < tileWidth; ++i) {
            texProgress = (float)i * pixelWidth;
            u = uMax + uDiff * texProgress - foon;
            x = 1.0f * texProgress + goon;
            tessellator.addVertexWithUV(x, 1.0, -0.0625, u, vMin);
            tessellator.addVertexWithUV(x, 1.0, 0.0, u, vMin);
            tessellator.addVertexWithUV(x, 0.0, 0.0, u, vMax);
            tessellator.addVertexWithUV(x, 0.0, -0.0625, u, vMax);
        }
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        for (i = 0; i < tileWidth; ++i) {
            texProgress = (float)i * pixelWidth;
            v = vMax + vDiff * texProgress - foon;
            y = 1.0f * texProgress + goon;
            tessellator.addVertexWithUV(0.0, y, 0.0, uMax, v);
            tessellator.addVertexWithUV(1.0, y, 0.0, uMin, v);
            tessellator.addVertexWithUV(1.0, y, -0.0625, uMin, v);
            tessellator.addVertexWithUV(0.0, y, -0.0625, uMax, v);
        }
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        for (i = 0; i < tileWidth; ++i) {
            texProgress = (float)i * pixelWidth;
            v = vMax + vDiff * texProgress - foon;
            y = 1.0f * texProgress;
            tessellator.addVertexWithUV(1.0, y, 0.0, uMin, v);
            tessellator.addVertexWithUV(0.0, y, 0.0, uMax, v);
            tessellator.addVertexWithUV(0.0, y, -0.0625, uMax, v);
            tessellator.addVertexWithUV(1.0, y, -0.0625, uMin, v);
        }
        tessellator.draw();
        GL11.glDisable((int)32826);
    }

    @Override
    public void renderItemThirdPerson(Tessellator tessellator, ItemRenderer renderer, Entity entity, ItemStack itemstack, boolean handheldTransform) {
        GL11.glTranslatef((float)-0.0625f, (float)0.4375f, (float)0.0625f);
        this.heldTransformThirdPerson(renderer, entity, itemstack);
        this.renderItem(tessellator, renderer, entity, itemstack, handheldTransform);
    }

    @Override
    public void renderItemIntoGui(Tessellator tessellator, FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemStack, int x, int y, float brightness, float alpha) {
        if (itemStack == null) {
            return;
        }
        Minecraft mc = Minecraft.getMinecraft(this);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2884);
        int textureIndex = this.getIconIndex(mc.thePlayer, itemStack);
        if (textureIndex >= 0) {
            int tileLength;
            GL11.glDisable((int)2896);
            if (itemStack.itemID < Block.blocksList.length) {
                renderengine.bindTexture(renderengine.getTexture("/terrain.png"));
                tileLength = TextureFX.tileWidthTerrain;
            } else {
                renderengine.bindTexture(renderengine.getTexture("/gui/items.png"));
                tileLength = TextureFX.tileWidthItems;
            }
            if (this.useColor) {
                int color = this.getColor(itemStack);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)alpha);
            } else {
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
            }
            this.renderTexturedQuad(tessellator, x, y, textureIndex % Global.TEXTURE_ATLAS_WIDTH_TILES * tileLength, textureIndex / Global.TEXTURE_ATLAS_WIDTH_TILES * tileLength, tileLength, tileLength);
            GL11.glEnable((int)2896);
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
    }

    @Override
    public void renderItemOverlayIntoGUI(Tessellator tessellator, FontRenderer fontrenderer, RenderEngine renderengine, ItemStack itemstack, int x, int y, String override, float alpha) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (itemstack == null) {
            return;
        }
        int a = (int)(alpha * 255.0f);
        if (itemstack.stackSize != 1 || override != null) {
            String s = override != null ? override : "" + itemstack.stackSize;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            fontrenderer.drawStringWithShadow(s, x + 19 - 2 - fontrenderer.getStringWidth(s), y + 6 + 3, 0xFFFFFF | a << 24);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
        }
        if (itemstack.isItemDamaged() || itemstack.getItem().showFullDurability()) {
            int barWidth = (int)Math.round(13.0 - (double)itemstack.getItemDamageForDisplay() * 13.0 / (double)itemstack.getMaxDamage());
            int l = (int)Math.round(255.0 - (double)itemstack.getItemDamageForDisplay() * 255.0 / (double)itemstack.getMaxDamage());
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glDisable((int)3553);
            int colorFG = 255 - l << 16 | l << 8;
            int colorBG = (255 - l) / 4 << 16 | 0x3F00;
            this.renderColoredQuad(tessellator, x + 2, y + 13, 13, 2, 0, a);
            this.renderColoredQuad(tessellator, x + 2, y + 13, 12, 1, colorBG, a);
            this.renderColoredQuad(tessellator, x + 2, y + 13, barWidth, 1, colorFG, a);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glDisable((int)3042);
    }

    @Override
    public void renderAsItemEntity(Tessellator tessellator, EntityItem entity, RenderBlocks renderBlocks, Random random, ItemStack itemstack, int renderCount, float yaw, float partialTick) {
        int i;
        int tileWidth;
        Minecraft mc = Minecraft.getMinecraft(this);
        EntityRenderDispatcher renderDispatcher = EntityRenderDispatcher.instance;
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        int tex = this.getIconIndex(entity, itemstack);
        if (this.item.id < Block.blocksList.length) {
            renderDispatcher.renderEngine.bindTexture(renderDispatcher.renderEngine.getTexture("/terrain.png"));
            tileWidth = TextureFX.tileWidthTerrain;
        } else {
            renderDispatcher.renderEngine.bindTexture(renderDispatcher.renderEngine.getTexture("/gui/items.png"));
            tileWidth = TextureFX.tileWidthItems;
        }
        float brightness = entity.getBrightness(partialTick);
        if (mc.fullbright || this.itemfullBright) {
            brightness = 1.0f;
        }
        if (this.useColor) {
            int color = this.getColor(itemstack);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)(r * brightness), (float)(g * brightness), (float)(b * brightness), (float)1.0f);
        } else {
            GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        }
        if (((Boolean)mc.gameSettings.items3D.value).booleanValue()) {
            GL11.glPushMatrix();
            GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
            GL11.glRotated((double)yaw, (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-0.5, (double)0.0, (double)(-0.05 * (double)(renderCount - 1)));
            for (i = 0; i < renderCount; ++i) {
                GL11.glPushMatrix();
                GL11.glTranslated((double)0.0, (double)0.0, (double)(0.1 * (double)i));
                this.renderItem(tessellator, renderDispatcher.itemRenderer, entity, itemstack, false);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        } else {
            for (i = 0; i < renderCount; ++i) {
                GL11.glPushMatrix();
                if (i > 0) {
                    float rOffX = (random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float rOffY = (random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    float rOffZ = (random.nextFloat() * 2.0f - 1.0f) * 0.3f;
                    GL11.glTranslatef((float)rOffX, (float)rOffY, (float)rOffZ);
                }
                GL11.glRotatef((float)(180.0f - renderDispatcher.viewLerpYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                this.renderFlat(tessellator, tex, tileWidth);
                GL11.glPopMatrix();
            }
        }
    }

    public void renderFlat(Tessellator tessellator, int index, int tileWidth) {
        float atlasSize = Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth;
        float uMin = (float)(index % Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth) / atlasSize;
        float uMax = (float)(index % Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth + tileWidth) / atlasSize;
        float vMin = (float)(index / Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth) / atlasSize;
        float vMax = (float)(index / Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth + tileWidth) / atlasSize;
        float xOff = 0.5f;
        float yOff = 0.25f;
        float z = 0.0f;
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        tessellator.addVertexWithUV(-0.5, -0.25, 0.0, uMin, vMax);
        tessellator.addVertexWithUV(0.5, -0.25, 0.0, uMax, vMax);
        tessellator.addVertexWithUV(0.5, 0.75, 0.0, uMax, vMin);
        tessellator.addVertexWithUV(-0.5, 0.75, 0.0, uMin, vMin);
        tessellator.draw();
    }

    public void heldTransformThirdPerson(ItemRenderer renderer, Entity entity, ItemStack itemStack) {
        if (this.bFull3D) {
            float scale = 0.625f;
            if (this.rotateWhenRendering) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
            }
            if (this.pointInfrontOfPlayer) {
                GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.0f);
            GL11.glScalef((float)0.625f, (float)-0.625f, (float)0.625f);
            GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            float scale = 0.375f;
            GL11.glTranslatef((float)0.25f, (float)0.1875f, (float)-0.1875f);
            GL11.glScalef((float)0.375f, (float)0.375f, (float)0.375f);
            GL11.glRotatef((float)60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    public void heldTransformFirstPerson(ItemRenderer renderer, Entity entity, ItemStack itemStack) {
        if (this.rotateWhenRendering) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (this.pointInfrontOfPlayer) {
            GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    @Override
    public int getIconIndex(Entity entity, ItemStack itemStack) {
        return this.iconIndex;
    }

    public int getColor(ItemStack stack) {
        return this.getColorFromMeta(stack.getMetadata());
    }

    public int getColorFromMeta(int meta) {
        return 0xFFFFFF;
    }

    protected void renderColoredQuad(Tessellator tessellator, int x, int y, int width, int height, int colorRGB, int alpha) {
        float z = 0.0f;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_I(colorRGB, alpha);
        tessellator.addVertex(x, y, 0.0);
        tessellator.addVertex(x, y + height, 0.0);
        tessellator.addVertex(x + width, y + height, 0.0);
        tessellator.addVertex(x + width, y, 0.0);
        tessellator.draw();
    }

    protected void renderTexturedQuad(Tessellator tessellator, int x, int y, int tileX, int tileY, int tileWidth, int tileHeight) {
        float z = 0.0f;
        float u = 1.0f / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * tileWidth);
        float v = 1.0f / (float)(Global.TEXTURE_ATLAS_WIDTH_TILES * tileHeight);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(x, y + 16, 0.0, (float)tileX * u, (float)(tileY + tileHeight) * v);
        tessellator.addVertexWithUV(x + 16, y + 16, 0.0, (float)(tileX + tileWidth) * u, (float)(tileY + tileHeight) * v);
        tessellator.addVertexWithUV(x + 16, y, 0.0, (float)(tileX + tileWidth) * u, (float)tileY * v);
        tessellator.addVertexWithUV(x, y, 0.0, (float)tileX * u, (float)tileY * v);
        tessellator.draw();
    }

    public static int iconCoordToIndex(int x, int y) {
        return x + y * Global.TEXTURE_ATLAS_WIDTH_TILES;
    }

    public ItemModelStandard setIconCoord(int x, int y) {
        this.iconIndex = ItemModelStandard.iconCoordToIndex(x, y);
        return this;
    }

    public ItemModelStandard setFull3D() {
        this.bFull3D = true;
        return this;
    }

    public ItemModelStandard setRotateWhenRendering() {
        this.rotateWhenRendering = true;
        return this;
    }

    public ItemModelStandard setPointInfrontOfPlayer() {
        this.pointInfrontOfPlayer = true;
        return this;
    }

    public ItemModelStandard setFullBright() {
        this.itemfullBright = true;
        return this;
    }
}

