/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texturepack;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.render.texturepack.TexturePackCustom;
import net.minecraft.client.render.texturepack.TexturePackDefault;

public class TexturePackList {
    private List<TexturePack> availableTexturePacks = new ArrayList<TexturePack>();
    private final TexturePack defaultTexturePack = new TexturePackDefault();
    public TexturePack selectedTexturePack;
    private final Map<String, TexturePack> texturePackIDs = new HashMap<String, TexturePack>();
    private final Minecraft mc;
    private final File texturePackDir;
    private String currentTexturePackName;

    public TexturePackList(Minecraft minecraft, File file) {
        this.mc = minecraft;
        this.texturePackDir = new File(file, "texturepacks");
        if (!this.texturePackDir.exists()) {
            this.texturePackDir.mkdirs();
        }
        this.currentTexturePackName = (String)minecraft.gameSettings.skin.value;
        this.updateAvailableTexturePacks();
    }

    public void setTexturePack(TexturePack newPack) {
        if (newPack != this.selectedTexturePack) {
            this.selectedTexturePack.closeTexturePackFile();
            this.currentTexturePackName = newPack.fileName;
            this.selectedTexturePack = newPack;
            this.mc.gameSettings.skin.value = this.currentTexturePackName;
            this.mc.gameSettings.saveOptions();
            this.selectedTexturePack.readZipFile();
            this.mc.fontRenderer = new FontRenderer(this.mc.gameSettings, "/font/default.png", this.mc.renderEngine);
            this.mc.renderEngine.refreshTexturesAndDisplayErrors();
            this.mc.renderGlobal.loadRenderers();
            this.mc.currentScreen.refreshFontRenderer();
            this.mc.renderEngine.updateDynamicTextures();
        }
    }

    public boolean updateAvailableTexturePacks() {
        File[] filesInDir;
        ArrayList<TexturePack> currentTexturePacks = new ArrayList<TexturePack>();
        this.selectedTexturePack = null;
        currentTexturePacks.add(this.defaultTexturePack);
        boolean update = false;
        if (this.texturePackDir.exists() && this.texturePackDir.isDirectory() && (filesInDir = this.texturePackDir.listFiles()) != null) {
            for (File file : filesInDir) {
                if (!this.isTexturePack(file)) continue;
                String id = this.getTexturePackID(file);
                try {
                    TexturePack pack;
                    if (!this.texturePackIDs.containsKey(id)) {
                        pack = new TexturePackCustom(file);
                        pack.packId = id;
                        pack.readZipFile();
                        pack.readTexturePackManifest();
                        this.texturePackIDs.put(id, pack);
                        update = true;
                    }
                    pack = this.texturePackIDs.get(id);
                    if (pack.fileName.equals(this.currentTexturePackName)) {
                        this.selectedTexturePack = pack;
                    }
                    currentTexturePacks.add(pack);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.selectedTexturePack == null) {
            this.selectedTexturePack = this.defaultTexturePack;
        }
        List<TexturePack> previousTexturePacks = this.availableTexturePacks;
        previousTexturePacks.removeAll(currentTexturePacks);
        if (previousTexturePacks.size() > 0) {
            update = true;
        }
        for (TexturePack texturePack : previousTexturePacks) {
            texturePack.disposeOfTexturePack(this.mc);
            this.texturePackIDs.remove(texturePack.packId);
        }
        this.availableTexturePacks = currentTexturePacks;
        return update;
    }

    private String getTexturePackID(File file) {
        if (file.isFile()) {
            return file.getName() + ":" + file.length() + ":" + file.lastModified();
        }
        File manifestFile = new File(file, "manifest.json");
        File packPngFile = new File(file, "pack.png");
        return file.getName() + ":" + manifestFile.length() + ":" + manifestFile.lastModified() + ":" + packPngFile.length() + ":" + packPngFile.lastModified();
    }

    private boolean isTexturePack(File file) {
        if (file.isDirectory()) {
            return new File(file, "pack.txt").exists() || new File(file, "manifest.json").exists();
        }
        return file.getName().toLowerCase().endsWith(".zip");
    }

    public List<TexturePack> availableTexturePacks() {
        return new ArrayList<TexturePack>(this.availableTexturePacks);
    }

    public TexturePack getDefaultTexturePack() {
        return this.defaultTexturePack;
    }
}

